/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectInserter$Formatter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.notes.FanoutBucket$1;
import org.eclipse.jgit.notes.FanoutBucket$LazyNoteBucket;
import org.eclipse.jgit.notes.InMemoryNoteBucket;
import org.eclipse.jgit.notes.LeafBucket;
import org.eclipse.jgit.notes.NonNoteEntry;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteBucket;

class FanoutBucket
extends InMemoryNoteBucket {
    private final NoteBucket[] table = new NoteBucket[256];
    private int cnt;
    private static final byte[] hexchar = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    FanoutBucket(int n2) {
        super(n2);
    }

    void setBucket(int n2, ObjectId objectId) {
        this.table[n2] = new FanoutBucket$LazyNoteBucket(this, objectId);
        ++this.cnt;
    }

    void setBucket(int n2, InMemoryNoteBucket inMemoryNoteBucket) {
        this.table[n2] = inMemoryNoteBucket;
        ++this.cnt;
    }

    @Override
    Note getNote(AnyObjectId anyObjectId, ObjectReader objectReader) {
        NoteBucket noteBucket = this.table[this.cell(anyObjectId)];
        return noteBucket != null ? noteBucket.getNote(anyObjectId, objectReader) : null;
    }

    NoteBucket getBucket(int n2) {
        return this.table[n2];
    }

    static InMemoryNoteBucket loadIfLazy(NoteBucket noteBucket, AnyObjectId anyObjectId, ObjectReader objectReader) {
        if (noteBucket == null) {
            return null;
        }
        if (noteBucket instanceof InMemoryNoteBucket) {
            return (InMemoryNoteBucket)noteBucket;
        }
        return FanoutBucket$LazyNoteBucket.access$000((FanoutBucket$LazyNoteBucket)noteBucket, anyObjectId, objectReader);
    }

    @Override
    Iterator iterator(AnyObjectId anyObjectId, ObjectReader objectReader) {
        MutableObjectId mutableObjectId = new MutableObjectId();
        mutableObjectId.fromObjectId(anyObjectId);
        return new FanoutBucket$1(this, mutableObjectId, objectReader);
    }

    @Override
    int estimateSize(AnyObjectId anyObjectId, ObjectReader objectReader) {
        if (192 <= this.cnt) {
            return 257;
        }
        MutableObjectId mutableObjectId = new MutableObjectId();
        mutableObjectId.fromObjectId(anyObjectId);
        int n2 = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            NoteBucket noteBucket = this.table[i2];
            if (noteBucket == null) continue;
            mutableObjectId.setByte(this.prefixLen >> 1, i2);
            if (256 < (n2 += noteBucket.estimateSize(mutableObjectId, objectReader))) break;
        }
        return n2;
    }

    @Override
    InMemoryNoteBucket set(AnyObjectId anyObjectId, AnyObjectId anyObjectId2, ObjectReader objectReader) {
        int n2 = this.cell(anyObjectId);
        NoteBucket noteBucket = this.table[n2];
        if (noteBucket == null) {
            if (anyObjectId2 == null) {
                return this;
            }
            LeafBucket leafBucket = new LeafBucket(this.prefixLen + 2);
            this.table[n2] = leafBucket.set(anyObjectId, anyObjectId2, objectReader);
            ++this.cnt;
            return this;
        }
        InMemoryNoteBucket inMemoryNoteBucket = noteBucket.set(anyObjectId, anyObjectId2, objectReader);
        if (inMemoryNoteBucket == null) {
            this.table[n2] = null;
            --this.cnt;
            if (this.cnt == 0) {
                return null;
            }
            return this.contractIfTooSmall(anyObjectId, objectReader);
        }
        if (inMemoryNoteBucket != noteBucket) {
            this.table[n2] = inMemoryNoteBucket;
        }
        return this;
    }

    InMemoryNoteBucket contractIfTooSmall(AnyObjectId anyObjectId, ObjectReader objectReader) {
        if (this.estimateSize(anyObjectId, objectReader) < 256) {
            InMemoryNoteBucket inMemoryNoteBucket = new LeafBucket(this.prefixLen);
            Iterator iterator = this.iterator(anyObjectId, objectReader);
            while (iterator.hasNext()) {
                inMemoryNoteBucket = ((InMemoryNoteBucket)inMemoryNoteBucket).append((Note)iterator.next());
            }
            inMemoryNoteBucket.nonNotes = this.nonNotes;
            return inMemoryNoteBucket;
        }
        return this;
    }

    @Override
    ObjectId writeTree(ObjectInserter objectInserter) {
        return objectInserter.insert(this.build(true, objectInserter));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    ObjectId getTreeId() {
        try (ObjectInserter$Formatter objectInserter$Formatter = new ObjectInserter$Formatter();){
            ObjectId objectId = objectInserter$Formatter.idFor(this.build(false, null));
            return objectId;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private TreeFormatter build(boolean bl2, ObjectInserter objectInserter) {
        byte[] byArray = new byte[2];
        TreeFormatter treeFormatter = new TreeFormatter(this.treeSize());
        NonNoteEntry nonNoteEntry = this.nonNotes;
        for (int i2 = 0; i2 < 256; ++i2) {
            NoteBucket noteBucket = this.table[i2];
            if (noteBucket == null) continue;
            byArray[0] = hexchar[i2 >>> 4];
            byArray[1] = hexchar[i2 & 0xF];
            while (nonNoteEntry != null && nonNoteEntry.pathCompare(byArray, 0, 2, FileMode.TREE) < 0) {
                nonNoteEntry.format(treeFormatter);
                nonNoteEntry = nonNoteEntry.next;
            }
            ObjectId objectId = bl2 ? noteBucket.writeTree(objectInserter) : noteBucket.getTreeId();
            treeFormatter.append(byArray, 0, 2, FileMode.TREE, objectId);
        }
        while (nonNoteEntry != null) {
            nonNoteEntry.format(treeFormatter);
            nonNoteEntry = nonNoteEntry.next;
        }
        return treeFormatter;
    }

    private int treeSize() {
        int n2 = this.cnt * TreeFormatter.entrySize(FileMode.TREE, 2);
        NonNoteEntry nonNoteEntry = this.nonNotes;
        while (nonNoteEntry != null) {
            n2 += nonNoteEntry.treeEntrySize();
            nonNoteEntry = nonNoteEntry.next;
        }
        return n2;
    }

    @Override
    InMemoryNoteBucket append(Note note) {
        int n2 = this.cell(note);
        InMemoryNoteBucket inMemoryNoteBucket = (InMemoryNoteBucket)this.table[n2];
        if (inMemoryNoteBucket == null) {
            LeafBucket leafBucket = new LeafBucket(this.prefixLen + 2);
            this.table[n2] = leafBucket.append(note);
            ++this.cnt;
        } else {
            InMemoryNoteBucket inMemoryNoteBucket2 = inMemoryNoteBucket.append(note);
            if (inMemoryNoteBucket2 != inMemoryNoteBucket) {
                this.table[n2] = inMemoryNoteBucket2;
            }
        }
        return this;
    }

    private int cell(AnyObjectId anyObjectId) {
        return anyObjectId.getByte(this.prefixLen >> 1);
    }

    static /* synthetic */ NoteBucket[] access$100(FanoutBucket fanoutBucket) {
        return fanoutBucket.table;
    }

    static /* synthetic */ int access$200(FanoutBucket fanoutBucket, AnyObjectId anyObjectId) {
        return fanoutBucket.cell(anyObjectId);
    }
}

