/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.nls;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jgit.errors.TranslationBundleLoadingException;
import org.eclipse.jgit.errors.TranslationStringMissingException;

public abstract class TranslationBundle {
    private Locale effectiveLocale;
    private ResourceBundle resourceBundle;

    public Locale effectiveLocale() {
        return this.effectiveLocale;
    }

    public ResourceBundle resourceBundle() {
        return this.resourceBundle;
    }

    void load(Locale locale) {
        Class<?> clazz = this.getClass();
        try {
            this.resourceBundle = ResourceBundle.getBundle(clazz.getName(), locale, clazz.getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            throw new TranslationBundleLoadingException(clazz, locale, missingResourceException);
        }
        this.effectiveLocale = this.resourceBundle.getLocale();
        for (Field field : clazz.getFields()) {
            if (!field.getType().equals(String.class)) continue;
            try {
                String string = this.resourceBundle.getString(field.getName());
                field.set(this, string);
            }
            catch (MissingResourceException missingResourceException) {
                throw new TranslationStringMissingException(clazz, locale, field.getName(), (Exception)missingResourceException);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new Error(exception);
            }
        }
    }
}

