/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.nls;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.nls.GlobalBundleCache;
import org.eclipse.jgit.nls.TranslationBundle;

public class NLS {
    public static final Locale ROOT_LOCALE = new Locale("", "", "");
    private static final InheritableThreadLocal local = new InheritableThreadLocal();
    private final Locale locale;
    private final Map map = new ConcurrentHashMap();

    public static void setLocale(Locale locale) {
        local.set(new NLS(locale));
    }

    public static void useJVMDefaultLocale() {
        NLS.useJVMDefaultInternal();
    }

    private static NLS useJVMDefaultInternal() {
        NLS nLS = new NLS(Locale.getDefault());
        local.set(nLS);
        return nLS;
    }

    public static TranslationBundle getBundleFor(Class clazz) {
        NLS nLS = (NLS)local.get();
        if (nLS == null) {
            nLS = NLS.useJVMDefaultInternal();
        }
        return nLS.get(clazz);
    }

    public static void clear() {
        local.remove();
        GlobalBundleCache.clear();
    }

    private NLS(Locale locale) {
        this.locale = locale;
    }

    private TranslationBundle get(Class clazz) {
        TranslationBundle translationBundle;
        TranslationBundle translationBundle2 = (TranslationBundle)this.map.get(clazz);
        if (translationBundle2 == null && (translationBundle = this.map.putIfAbsent(clazz, translationBundle2 = GlobalBundleCache.lookupBundle(this.locale, clazz))) != null) {
            translationBundle2 = translationBundle;
        }
        return translationBundle2;
    }
}

