/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;

public abstract class ThreeWayMerger
extends Merger {
    private RevTree baseTree;
    private ObjectId baseCommitId;

    protected ThreeWayMerger(Repository repository) {
        super(repository);
    }

    protected ThreeWayMerger(Repository repository, boolean bl2) {
        this(repository);
    }

    protected ThreeWayMerger(ObjectInserter objectInserter) {
        super(objectInserter);
    }

    public void setBase(AnyObjectId anyObjectId) {
        this.baseTree = anyObjectId != null ? this.walk.parseTree(anyObjectId) : null;
    }

    @Override
    public boolean merge(AnyObjectId ... anyObjectIdArray) {
        if (anyObjectIdArray.length != 2) {
            return false;
        }
        return super.merge(anyObjectIdArray);
    }

    @Override
    public ObjectId getBaseCommitId() {
        return this.baseCommitId;
    }

    protected AbstractTreeIterator mergeBase() {
        RevCommit revCommit;
        if (this.baseTree != null) {
            return this.openTree(this.baseTree);
        }
        RevCommit revCommit2 = revCommit = this.baseCommitId != null ? this.walk.parseCommit(this.baseCommitId) : this.getBaseCommit(this.sourceCommits[0], this.sourceCommits[1]);
        if (revCommit == null) {
            this.baseCommitId = null;
            return new EmptyTreeIterator();
        }
        this.baseCommitId = revCommit.toObjectId();
        return this.openTree(revCommit.getTree());
    }
}

