/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;

class StrategySimpleTwoWayInCore$InCoreMerger
extends ThreeWayMerger {
    private static final int T_BASE = 0;
    private static final int T_OURS = 1;
    private static final int T_THEIRS = 2;
    private final NameConflictTreeWalk tw;
    private final DirCache cache;
    private DirCacheBuilder builder;
    private ObjectId resultTree;

    StrategySimpleTwoWayInCore$InCoreMerger(Repository repository) {
        super(repository);
        this.tw = new NameConflictTreeWalk(repository, this.reader);
        this.cache = DirCache.newInCore();
    }

    StrategySimpleTwoWayInCore$InCoreMerger(ObjectInserter objectInserter) {
        super(objectInserter);
        this.tw = new NameConflictTreeWalk(null, this.reader);
        this.cache = DirCache.newInCore();
    }

    @Override
    protected boolean mergeImpl() {
        this.tw.addTree(this.mergeBase());
        this.tw.addTree(this.sourceTrees[0]);
        this.tw.addTree(this.sourceTrees[1]);
        boolean bl2 = false;
        this.builder = this.cache.builder();
        while (this.tw.next()) {
            int n2;
            int n3 = this.tw.getRawMode(1);
            if (n3 == (n2 = this.tw.getRawMode(2)) && this.tw.idEqual(1, 2)) {
                this.add(1, 0);
                continue;
            }
            int n4 = this.tw.getRawMode(0);
            if (n4 == n3 && this.tw.idEqual(0, 1)) {
                this.add(2, 0);
                continue;
            }
            if (n4 == n2 && this.tw.idEqual(0, 2)) {
                this.add(1, 0);
                continue;
            }
            if (StrategySimpleTwoWayInCore$InCoreMerger.nonTree(n4)) {
                this.add(0, 1);
                bl2 = true;
            }
            if (StrategySimpleTwoWayInCore$InCoreMerger.nonTree(n3)) {
                this.add(1, 2);
                bl2 = true;
            }
            if (StrategySimpleTwoWayInCore$InCoreMerger.nonTree(n2)) {
                this.add(2, 3);
                bl2 = true;
            }
            if (!this.tw.isSubtree()) continue;
            this.tw.enterSubtree();
        }
        this.builder.finish();
        this.builder = null;
        if (bl2) {
            return false;
        }
        try {
            ObjectInserter objectInserter = this.getObjectInserter();
            this.resultTree = this.cache.writeTree(objectInserter);
            objectInserter.flush();
            return true;
        }
        catch (UnmergedPathException unmergedPathException) {
            this.resultTree = null;
            return false;
        }
    }

    private static boolean nonTree(int n2) {
        return n2 != 0 && !FileMode.TREE.equals(n2);
    }

    private void add(int n2, int n3) {
        AbstractTreeIterator abstractTreeIterator = this.getTree(n2);
        if (abstractTreeIterator != null) {
            if (FileMode.TREE.equals(this.tw.getRawMode(n2))) {
                this.builder.addTree(this.tw.getRawPath(), n3, this.reader, this.tw.getObjectId(n2));
            } else {
                DirCacheEntry dirCacheEntry = new DirCacheEntry(this.tw.getRawPath(), n3);
                dirCacheEntry.setObjectIdFromRaw(abstractTreeIterator.idBuffer(), abstractTreeIterator.idOffset());
                dirCacheEntry.setFileMode(this.tw.getFileMode(n2));
                this.builder.add(dirCacheEntry);
            }
        }
    }

    private AbstractTreeIterator getTree(int n2) {
        return this.tw.getTree(n2, AbstractTreeIterator.class);
    }

    @Override
    public ObjectId getResultTreeId() {
        return this.resultTree;
    }
}

