/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.util.List;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.jgit.util.GitDateFormatter$Format;

public class SquashMessageFormatter {
    private GitDateFormatter dateFormatter = new GitDateFormatter(GitDateFormatter$Format.DEFAULT);

    public String format(List list, Ref ref) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Squashed commit of the following:\n");
        for (RevCommit revCommit : list) {
            stringBuilder.append("\ncommit ");
            stringBuilder.append(revCommit.getName());
            stringBuilder.append("\n");
            stringBuilder.append(this.toString(revCommit.getAuthorIdent()));
            stringBuilder.append("\n\t");
            stringBuilder.append(revCommit.getShortMessage());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private String toString(PersonIdent personIdent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Author: ");
        stringBuilder.append(personIdent.getName());
        stringBuilder.append(" <");
        stringBuilder.append(personIdent.getEmailAddress());
        stringBuilder.append(">\n");
        stringBuilder.append("Date:   ");
        stringBuilder.append(this.dateFormatter.formatDate(personIdent));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

