/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.DiffAlgorithm$SupportedAlgorithm;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.dircache.Checkout;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout$CheckoutMetadata;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.errors.IndexWriteException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeAlgorithm;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.ResolveMerger$MergeFailureReason;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.submodule.SubmoduleConflict;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.LfsFactory$LfsInputStream;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.TemporaryBuffer$LocalFile;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;

public class ResolveMerger
extends ThreeWayMerger {
    private Checkout checkout;
    protected NameConflictTreeWalk tw;
    protected String[] commitNames;
    protected static final int T_BASE = 0;
    protected static final int T_OURS = 1;
    protected static final int T_THEIRS = 2;
    protected static final int T_INDEX = 3;
    protected static final int T_FILE = 4;
    protected DirCacheBuilder builder;
    protected ObjectId resultTree;
    protected List unmergedPaths = new ArrayList();
    protected List modifiedFiles = new LinkedList();
    protected Map toBeCheckedOut = new HashMap();
    protected List toBeDeleted = new ArrayList();
    protected Map mergeResults = new HashMap();
    protected Map failingPaths = new HashMap();
    protected boolean enterSubtree;
    protected boolean inCore;
    protected boolean implicitDirCache;
    protected DirCache dircache;
    protected WorkingTreeIterator workingTreeIterator;
    protected MergeAlgorithm mergeAlgorithm;
    protected WorkingTreeOptions workingTreeOptions;
    private int inCoreLimit;
    @NonNull
    private ContentMergeStrategy contentStrategy = ContentMergeStrategy.CONFLICT;
    private Map checkoutMetadata;
    private static final Attributes NO_ATTRIBUTES = new Attributes(new Attribute[0]);

    private static MergeAlgorithm getMergeAlgorithm(Config config) {
        DiffAlgorithm$SupportedAlgorithm diffAlgorithm$SupportedAlgorithm = (DiffAlgorithm$SupportedAlgorithm)config.getEnum("diff", null, "algorithm", DiffAlgorithm$SupportedAlgorithm.HISTOGRAM);
        return new MergeAlgorithm(DiffAlgorithm.getAlgorithm(diffAlgorithm$SupportedAlgorithm));
    }

    private static int getInCoreLimit(Config config) {
        return config.getInt("merge", "inCoreLimit", 0xA00000);
    }

    private static String[] defaultCommitNames() {
        return new String[]{"BASE", "OURS", "THEIRS"};
    }

    protected ResolveMerger(Repository repository, boolean bl2) {
        super(repository);
        StoredConfig storedConfig = repository.getConfig();
        this.mergeAlgorithm = ResolveMerger.getMergeAlgorithm(storedConfig);
        this.inCoreLimit = ResolveMerger.getInCoreLimit(storedConfig);
        this.commitNames = ResolveMerger.defaultCommitNames();
        this.inCore = bl2;
        if (bl2) {
            this.implicitDirCache = false;
            this.dircache = DirCache.newInCore();
        } else {
            this.implicitDirCache = true;
            this.workingTreeOptions = (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY);
        }
        this.checkout = new Checkout(this.nonNullRepo(), this.workingTreeOptions);
    }

    protected ResolveMerger(Repository repository) {
        this(repository, false);
    }

    protected ResolveMerger(ObjectInserter objectInserter, Config config) {
        super(objectInserter);
        this.mergeAlgorithm = ResolveMerger.getMergeAlgorithm(config);
        this.commitNames = ResolveMerger.defaultCommitNames();
        this.inCore = true;
        this.implicitDirCache = false;
        this.dircache = DirCache.newInCore();
    }

    @NonNull
    public ContentMergeStrategy getContentMergeStrategy() {
        return this.contentStrategy;
    }

    public void setContentMergeStrategy(ContentMergeStrategy contentMergeStrategy) {
        this.contentStrategy = contentMergeStrategy == null ? ContentMergeStrategy.CONFLICT : contentMergeStrategy;
    }

    @Override
    protected boolean mergeImpl() {
        if (this.implicitDirCache) {
            this.dircache = this.nonNullRepo().lockDirCache();
        }
        if (!this.inCore) {
            this.checkoutMetadata = new HashMap();
        }
        try {
            boolean bl2 = this.mergeTrees(this.mergeBase(), this.sourceTrees[0], this.sourceTrees[1], false);
            return bl2;
        }
        finally {
            this.checkoutMetadata = null;
            if (this.implicitDirCache) {
                this.dircache.unlock();
            }
        }
    }

    private void checkout() {
        Object object;
        for (int i2 = this.toBeDeleted.size() - 1; i2 >= 0; --i2) {
            String object2 = (String)this.toBeDeleted.get(i2);
            object = new File(this.nonNullRepo().getWorkTree(), object2);
            if (!((File)object).delete() && !((File)object).isDirectory()) {
                this.failingPaths.put(object2, ResolveMerger$MergeFailureReason.COULD_NOT_DELETE);
            }
            this.modifiedFiles.add(object2);
        }
        for (Map.Entry entry : this.toBeCheckedOut.entrySet()) {
            object = (DirCacheEntry)entry.getValue();
            String string = (String)entry.getKey();
            if (((DirCacheEntry)object).getFileMode() == FileMode.GITLINK) {
                this.checkout.checkoutGitlink((DirCacheEntry)object, string);
                continue;
            }
            this.checkout.checkout((DirCacheEntry)object, (DirCacheCheckout$CheckoutMetadata)this.checkoutMetadata.get(entry.getKey()), this.reader, string);
            this.modifiedFiles.add(string);
        }
    }

    protected void cleanUp() {
        if (this.inCore) {
            this.modifiedFiles.clear();
            return;
        }
        DirCache dirCache = this.nonNullRepo().readDirCache();
        Iterator iterator = this.modifiedFiles.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            DirCacheEntry dirCacheEntry = dirCache.getEntry(string);
            if (dirCacheEntry != null) {
                this.checkout.checkout(dirCacheEntry, (DirCacheCheckout$CheckoutMetadata)this.checkoutMetadata.get(string), this.reader, string);
            }
            iterator.remove();
        }
    }

    private DirCacheEntry add(byte[] byArray, CanonicalTreeParser canonicalTreeParser, int n2, Instant instant, long l2) {
        if (canonicalTreeParser != null && !canonicalTreeParser.getEntryFileMode().equals(FileMode.TREE)) {
            DirCacheEntry dirCacheEntry = new DirCacheEntry(byArray, n2);
            dirCacheEntry.setFileMode(canonicalTreeParser.getEntryFileMode());
            dirCacheEntry.setObjectId(canonicalTreeParser.getEntryObjectId());
            dirCacheEntry.setLastModified(instant);
            dirCacheEntry.setLength(l2);
            this.builder.add(dirCacheEntry);
            return dirCacheEntry;
        }
        return null;
    }

    private DirCacheEntry keep(DirCacheEntry dirCacheEntry) {
        DirCacheEntry dirCacheEntry2 = new DirCacheEntry(dirCacheEntry.getRawPath(), dirCacheEntry.getStage());
        dirCacheEntry2.setFileMode(dirCacheEntry.getFileMode());
        dirCacheEntry2.setObjectId(dirCacheEntry.getObjectId());
        dirCacheEntry2.setLastModified(dirCacheEntry.getLastModifiedInstant());
        dirCacheEntry2.setLength(dirCacheEntry.getLength());
        this.builder.add(dirCacheEntry2);
        return dirCacheEntry2;
    }

    protected void addCheckoutMetadata(String string, Attributes attributes) {
        if (this.checkoutMetadata != null) {
            CoreConfig.EolStreamType eolStreamType = EolStreamTypeUtil.detectStreamType(TreeWalk$OperationType.CHECKOUT_OP, this.workingTreeOptions, attributes);
            DirCacheCheckout$CheckoutMetadata dirCacheCheckout$CheckoutMetadata = new DirCacheCheckout$CheckoutMetadata(eolStreamType, this.tw.getFilterCommand("smudge"));
            this.checkoutMetadata.put(string, dirCacheCheckout$CheckoutMetadata);
        }
    }

    protected void addToCheckout(String string, DirCacheEntry dirCacheEntry, Attributes attributes) {
        this.toBeCheckedOut.put(string, dirCacheEntry);
        this.addCheckoutMetadata(string, attributes);
    }

    protected void addDeletion(String string, boolean bl2, Attributes attributes) {
        this.toBeDeleted.add(string);
        if (bl2) {
            this.addCheckoutMetadata(string, attributes);
        }
    }

    protected boolean processEntry(CanonicalTreeParser canonicalTreeParser, CanonicalTreeParser canonicalTreeParser2, CanonicalTreeParser canonicalTreeParser3, DirCacheBuildIterator dirCacheBuildIterator, WorkingTreeIterator workingTreeIterator, boolean bl2, Attributes attributes) {
        boolean bl3;
        this.enterSubtree = true;
        int n2 = this.tw.getRawMode(1);
        int n3 = this.tw.getRawMode(2);
        int n4 = this.tw.getRawMode(0);
        boolean bl4 = bl3 = ResolveMerger.isGitLink(n2) || ResolveMerger.isGitLink(n3) || ResolveMerger.isGitLink(n4);
        if (n2 == 0 && n3 == 0 && n4 == 0) {
            return true;
        }
        if (this.isIndexDirty()) {
            return false;
        }
        DirCacheEntry dirCacheEntry = null;
        if (dirCacheBuildIterator == null || dirCacheBuildIterator.getDirCacheEntry() == null) {
            if (ResolveMerger.nonTree(n2)) {
                dirCacheEntry = new DirCacheEntry(this.tw.getRawPath());
                dirCacheEntry.setObjectId(this.tw.getObjectId(1));
                dirCacheEntry.setFileMode(this.tw.getFileMode(1));
            }
        } else {
            dirCacheEntry = dirCacheBuildIterator.getDirCacheEntry();
        }
        if (ResolveMerger.nonTree(n2) && ResolveMerger.nonTree(n3) && this.tw.idEqual(1, 2)) {
            if (n2 == n3) {
                this.keep(dirCacheEntry);
                return true;
            }
            int n5 = this.mergeFileModes(n4, n2, n3);
            if (n5 != FileMode.MISSING.getBits()) {
                if (n5 == n2) {
                    this.keep(dirCacheEntry);
                } else {
                    if (this.isWorktreeDirty(workingTreeIterator, dirCacheEntry)) {
                        return false;
                    }
                    DirCacheEntry dirCacheEntry2 = this.add(this.tw.getRawPath(), canonicalTreeParser3, 0, Instant.EPOCH, 0L);
                    this.addToCheckout(this.tw.getPathString(), dirCacheEntry2, attributes);
                }
                return true;
            }
            if (!bl2) {
                this.add(this.tw.getRawPath(), canonicalTreeParser, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), canonicalTreeParser2, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), canonicalTreeParser3, 3, Instant.EPOCH, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                this.mergeResults.put(this.tw.getPathString(), new MergeResult(Collections.emptyList()));
            }
            return true;
        }
        if (n4 == n3 && this.tw.idEqual(0, 2)) {
            if (dirCacheEntry != null) {
                this.keep(dirCacheEntry);
            }
            return true;
        }
        if (n4 == n2 && this.tw.idEqual(0, 1)) {
            if (this.isWorktreeDirty(workingTreeIterator, dirCacheEntry)) {
                return false;
            }
            if (ResolveMerger.nonTree(n3)) {
                DirCacheEntry dirCacheEntry3 = this.add(this.tw.getRawPath(), canonicalTreeParser3, 0, Instant.EPOCH, 0L);
                if (dirCacheEntry3 != null) {
                    this.addToCheckout(this.tw.getPathString(), dirCacheEntry3, attributes);
                }
                return true;
            }
            if (this.tw.getTreeCount() > 4 && this.tw.getRawMode(4) == 0) {
                return true;
            }
            if (n3 != 0 && n3 == n4) {
                return true;
            }
            this.addDeletion(this.tw.getPathString(), ResolveMerger.nonTree(n2), attributes);
            return true;
        }
        if (this.tw.isSubtree()) {
            if (ResolveMerger.nonTree(n2) != ResolveMerger.nonTree(n3)) {
                if (bl2) {
                    this.enterSubtree = false;
                    return true;
                }
                if (ResolveMerger.nonTree(n4)) {
                    this.add(this.tw.getRawPath(), canonicalTreeParser, 1, Instant.EPOCH, 0L);
                }
                if (ResolveMerger.nonTree(n2)) {
                    this.add(this.tw.getRawPath(), canonicalTreeParser2, 2, Instant.EPOCH, 0L);
                }
                if (ResolveMerger.nonTree(n3)) {
                    this.add(this.tw.getRawPath(), canonicalTreeParser3, 3, Instant.EPOCH, 0L);
                }
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (!ResolveMerger.nonTree(n2)) {
                return true;
            }
        }
        if (ResolveMerger.nonTree(n2) && ResolveMerger.nonTree(n3)) {
            boolean bl5 = this.isWorktreeDirty(workingTreeIterator, dirCacheEntry);
            if (!attributes.canBeContentMerged() && bl5) {
                return false;
            }
            if (bl3 && bl2) {
                this.add(this.tw.getRawPath(), canonicalTreeParser2, 0, Instant.EPOCH, 0L);
                return true;
            }
            if (bl3) {
                this.add(this.tw.getRawPath(), canonicalTreeParser, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), canonicalTreeParser2, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), canonicalTreeParser3, 3, Instant.EPOCH, 0L);
                MergeResult mergeResult = ResolveMerger.createGitLinksMergeResult(canonicalTreeParser, canonicalTreeParser2, canonicalTreeParser3);
                mergeResult.setContainsConflicts(true);
                this.mergeResults.put(this.tw.getPathString(), mergeResult);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            if (!attributes.canBeContentMerged()) {
                switch (this.getContentMergeStrategy()) {
                    case OURS: {
                        this.keep(dirCacheEntry);
                        return true;
                    }
                    case THEIRS: {
                        DirCacheEntry dirCacheEntry4 = this.add(this.tw.getRawPath(), canonicalTreeParser3, 0, Instant.EPOCH, 0L);
                        this.addToCheckout(this.tw.getPathString(), dirCacheEntry4, attributes);
                        return true;
                    }
                }
                this.add(this.tw.getRawPath(), canonicalTreeParser, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), canonicalTreeParser2, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), canonicalTreeParser3, 3, Instant.EPOCH, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            if (bl5) {
                return false;
            }
            MergeResult mergeResult = null;
            try {
                mergeResult = this.contentMerge(canonicalTreeParser, canonicalTreeParser2, canonicalTreeParser3, attributes, this.getContentMergeStrategy());
            }
            catch (BinaryBlobException binaryBlobException) {
                switch (this.getContentMergeStrategy()) {
                    case OURS: {
                        this.keep(dirCacheEntry);
                        return true;
                    }
                    case THEIRS: {
                        DirCacheEntry dirCacheEntry5 = this.add(this.tw.getRawPath(), canonicalTreeParser3, 0, Instant.EPOCH, 0L);
                        this.addToCheckout(this.tw.getPathString(), dirCacheEntry5, attributes);
                        return true;
                    }
                }
                mergeResult = new MergeResult(Collections.emptyList());
                mergeResult.setContainsConflicts(true);
            }
            if (bl2) {
                mergeResult.setContainsConflicts(false);
            }
            this.updateIndex(canonicalTreeParser, canonicalTreeParser2, canonicalTreeParser3, mergeResult, attributes);
            String string = this.tw.getPathString();
            if (mergeResult.containsConflicts() && !bl2) {
                this.unmergedPaths.add(string);
            }
            this.modifiedFiles.add(string);
            this.addCheckoutMetadata(string, attributes);
        } else if (n2 != n3 && (n2 != 0 && !this.tw.idEqual(0, 1) || n3 != 0 && !this.tw.idEqual(0, 2))) {
            if (bl3 && bl2) {
                this.add(this.tw.getRawPath(), canonicalTreeParser2, 0, Instant.EPOCH, 0L);
            } else if (bl3) {
                this.add(this.tw.getRawPath(), canonicalTreeParser, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), canonicalTreeParser2, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), canonicalTreeParser3, 3, Instant.EPOCH, 0L);
                MergeResult mergeResult = ResolveMerger.createGitLinksMergeResult(canonicalTreeParser, canonicalTreeParser2, canonicalTreeParser3);
                mergeResult.setContainsConflicts(true);
                this.mergeResults.put(this.tw.getPathString(), mergeResult);
                this.unmergedPaths.add(this.tw.getPathString());
            } else {
                MergeResult mergeResult;
                try {
                    mergeResult = this.contentMerge(canonicalTreeParser, canonicalTreeParser2, canonicalTreeParser3, attributes, ContentMergeStrategy.CONFLICT);
                }
                catch (BinaryBlobException binaryBlobException) {
                    mergeResult = new MergeResult(Collections.emptyList());
                    mergeResult.setContainsConflicts(true);
                }
                if (bl2) {
                    mergeResult.setContainsConflicts(false);
                    this.updateIndex(canonicalTreeParser, canonicalTreeParser2, canonicalTreeParser3, mergeResult, attributes);
                } else {
                    this.add(this.tw.getRawPath(), canonicalTreeParser, 1, Instant.EPOCH, 0L);
                    this.add(this.tw.getRawPath(), canonicalTreeParser2, 2, Instant.EPOCH, 0L);
                    DirCacheEntry dirCacheEntry6 = this.add(this.tw.getRawPath(), canonicalTreeParser3, 3, Instant.EPOCH, 0L);
                    if (n2 == 0) {
                        if (this.isWorktreeDirty(workingTreeIterator, dirCacheEntry)) {
                            return false;
                        }
                        if (ResolveMerger.nonTree(n3) && dirCacheEntry6 != null) {
                            this.addToCheckout(this.tw.getPathString(), dirCacheEntry6, attributes);
                        }
                    }
                    this.unmergedPaths.add(this.tw.getPathString());
                    this.mergeResults.put(this.tw.getPathString(), mergeResult);
                }
            }
        }
        return true;
    }

    private static MergeResult createGitLinksMergeResult(CanonicalTreeParser canonicalTreeParser, CanonicalTreeParser canonicalTreeParser2, CanonicalTreeParser canonicalTreeParser3) {
        return new MergeResult(Arrays.asList(new SubmoduleConflict(canonicalTreeParser == null ? null : canonicalTreeParser.getEntryObjectId()), new SubmoduleConflict(canonicalTreeParser2 == null ? null : canonicalTreeParser2.getEntryObjectId()), new SubmoduleConflict(canonicalTreeParser3 == null ? null : canonicalTreeParser3.getEntryObjectId())));
    }

    private MergeResult contentMerge(CanonicalTreeParser canonicalTreeParser, CanonicalTreeParser canonicalTreeParser2, CanonicalTreeParser canonicalTreeParser3, Attributes attributes, ContentMergeStrategy contentMergeStrategy) {
        RawText rawText = canonicalTreeParser == null ? RawText.EMPTY_TEXT : this.getRawText(canonicalTreeParser.getEntryObjectId(), attributes);
        RawText rawText2 = canonicalTreeParser2 == null ? RawText.EMPTY_TEXT : this.getRawText(canonicalTreeParser2.getEntryObjectId(), attributes);
        RawText rawText3 = canonicalTreeParser3 == null ? RawText.EMPTY_TEXT : this.getRawText(canonicalTreeParser3.getEntryObjectId(), attributes);
        this.mergeAlgorithm.setContentMergeStrategy(contentMergeStrategy);
        return this.mergeAlgorithm.merge(RawTextComparator.DEFAULT, rawText, rawText2, rawText3);
    }

    private boolean isIndexDirty() {
        boolean bl2;
        if (this.inCore) {
            return false;
        }
        int n2 = this.tw.getRawMode(3);
        int n3 = this.tw.getRawMode(1);
        boolean bl3 = bl2 = ResolveMerger.nonTree(n2) && (n3 != n2 || !this.tw.idEqual(3, 1));
        if (bl2) {
            this.failingPaths.put(this.tw.getPathString(), ResolveMerger$MergeFailureReason.DIRTY_INDEX);
        }
        return bl2;
    }

    private boolean isWorktreeDirty(WorkingTreeIterator workingTreeIterator, DirCacheEntry dirCacheEntry) {
        boolean bl2;
        if (workingTreeIterator == null) {
            return false;
        }
        int n2 = this.tw.getRawMode(4);
        int n3 = this.tw.getRawMode(1);
        if (dirCacheEntry != null) {
            bl2 = workingTreeIterator.isModified(dirCacheEntry, true, this.reader);
        } else {
            bl2 = workingTreeIterator.isModeDifferent(n3);
            if (!bl2 && ResolveMerger.nonTree(n2)) {
                boolean bl3 = bl2 = !this.tw.idEqual(4, 1);
            }
        }
        if (bl2 && n2 == 16384 && n3 == 0) {
            bl2 = false;
        }
        if (bl2) {
            this.failingPaths.put(this.tw.getPathString(), ResolveMerger$MergeFailureReason.DIRTY_WORKTREE);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndex(CanonicalTreeParser canonicalTreeParser, CanonicalTreeParser canonicalTreeParser2, CanonicalTreeParser canonicalTreeParser3, MergeResult mergeResult, Attributes attributes) {
        TemporaryBuffer temporaryBuffer = null;
        try {
            File file;
            temporaryBuffer = this.doMerge(mergeResult);
            File file2 = file = this.inCore ? null : this.writeMergedFile(temporaryBuffer, attributes);
            if (mergeResult.containsConflicts()) {
                this.add(this.tw.getRawPath(), canonicalTreeParser, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), canonicalTreeParser2, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), canonicalTreeParser3, 3, Instant.EPOCH, 0L);
                this.mergeResults.put(this.tw.getPathString(), mergeResult);
                return;
            }
            DirCacheEntry dirCacheEntry = new DirCacheEntry(this.tw.getPathString());
            int n2 = this.mergeFileModes(this.tw.getRawMode(0), this.tw.getRawMode(1), this.tw.getRawMode(2));
            dirCacheEntry.setFileMode(n2 == FileMode.MISSING.getBits() ? FileMode.REGULAR_FILE : FileMode.fromBits(n2));
            if (file != null) {
                dirCacheEntry.setLastModified(this.nonNullRepo().getFS().lastModifiedInstant(file));
                dirCacheEntry.setLength((int)file.length());
            }
            dirCacheEntry.setObjectId(this.insertMergeResult(temporaryBuffer, attributes));
            this.builder.add(dirCacheEntry);
        }
        finally {
            if (temporaryBuffer != null) {
                temporaryBuffer.destroy();
            }
        }
    }

    private File writeMergedFile(TemporaryBuffer temporaryBuffer, Attributes attributes) {
        File file = this.nonNullRepo().getWorkTree();
        String string = this.tw.getPathString();
        File file2 = new File(file, string);
        CoreConfig.EolStreamType eolStreamType = EolStreamTypeUtil.detectStreamType(TreeWalk$OperationType.CHECKOUT_OP, this.workingTreeOptions, attributes);
        this.checkout.safeCreateParentDirectory(string, file2.getParentFile(), false);
        try (OutputStream outputStream = EolStreamTypeUtil.wrapOutputStream(new BufferedOutputStream(new FileOutputStream(file2)), eolStreamType);){
            temporaryBuffer.writeTo(outputStream, null);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemporaryBuffer doMerge(MergeResult mergeResult) {
        TemporaryBuffer$LocalFile temporaryBuffer$LocalFile = new TemporaryBuffer$LocalFile(this.db != null ? this.nonNullRepo().getDirectory() : null, this.inCoreLimit);
        boolean bl2 = false;
        try {
            new MergeFormatter().formatMerge((OutputStream)temporaryBuffer$LocalFile, mergeResult, Arrays.asList(this.commitNames), StandardCharsets.UTF_8);
            temporaryBuffer$LocalFile.close();
            bl2 = true;
        }
        finally {
            if (!bl2) {
                temporaryBuffer$LocalFile.destroy();
            }
        }
        return temporaryBuffer$LocalFile;
    }

    private ObjectId insertMergeResult(TemporaryBuffer temporaryBuffer, Attributes attributes) {
        InputStream inputStream = temporaryBuffer.openInputStream();
        try (LfsFactory$LfsInputStream lfsFactory$LfsInputStream = LfsFactory.getInstance().applyCleanFilter(this.getRepository(), inputStream, temporaryBuffer.length(), attributes.get("merge"));){
            ObjectId objectId = this.getObjectInserter().insert(3, lfsFactory$LfsInputStream.getLength(), lfsFactory$LfsInputStream);
            return objectId;
        }
    }

    private int mergeFileModes(int n2, int n3, int n4) {
        if (n3 == n4) {
            return n3;
        }
        if (n2 == n3) {
            return n4 == FileMode.MISSING.getBits() ? n3 : n4;
        }
        if (n2 == n4) {
            return n3 == FileMode.MISSING.getBits() ? n4 : n3;
        }
        return FileMode.MISSING.getBits();
    }

    private RawText getRawText(ObjectId objectId, Attributes attributes) {
        if (objectId.equals(ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        ObjectLoader objectLoader = LfsFactory.getInstance().applySmudgeFilter(this.getRepository(), this.reader.open(objectId, 3), attributes.get("merge"));
        int n2 = 0x3200000;
        return RawText.load(objectLoader, n2);
    }

    private static boolean nonTree(int n2) {
        return n2 != 0 && !FileMode.TREE.equals(n2);
    }

    private static boolean isGitLink(int n2) {
        return FileMode.GITLINK.equals(n2);
    }

    @Override
    public ObjectId getResultTreeId() {
        return this.resultTree == null ? null : this.resultTree.toObjectId();
    }

    public void setCommitNames(String[] stringArray) {
        this.commitNames = stringArray;
    }

    public String[] getCommitNames() {
        return this.commitNames;
    }

    public List getUnmergedPaths() {
        return this.unmergedPaths;
    }

    public List getModifiedFiles() {
        return this.modifiedFiles;
    }

    public Map getToBeCheckedOut() {
        return this.toBeCheckedOut;
    }

    public Map getMergeResults() {
        return this.mergeResults;
    }

    public Map getFailingPaths() {
        return this.failingPaths.isEmpty() ? null : this.failingPaths;
    }

    public boolean failed() {
        return !this.failingPaths.isEmpty();
    }

    public void setDirCache(DirCache dirCache) {
        this.dircache = dirCache;
        this.implicitDirCache = false;
    }

    public void setWorkingTreeIterator(WorkingTreeIterator workingTreeIterator) {
        this.workingTreeIterator = workingTreeIterator;
    }

    protected boolean mergeTrees(AbstractTreeIterator abstractTreeIterator, RevTree revTree, RevTree revTree2, boolean bl2) {
        this.builder = this.dircache.builder();
        DirCacheBuildIterator dirCacheBuildIterator = new DirCacheBuildIterator(this.builder);
        this.tw = new NameConflictTreeWalk(this.db, this.reader);
        this.tw.addTree(abstractTreeIterator);
        this.tw.addTree(revTree);
        this.tw.addTree(revTree2);
        int n2 = this.tw.addTree(dirCacheBuildIterator);
        if (this.workingTreeIterator != null) {
            this.tw.addTree(this.workingTreeIterator);
            this.workingTreeIterator.setDirCacheIterator(this.tw, n2);
        } else {
            this.tw.setFilter(TreeFilter.ANY_DIFF);
        }
        if (!this.mergeTreeWalk(this.tw, bl2)) {
            return false;
        }
        if (!this.inCore) {
            this.checkout();
            if (!this.builder.commit()) {
                this.cleanUp();
                throw new IndexWriteException();
            }
            this.builder = null;
        } else {
            this.builder.finish();
            this.builder = null;
        }
        if (this.getUnmergedPaths().isEmpty() && !this.failed()) {
            this.resultTree = this.dircache.writeTree(this.getObjectInserter());
            return true;
        }
        this.resultTree = null;
        return false;
    }

    protected boolean mergeTreeWalk(TreeWalk treeWalk, boolean bl2) {
        boolean bl3;
        boolean bl4 = this.tw.getTreeCount() > 4;
        boolean bl5 = bl3 = treeWalk.getAttributesNodeProvider() != null;
        while (treeWalk.next()) {
            if (!this.processEntry((CanonicalTreeParser)treeWalk.getTree(0, CanonicalTreeParser.class), (CanonicalTreeParser)treeWalk.getTree(1, CanonicalTreeParser.class), (CanonicalTreeParser)treeWalk.getTree(2, CanonicalTreeParser.class), (DirCacheBuildIterator)treeWalk.getTree(3, DirCacheBuildIterator.class), bl4 ? (WorkingTreeIterator)treeWalk.getTree(4, WorkingTreeIterator.class) : null, bl2, bl3 ? treeWalk.getAttributes() : NO_ATTRIBUTES)) {
                this.cleanUp();
                return false;
            }
            if (!treeWalk.isSubtree() || !this.enterSubtree) continue;
            treeWalk.enterSubtree();
        }
        return true;
    }
}

