/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.errors.NoMergeBaseException;
import org.eclipse.jgit.errors.NoMergeBaseException$MergeBaseFailureReason;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;

public class RecursiveMerger
extends ResolveMerger {
    public final int MAX_BASES = 200;

    protected RecursiveMerger(Repository repository, boolean bl2) {
        super(repository, bl2);
    }

    protected RecursiveMerger(Repository repository) {
        this(repository, false);
    }

    protected RecursiveMerger(ObjectInserter objectInserter, Config config) {
        super(objectInserter, config);
    }

    @Override
    protected RevCommit getBaseCommit(RevCommit revCommit, RevCommit revCommit2) {
        return this.getBaseCommit(revCommit, revCommit2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RevCommit getBaseCommit(RevCommit revCommit, RevCommit revCommit2, int n2) {
        RevCommit revCommit3;
        ArrayList<RevCommit> arrayList = new ArrayList<RevCommit>();
        this.walk.reset();
        this.walk.setRevFilter(RevFilter.MERGE_BASE);
        this.walk.markStart(revCommit);
        this.walk.markStart(revCommit2);
        while ((revCommit3 = this.walk.next()) != null) {
            arrayList.add(revCommit3);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (RevCommit)arrayList.get(0);
        }
        if (arrayList.size() >= 200) {
            throw new NoMergeBaseException(NoMergeBaseException$MergeBaseFailureReason.TOO_MANY_MERGE_BASES, MessageFormat.format(JGitText.get().mergeRecursiveTooManyMergeBasesFor, 200, revCommit.name(), revCommit2.name(), arrayList.size()));
        }
        RevCommit revCommit4 = (RevCommit)arrayList.get(0);
        DirCache dirCache = this.dircache;
        boolean bl2 = this.inCore;
        WorkingTreeIterator workingTreeIterator = this.workingTreeIterator;
        this.workingTreeIterator = null;
        try {
            this.dircache = DirCache.read(this.reader, revCommit4.getTree());
            this.inCore = true;
            ArrayList<RevCommit> arrayList2 = new ArrayList<RevCommit>();
            arrayList2.add(revCommit4);
            for (int i2 = 1; i2 < arrayList.size(); ++i2) {
                AbstractTreeIterator abstractTreeIterator;
                RevCommit revCommit5 = (RevCommit)arrayList.get(i2);
                if (i2 >= 200) {
                    throw new NoMergeBaseException(NoMergeBaseException$MergeBaseFailureReason.TOO_MANY_MERGE_BASES, MessageFormat.format(JGitText.get().mergeRecursiveTooManyMergeBasesFor, 200, revCommit.name(), revCommit2.name(), arrayList.size()));
                }
                arrayList2.add(revCommit5);
                RevCommit revCommit6 = this.getBaseCommit(revCommit4, revCommit5, n2 + 1);
                AbstractTreeIterator abstractTreeIterator2 = abstractTreeIterator = revCommit6 == null ? new EmptyTreeIterator() : this.openTree(revCommit6.getTree());
                if (!this.mergeTrees(abstractTreeIterator, revCommit4.getTree(), revCommit5.getTree(), true)) {
                    throw new NoMergeBaseException(NoMergeBaseException$MergeBaseFailureReason.CONFLICTS_DURING_MERGE_BASE_CALCULATION, MessageFormat.format(JGitText.get().mergeRecursiveConflictsWhenMergingCommonAncestors, revCommit4.getName(), revCommit5.getName()));
                }
                revCommit4 = this.createCommitForTree(this.resultTree, arrayList2);
            }
        }
        finally {
            this.inCore = bl2;
            this.dircache = dirCache;
            this.workingTreeIterator = workingTreeIterator;
            this.toBeCheckedOut.clear();
            this.toBeDeleted.clear();
            this.modifiedFiles.clear();
            this.unmergedPaths.clear();
            this.mergeResults.clear();
            this.failingPaths.clear();
        }
        return revCommit4;
    }

    private RevCommit createCommitForTree(ObjectId objectId, List list) {
        CommitBuilder commitBuilder = new CommitBuilder();
        commitBuilder.setTreeId(objectId);
        commitBuilder.setParentIds(list);
        commitBuilder.setAuthor(RecursiveMerger.mockAuthor(list));
        commitBuilder.setCommitter(commitBuilder.getAuthor());
        return RevCommit.parse(this.walk, commitBuilder.build());
    }

    private static PersonIdent mockAuthor(List list) {
        String string = RecursiveMerger.class.getSimpleName();
        int n2 = 0;
        for (RevCommit revCommit : list) {
            n2 = Math.max(n2, revCommit.getCommitTime());
        }
        return new PersonIdent(string, string + "@JGit", new Date((long)(n2 + 1) * 1000L), TimeZone.getTimeZone("GMT+0000"));
    }
}

