/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.text.MessageFormat;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.NoMergeBaseException;
import org.eclipse.jgit.errors.NoMergeBaseException$MergeBaseFailureReason;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

public abstract class Merger {
    @Nullable
    protected final Repository db;
    protected ObjectReader reader;
    protected RevWalk walk;
    private ObjectInserter inserter;
    protected RevObject[] sourceObjects;
    protected RevCommit[] sourceCommits;
    protected RevTree[] sourceTrees;
    protected ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected Merger(Repository repository) {
        if (repository == null) {
            throw new NullPointerException(JGitText.get().repositoryIsRequired);
        }
        this.db = repository;
        this.inserter = repository.newObjectInserter();
        this.reader = this.inserter.newReader();
        this.walk = new RevWalk(this.reader);
    }

    protected Merger(ObjectInserter objectInserter) {
        this.db = null;
        this.inserter = objectInserter;
        this.reader = objectInserter.newReader();
        this.walk = new RevWalk(this.reader);
    }

    @Nullable
    public Repository getRepository() {
        return this.db;
    }

    protected Repository nonNullRepo() {
        if (this.db == null) {
            throw new NullPointerException(JGitText.get().repositoryIsRequired);
        }
        return this.db;
    }

    public ObjectInserter getObjectInserter() {
        return this.inserter;
    }

    public void setObjectInserter(ObjectInserter objectInserter) {
        this.walk.close();
        this.reader.close();
        this.inserter.close();
        this.inserter = objectInserter;
        this.reader = objectInserter.newReader();
        this.walk = new RevWalk(this.reader);
    }

    public boolean merge(AnyObjectId ... anyObjectIdArray) {
        return this.merge(true, anyObjectIdArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean merge(boolean bl2, AnyObjectId ... anyObjectIdArray) {
        int n2;
        this.sourceObjects = new RevObject[anyObjectIdArray.length];
        for (n2 = 0; n2 < anyObjectIdArray.length; n2 += 1) {
            this.sourceObjects[n2] = this.walk.parseAny(anyObjectIdArray[n2]);
        }
        this.sourceCommits = new RevCommit[this.sourceObjects.length];
        for (n2 = 0; n2 < this.sourceObjects.length; n2 += 1) {
            try {
                this.sourceCommits[n2] = this.walk.parseCommit(this.sourceObjects[n2]);
                continue;
            }
            catch (IncorrectObjectTypeException incorrectObjectTypeException) {
                this.sourceCommits[n2] = null;
            }
        }
        this.sourceTrees = new RevTree[this.sourceObjects.length];
        for (n2 = 0; n2 < this.sourceObjects.length; n2 += 1) {
            this.sourceTrees[n2] = this.walk.parseTree(this.sourceObjects[n2]);
        }
        try {
            n2 = this.mergeImpl() ? 1 : 0;
            if (n2 && bl2) {
                this.inserter.flush();
            }
            int n3 = n2;
            return n3 != 0;
        }
        finally {
            if (bl2) {
                this.inserter.close();
            }
            this.reader.close();
        }
    }

    public abstract ObjectId getBaseCommitId();

    protected RevCommit getBaseCommit(RevCommit revCommit, RevCommit revCommit2) {
        this.walk.reset();
        this.walk.setRevFilter(RevFilter.MERGE_BASE);
        this.walk.markStart(revCommit);
        this.walk.markStart(revCommit2);
        RevCommit revCommit3 = this.walk.next();
        if (revCommit3 == null) {
            return null;
        }
        RevCommit revCommit4 = this.walk.next();
        if (revCommit4 != null) {
            throw new NoMergeBaseException(NoMergeBaseException$MergeBaseFailureReason.MULTIPLE_MERGE_BASES_NOT_SUPPORTED, MessageFormat.format(JGitText.get().multipleMergeBasesFor, revCommit.name(), revCommit2.name(), revCommit3.name(), revCommit4.name()));
        }
        return revCommit3;
    }

    protected AbstractTreeIterator openTree(AnyObjectId anyObjectId) {
        return new CanonicalTreeParser(null, this.reader, anyObjectId);
    }

    protected abstract boolean mergeImpl();

    public abstract ObjectId getResultTreeId();

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor;
    }
}

