/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.merge.EolAwareOutputStream;
import org.eclipse.jgit.merge.MergeChunk;
import org.eclipse.jgit.merge.MergeChunk$ConflictState;
import org.eclipse.jgit.merge.MergeResult;

class MergeFormatterPass {
    private final EolAwareOutputStream out;
    private final MergeResult res;
    private final List seqName;
    private final Charset charset;
    private final boolean threeWayMerge;
    private String lastConflictingName;

    MergeFormatterPass(OutputStream outputStream, MergeResult mergeResult, List list, Charset charset) {
        this.out = new EolAwareOutputStream(outputStream);
        this.res = mergeResult;
        this.seqName = list;
        this.charset = charset;
        this.threeWayMerge = mergeResult.getSequences().size() == 3;
    }

    void formatMerge() {
        boolean bl2 = false;
        for (MergeChunk mergeChunk : this.res) {
            RawText rawText = (RawText)this.res.getSequences().get(mergeChunk.getSequenceIndex());
            this.writeConflictMetadata(mergeChunk);
            for (int i2 = mergeChunk.getBegin(); i2 < mergeChunk.getEnd(); ++i2) {
                this.writeLine(rawText, i2);
            }
            bl2 = rawText.isMissingNewlineAtEnd();
        }
        if (this.lastConflictingName != null) {
            this.writeConflictEnd();
        }
        if (!bl2) {
            this.out.beginln();
        }
    }

    private void writeConflictMetadata(MergeChunk mergeChunk) {
        if (this.lastConflictingName != null && mergeChunk.getConflictState() != MergeChunk$ConflictState.NEXT_CONFLICTING_RANGE) {
            this.writeConflictEnd();
        }
        if (mergeChunk.getConflictState() == MergeChunk$ConflictState.FIRST_CONFLICTING_RANGE) {
            this.writeConflictStart(mergeChunk);
        } else if (mergeChunk.getConflictState() == MergeChunk$ConflictState.NEXT_CONFLICTING_RANGE) {
            this.writeConflictChange(mergeChunk);
        }
    }

    private void writeConflictEnd() {
        this.writeln(">>>>>>> " + this.lastConflictingName);
        this.lastConflictingName = null;
    }

    private void writeConflictStart(MergeChunk mergeChunk) {
        this.lastConflictingName = (String)this.seqName.get(mergeChunk.getSequenceIndex());
        this.writeln("<<<<<<< " + this.lastConflictingName);
    }

    private void writeConflictChange(MergeChunk mergeChunk) {
        this.lastConflictingName = (String)this.seqName.get(mergeChunk.getSequenceIndex());
        this.writeln(this.threeWayMerge ? "=======" : "======= " + this.lastConflictingName);
    }

    private void writeln(String string) {
        this.out.beginln();
        this.out.write((string + "\n").getBytes(this.charset));
    }

    private void writeLine(RawText rawText, int n2) {
        this.out.beginln();
        rawText.writeLine(this.out, n2);
        if (this.out.isBeginln()) {
            this.out.write(10);
        }
    }
}

