/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.IOException;
import org.eclipse.jgit.api.MergeCommand$FastForwardMode;
import org.eclipse.jgit.api.MergeCommand$FastForwardMode$Merge;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Config$SectionParser;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeConfig$1;
import org.eclipse.jgit.merge.MergeConfig$MergeConfigSectionParser;

public class MergeConfig {
    private final MergeCommand$FastForwardMode fastForwardMode;
    private final boolean squash;
    private final boolean commit;

    public static MergeConfig getConfigForCurrentBranch(Repository repository) {
        try {
            String string = repository.getBranch();
            if (string != null) {
                return (MergeConfig)repository.getConfig().get(MergeConfig.getParser(string));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new MergeConfig();
    }

    public static final Config$SectionParser getParser(String string) {
        return new MergeConfig$MergeConfigSectionParser(string);
    }

    private MergeConfig(String string, Config config) {
        String[] stringArray = MergeConfig.getMergeOptions(string, config);
        this.fastForwardMode = MergeConfig.getFastForwardMode(config, stringArray);
        this.squash = MergeConfig.isMergeConfigOptionSet("--squash", stringArray);
        this.commit = !MergeConfig.isMergeConfigOptionSet("--no-commit", stringArray);
    }

    private MergeConfig() {
        this.fastForwardMode = MergeCommand$FastForwardMode.FF;
        this.squash = false;
        this.commit = true;
    }

    public MergeCommand$FastForwardMode getFastForwardMode() {
        return this.fastForwardMode;
    }

    public boolean isSquash() {
        return this.squash;
    }

    public boolean isCommit() {
        return this.commit;
    }

    private static MergeCommand$FastForwardMode getFastForwardMode(Config config, String[] stringArray) {
        for (String string : stringArray) {
            for (MergeCommand$FastForwardMode mergeCommand$FastForwardMode : MergeCommand$FastForwardMode.values()) {
                if (!mergeCommand$FastForwardMode.matchConfigValue(string)) continue;
                return mergeCommand$FastForwardMode;
            }
        }
        MergeCommand$FastForwardMode mergeCommand$FastForwardMode = MergeCommand$FastForwardMode.valueOf((MergeCommand$FastForwardMode$Merge)config.getEnum("merge", null, "ff", MergeCommand$FastForwardMode$Merge.TRUE));
        return mergeCommand$FastForwardMode;
    }

    private static boolean isMergeConfigOptionSet(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static String[] getMergeOptions(String string, Config config) {
        String string2 = config.getString("branch", string, "mergeoptions");
        if (string2 != null) {
            return string2.split("\\s");
        }
        return new String[0];
    }

    /* synthetic */ MergeConfig(String string, Config config, MergeConfig$1 mergeConfig$1) {
        this(string, config);
    }
}

