/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeChunk$ConflictState;
import org.eclipse.jgit.merge.MergeResult;

public final class MergeAlgorithm {
    private final DiffAlgorithm diffAlg;
    @NonNull
    private ContentMergeStrategy strategy = ContentMergeStrategy.CONFLICT;
    private static final Edit END_EDIT = new Edit(Integer.MAX_VALUE, Integer.MAX_VALUE);

    public MergeAlgorithm() {
        this(new HistogramDiff());
    }

    public MergeAlgorithm(DiffAlgorithm diffAlgorithm) {
        this.diffAlg = diffAlgorithm;
    }

    @NonNull
    public ContentMergeStrategy getContentMergeStrategy() {
        return this.strategy;
    }

    public void setContentMergeStrategy(ContentMergeStrategy contentMergeStrategy) {
        this.strategy = contentMergeStrategy == null ? ContentMergeStrategy.CONFLICT : contentMergeStrategy;
    }

    private static boolean isEndEdit(Edit edit) {
        return edit == END_EDIT;
    }

    public MergeResult merge(SequenceComparator sequenceComparator, Sequence sequence, Sequence sequence2, Sequence sequence3) {
        ArrayList<Sequence> arrayList = new ArrayList<Sequence>(3);
        arrayList.add(sequence);
        arrayList.add(sequence2);
        arrayList.add(sequence3);
        MergeResult mergeResult = new MergeResult(arrayList);
        if (sequence2.size() == 0) {
            if (sequence3.size() != 0) {
                EditList editList = this.diffAlg.diff(sequenceComparator, sequence, sequence3);
                if (!editList.isEmpty()) {
                    switch (this.strategy) {
                        case OURS: {
                            mergeResult.add(1, 0, 0, MergeChunk$ConflictState.NO_CONFLICT);
                            break;
                        }
                        case THEIRS: {
                            mergeResult.add(2, 0, sequence3.size(), MergeChunk$ConflictState.NO_CONFLICT);
                            break;
                        }
                        default: {
                            mergeResult.add(1, 0, 0, MergeChunk$ConflictState.FIRST_CONFLICTING_RANGE);
                            mergeResult.add(2, 0, sequence3.size(), MergeChunk$ConflictState.NEXT_CONFLICTING_RANGE);
                            break;
                        }
                    }
                } else {
                    mergeResult.add(1, 0, 0, MergeChunk$ConflictState.NO_CONFLICT);
                }
            } else {
                mergeResult.add(1, 0, 0, MergeChunk$ConflictState.NO_CONFLICT);
            }
            return mergeResult;
        }
        if (sequence3.size() == 0) {
            EditList editList = this.diffAlg.diff(sequenceComparator, sequence, sequence2);
            if (!editList.isEmpty()) {
                switch (this.strategy) {
                    case OURS: {
                        mergeResult.add(1, 0, sequence2.size(), MergeChunk$ConflictState.NO_CONFLICT);
                        break;
                    }
                    case THEIRS: {
                        mergeResult.add(2, 0, 0, MergeChunk$ConflictState.NO_CONFLICT);
                        break;
                    }
                    default: {
                        mergeResult.add(1, 0, sequence2.size(), MergeChunk$ConflictState.FIRST_CONFLICTING_RANGE);
                        mergeResult.add(2, 0, 0, MergeChunk$ConflictState.NEXT_CONFLICTING_RANGE);
                        break;
                    }
                }
            } else {
                mergeResult.add(2, 0, 0, MergeChunk$ConflictState.NO_CONFLICT);
            }
            return mergeResult;
        }
        EditList editList = this.diffAlg.diff(sequenceComparator, sequence, sequence2);
        Iterator iterator = editList.iterator();
        EditList editList2 = this.diffAlg.diff(sequenceComparator, sequence, sequence3);
        Iterator iterator2 = editList2.iterator();
        int n2 = 0;
        Edit edit = MergeAlgorithm.nextEdit(iterator);
        Edit edit2 = MergeAlgorithm.nextEdit(iterator2);
        while (!MergeAlgorithm.isEndEdit(edit2) || !MergeAlgorithm.isEndEdit(edit)) {
            int n3;
            int n4;
            if (edit.getEndA() < edit2.getBeginA()) {
                if (n2 != edit.getBeginA()) {
                    mergeResult.add(0, n2, edit.getBeginA(), MergeChunk$ConflictState.NO_CONFLICT);
                }
                mergeResult.add(1, edit.getBeginB(), edit.getEndB(), MergeChunk$ConflictState.NO_CONFLICT);
                n2 = edit.getEndA();
                edit = MergeAlgorithm.nextEdit(iterator);
                continue;
            }
            if (edit2.getEndA() < edit.getBeginA()) {
                if (n2 != edit2.getBeginA()) {
                    mergeResult.add(0, n2, edit2.getBeginA(), MergeChunk$ConflictState.NO_CONFLICT);
                }
                mergeResult.add(2, edit2.getBeginB(), edit2.getEndB(), MergeChunk$ConflictState.NO_CONFLICT);
                n2 = edit2.getEndA();
                edit2 = MergeAlgorithm.nextEdit(iterator2);
                continue;
            }
            if (edit.getBeginA() != n2 && edit2.getBeginA() != n2) {
                mergeResult.add(0, n2, Math.min(edit.getBeginA(), edit2.getBeginA()), MergeChunk$ConflictState.NO_CONFLICT);
            }
            int n5 = edit.getBeginB();
            int n6 = edit2.getBeginB();
            if (edit.getBeginA() < edit2.getBeginA()) {
                n6 -= edit2.getBeginA() - edit.getBeginA();
            } else {
                n5 -= edit.getBeginA() - edit2.getBeginA();
            }
            Edit edit3 = MergeAlgorithm.nextEdit(iterator);
            Edit edit4 = MergeAlgorithm.nextEdit(iterator2);
            while (true) {
                if (edit.getEndA() >= edit4.getBeginA()) {
                    edit2 = edit4;
                    edit4 = MergeAlgorithm.nextEdit(iterator2);
                    continue;
                }
                if (edit2.getEndA() < edit3.getBeginA()) break;
                edit = edit3;
                edit3 = MergeAlgorithm.nextEdit(iterator);
            }
            int n7 = edit.getEndB();
            int n8 = edit2.getEndB();
            if (edit.getEndA() < edit2.getEndA()) {
                n7 += edit2.getEndA() - edit.getEndA();
            } else {
                n8 += edit.getEndA() - edit2.getEndA();
            }
            int n9 = n7 - n5;
            int n10 = n9 - (n8 - n6);
            if (n10 > 0) {
                n9 -= n10;
            }
            for (n4 = 0; n4 < n9 && sequenceComparator.equals(sequence2, n5 + n4, sequence3, n6 + n4); ++n4) {
            }
            n9 -= n4;
            for (n3 = 0; n3 < n9 && sequenceComparator.equals(sequence2, n7 - n3 - 1, sequence3, n8 - n3 - 1); ++n3) {
            }
            n9 -= n3;
            if (n4 > 0) {
                mergeResult.add(1, n5, n5 + n4, MergeChunk$ConflictState.NO_CONFLICT);
            }
            if (n9 > 0 || n10 != 0) {
                switch (this.strategy) {
                    case OURS: {
                        mergeResult.add(1, n5 + n4, n7 - n3, MergeChunk$ConflictState.NO_CONFLICT);
                        break;
                    }
                    case THEIRS: {
                        mergeResult.add(2, n6 + n4, n8 - n3, MergeChunk$ConflictState.NO_CONFLICT);
                        break;
                    }
                    default: {
                        mergeResult.add(1, n5 + n4, n7 - n3, MergeChunk$ConflictState.FIRST_CONFLICTING_RANGE);
                        mergeResult.add(2, n6 + n4, n8 - n3, MergeChunk$ConflictState.NEXT_CONFLICTING_RANGE);
                    }
                }
            }
            if (n3 > 0) {
                mergeResult.add(1, n7 - n3, n7, MergeChunk$ConflictState.NO_CONFLICT);
            }
            n2 = Math.max(edit.getEndA(), edit2.getEndA());
            edit = edit3;
            edit2 = edit4;
        }
        if (n2 < sequence.size()) {
            mergeResult.add(0, n2, sequence.size(), MergeChunk$ConflictState.NO_CONFLICT);
        }
        return mergeResult;
    }

    private static Edit nextEdit(Iterator iterator) {
        return iterator.hasNext() ? (Edit)iterator.next() : END_EDIT;
    }
}

