/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.logging.PerformanceLogRecord;

public class PerformanceLogContext {
    private static final PerformanceLogContext INSTANCE = new PerformanceLogContext();
    private static final ThreadLocal eventRecords = ThreadLocal.withInitial(ArrayList::new);

    private PerformanceLogContext() {
    }

    public static PerformanceLogContext getInstance() {
        return INSTANCE;
    }

    public List getEventRecords() {
        return Collections.unmodifiableList((List)eventRecords.get());
    }

    public void addEvent(PerformanceLogRecord performanceLogRecord) {
        ((List)eventRecords.get()).add(performanceLogRecord);
    }

    public void cleanEvents() {
        eventRecords.remove();
    }
}

