/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Config$SectionParser;
import org.eclipse.jgit.util.SystemReader;

public class UserConfig {
    public static final Config$SectionParser KEY = UserConfig::new;
    private String authorName;
    private String authorEmail;
    private String committerName;
    private String committerEmail;
    private boolean isAuthorNameImplicit;
    private boolean isAuthorEmailImplicit;
    private boolean isCommitterNameImplicit;
    private boolean isCommitterEmailImplicit;

    private UserConfig(Config config) {
        this.authorName = UserConfig.getNameInternal(config, "GIT_AUTHOR_NAME");
        if (this.authorName == null) {
            this.authorName = UserConfig.getDefaultUserName();
            this.isAuthorNameImplicit = true;
        }
        this.authorEmail = UserConfig.getEmailInternal(config, "GIT_AUTHOR_EMAIL");
        if (this.authorEmail == null) {
            this.authorEmail = UserConfig.getDefaultEmail();
            this.isAuthorEmailImplicit = true;
        }
        this.committerName = UserConfig.getNameInternal(config, "GIT_COMMITTER_NAME");
        if (this.committerName == null) {
            this.committerName = UserConfig.getDefaultUserName();
            this.isCommitterNameImplicit = true;
        }
        this.committerEmail = UserConfig.getEmailInternal(config, "GIT_COMMITTER_EMAIL");
        if (this.committerEmail == null) {
            this.committerEmail = UserConfig.getDefaultEmail();
            this.isCommitterEmailImplicit = true;
        }
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getCommitterName() {
        return this.committerName;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public String getCommitterEmail() {
        return this.committerEmail;
    }

    public boolean isAuthorNameImplicit() {
        return this.isAuthorNameImplicit;
    }

    public boolean isAuthorEmailImplicit() {
        return this.isAuthorEmailImplicit;
    }

    public boolean isCommitterNameImplicit() {
        return this.isCommitterNameImplicit;
    }

    public boolean isCommitterEmailImplicit() {
        return this.isCommitterEmailImplicit;
    }

    private static String getNameInternal(Config config, String string) {
        String string2 = UserConfig.system().getenv(string);
        if (string2 == null) {
            string2 = config.getString("user", null, "name");
        }
        return UserConfig.stripInvalidCharacters(string2);
    }

    private static String getDefaultUserName() {
        String string = UserConfig.system().getProperty("user.name");
        if (string == null) {
            string = "unknown-user";
        }
        return string;
    }

    private static String getEmailInternal(Config config, String string) {
        String string2 = UserConfig.system().getenv(string);
        if (string2 == null) {
            string2 = config.getString("user", null, "email");
        }
        return UserConfig.stripInvalidCharacters(string2);
    }

    private static String stripInvalidCharacters(String string) {
        return string == null ? null : string.replaceAll("<|>|\n", "");
    }

    private static String getDefaultEmail() {
        String string = UserConfig.getDefaultUserName();
        return string + "@" + UserConfig.system().getHostname();
    }

    private static SystemReader system() {
        return SystemReader.getInstance();
    }
}

