/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.util.TemporaryBuffer$Heap;

public class TreeFormatter {
    private byte[] buf;
    private int ptr;
    private TemporaryBuffer$Heap overflowBuffer;

    public static int entrySize(FileMode fileMode, int n2) {
        return fileMode.copyToLength() + n2 + 20 + 2;
    }

    public TreeFormatter() {
        this(8192);
    }

    public TreeFormatter(int n2) {
        this.buf = new byte[n2];
    }

    public void append(String string, RevCommit revCommit) {
        this.append(string, FileMode.GITLINK, (AnyObjectId)revCommit);
    }

    public void append(String string, RevTree revTree) {
        this.append(string, FileMode.TREE, (AnyObjectId)revTree);
    }

    public void append(String string, RevBlob revBlob) {
        this.append(string, FileMode.REGULAR_FILE, (AnyObjectId)revBlob);
    }

    public void append(String string, FileMode fileMode, AnyObjectId anyObjectId) {
        this.append(Constants.encode(string), fileMode, anyObjectId);
    }

    public void append(byte[] byArray, FileMode fileMode, AnyObjectId anyObjectId) {
        this.append(byArray, 0, byArray.length, fileMode, anyObjectId);
    }

    public void append(byte[] byArray, int n2, int n3, FileMode fileMode, AnyObjectId anyObjectId) {
        this.append(byArray, n2, n3, fileMode, anyObjectId, false);
    }

    public void append(byte[] byArray, int n2, int n3, FileMode fileMode, AnyObjectId anyObjectId, boolean bl2) {
        if (n3 == 0 && !bl2) {
            throw new IllegalArgumentException(JGitText.get().invalidTreeZeroLengthName);
        }
        if (this.fmtBuf(byArray, n2, n3, fileMode)) {
            anyObjectId.copyRawTo(this.buf, this.ptr);
            this.ptr += 20;
        } else {
            try {
                this.fmtOverflowBuffer(byArray, n2, n3, fileMode);
                anyObjectId.copyRawTo(this.overflowBuffer);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public void append(byte[] byArray, int n2, int n3, FileMode fileMode, byte[] byArray2, int n4) {
        if (this.fmtBuf(byArray, n2, n3, fileMode)) {
            System.arraycopy(byArray2, n4, this.buf, this.ptr, 20);
            this.ptr += 20;
        } else {
            try {
                this.fmtOverflowBuffer(byArray, n2, n3, fileMode);
                this.overflowBuffer.write(byArray2, n4, 20);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    private boolean fmtBuf(byte[] byArray, int n2, int n3, FileMode fileMode) {
        if (this.buf == null || this.buf.length < this.ptr + TreeFormatter.entrySize(fileMode, n3)) {
            return false;
        }
        fileMode.copyTo(this.buf, this.ptr);
        this.ptr += fileMode.copyToLength();
        this.buf[this.ptr++] = 32;
        System.arraycopy(byArray, n2, this.buf, this.ptr, n3);
        this.ptr += n3;
        this.buf[this.ptr++] = 0;
        return true;
    }

    private void fmtOverflowBuffer(byte[] byArray, int n2, int n3, FileMode fileMode) {
        if (this.buf != null) {
            this.overflowBuffer = new TemporaryBuffer$Heap(Integer.MAX_VALUE);
            this.overflowBuffer.write(this.buf, 0, this.ptr);
            this.buf = null;
        }
        fileMode.copyTo(this.overflowBuffer);
        this.overflowBuffer.write(32);
        this.overflowBuffer.write(byArray, n2, n3);
        this.overflowBuffer.write(0);
    }

    public ObjectId insertTo(ObjectInserter objectInserter) {
        if (this.buf != null) {
            return objectInserter.insert(2, this.buf, 0, this.ptr);
        }
        long l2 = this.overflowBuffer.length();
        return objectInserter.insert(2, l2, this.overflowBuffer.openInputStream());
    }

    public ObjectId computeId(ObjectInserter objectInserter) {
        if (this.buf != null) {
            return objectInserter.idFor(2, this.buf, 0, this.ptr);
        }
        long l2 = this.overflowBuffer.length();
        try {
            return objectInserter.idFor(2, l2, this.overflowBuffer.openInputStream());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public byte[] toByteArray() {
        if (this.buf != null) {
            byte[] byArray = new byte[this.ptr];
            System.arraycopy(this.buf, 0, byArray, 0, this.ptr);
            return byArray;
        }
        try {
            return this.overflowBuffer.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String toString() {
        byte[] byArray = this.toByteArray();
        CanonicalTreeParser canonicalTreeParser = new CanonicalTreeParser();
        canonicalTreeParser.reset(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tree={");
        if (!canonicalTreeParser.eof()) {
            stringBuilder.append('\n');
            try {
                new ObjectChecker().checkTree(byArray);
            }
            catch (CorruptObjectException corruptObjectException) {
                stringBuilder.append("*** ERROR: ").append(corruptObjectException.getMessage()).append("\n");
                stringBuilder.append('\n');
            }
        }
        while (!canonicalTreeParser.eof()) {
            FileMode fileMode = canonicalTreeParser.getEntryFileMode();
            stringBuilder.append(fileMode);
            stringBuilder.append(' ');
            stringBuilder.append(Constants.typeString(fileMode.getObjectType()));
            stringBuilder.append(' ');
            stringBuilder.append(canonicalTreeParser.getEntryObjectId().name());
            stringBuilder.append(' ');
            stringBuilder.append(canonicalTreeParser.getEntryPathString());
            stringBuilder.append('\n');
            canonicalTreeParser.next();
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

