/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.lib.ProgressMonitor;

public class ThreadSafeProgressMonitor
implements ProgressMonitor {
    private final ProgressMonitor pm;
    private final ReentrantLock lock;
    private final Thread mainThread;
    private final AtomicInteger workers;
    private final AtomicInteger pendingUpdates;
    private final Semaphore process;

    public ThreadSafeProgressMonitor(ProgressMonitor progressMonitor) {
        this.pm = progressMonitor;
        this.lock = new ReentrantLock();
        this.mainThread = Thread.currentThread();
        this.workers = new AtomicInteger(0);
        this.pendingUpdates = new AtomicInteger(0);
        this.process = new Semaphore(0);
    }

    @Override
    public void start(int n2) {
        if (!this.isMainThread()) {
            throw new IllegalStateException();
        }
        this.pm.start(n2);
    }

    @Override
    public void beginTask(String string, int n2) {
        if (!this.isMainThread()) {
            throw new IllegalStateException();
        }
        this.pm.beginTask(string, n2);
    }

    public void startWorker() {
        this.startWorkers(1);
    }

    public void startWorkers(int n2) {
        this.workers.addAndGet(n2);
    }

    public void endWorker() {
        if (this.workers.decrementAndGet() == 0) {
            this.process.release();
        }
    }

    public void pollForUpdates() {
        assert (this.isMainThread());
        this.doUpdates();
    }

    public void waitForCompletion() {
        assert (this.isMainThread());
        while (0 < this.workers.get()) {
            this.doUpdates();
            this.process.acquire();
        }
        this.doUpdates();
    }

    private void doUpdates() {
        int n2 = this.pendingUpdates.getAndSet(0);
        if (0 < n2) {
            this.pm.update(n2);
        }
    }

    @Override
    public void update(int n2) {
        if (0 == this.pendingUpdates.getAndAdd(n2)) {
            this.process.release();
        }
    }

    @Override
    public boolean isCancelled() {
        this.lock.lock();
        try {
            boolean bl2 = this.pm.isCancelled();
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void endTask() {
        if (!this.isMainThread()) {
            throw new IllegalStateException();
        }
        this.pm.endTask();
    }

    private boolean isMainThread() {
        return Thread.currentThread() == this.mainThread;
    }
}

