/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.lib.BatchingProgressMonitor;

public class TextProgressMonitor
extends BatchingProgressMonitor {
    private final Writer out;
    private boolean write;

    public TextProgressMonitor() {
        this(new PrintWriter(new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8)));
    }

    public TextProgressMonitor(Writer writer) {
        this.out = writer;
        this.write = true;
    }

    @Override
    protected void onUpdate(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.format(stringBuilder, string, n2);
        this.send(stringBuilder);
    }

    @Override
    protected void onEndTask(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.format(stringBuilder, string, n2);
        stringBuilder.append("\n");
        this.send(stringBuilder);
    }

    private void format(StringBuilder stringBuilder, String string, int n2) {
        stringBuilder.append("\r");
        stringBuilder.append(string);
        stringBuilder.append(": ");
        while (stringBuilder.length() < 25) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(n2);
    }

    @Override
    protected void onUpdate(String string, int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder();
        this.format(stringBuilder, string, n2, n3, n4);
        this.send(stringBuilder);
    }

    @Override
    protected void onEndTask(String string, int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder();
        this.format(stringBuilder, string, n2, n3, n4);
        stringBuilder.append("\n");
        this.send(stringBuilder);
    }

    private void format(StringBuilder stringBuilder, String string, int n2, int n3, int n4) {
        stringBuilder.append("\r");
        stringBuilder.append(string);
        stringBuilder.append(": ");
        while (stringBuilder.length() < 25) {
            stringBuilder.append(' ');
        }
        String string2 = String.valueOf(n3);
        String string3 = String.valueOf(n2);
        while (string3.length() < string2.length()) {
            string3 = " " + string3;
        }
        if (n4 < 100) {
            stringBuilder.append(' ');
        }
        if (n4 < 10) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(n4);
        stringBuilder.append("% (");
        stringBuilder.append(string3);
        stringBuilder.append("/");
        stringBuilder.append(string2);
        stringBuilder.append(")");
    }

    private void send(StringBuilder stringBuilder) {
        if (this.write) {
            try {
                this.out.write(stringBuilder.toString());
                this.out.flush();
            }
            catch (IOException iOException) {
                this.write = false;
            }
        }
    }
}

