/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.ObjectBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.util.References;

public class TagBuilder
extends ObjectBuilder {
    private static final byte[] hobject = Constants.encodeASCII("object");
    private static final byte[] htype = Constants.encodeASCII("type");
    private static final byte[] htag = Constants.encodeASCII("tag");
    private static final byte[] htagger = Constants.encodeASCII("tagger");
    private ObjectId object;
    private int type = -1;
    private String tag;

    public int getObjectType() {
        return this.type;
    }

    public ObjectId getObjectId() {
        return this.object;
    }

    public void setObjectId(AnyObjectId anyObjectId, int n2) {
        this.object = anyObjectId.copy();
        this.type = n2;
    }

    public void setObjectId(RevObject revObject) {
        this.setObjectId(revObject, revObject.getType());
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public PersonIdent getTagger() {
        return this.getAuthor();
    }

    public void setTagger(PersonIdent personIdent) {
        this.setAuthor(personIdent);
    }

    @Override
    public byte[] build() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, this.getEncoding());){
            GpgSignature gpgSignature;
            byteArrayOutputStream.write(hobject);
            byteArrayOutputStream.write(32);
            this.getObjectId().copyTo(byteArrayOutputStream);
            byteArrayOutputStream.write(10);
            byteArrayOutputStream.write(htype);
            byteArrayOutputStream.write(32);
            byteArrayOutputStream.write(Constants.encodeASCII(Constants.typeString(this.getObjectType())));
            byteArrayOutputStream.write(10);
            byteArrayOutputStream.write(htag);
            byteArrayOutputStream.write(32);
            outputStreamWriter.write(this.getTag());
            outputStreamWriter.flush();
            byteArrayOutputStream.write(10);
            if (this.getTagger() != null) {
                byteArrayOutputStream.write(htagger);
                byteArrayOutputStream.write(32);
                outputStreamWriter.write(this.getTagger().toExternalString());
                outputStreamWriter.flush();
                byteArrayOutputStream.write(10);
            }
            TagBuilder.writeEncoding(this.getEncoding(), byteArrayOutputStream);
            byteArrayOutputStream.write(10);
            String string = this.getMessage();
            if (string != null) {
                outputStreamWriter.write(string);
                outputStreamWriter.flush();
            }
            if ((gpgSignature = this.getGpgSignature()) != null) {
                if (string != null && !string.isEmpty() && !string.endsWith("\n")) {
                    throw new JGitInternalException(JGitText.get().signedTagMessageNoLf);
                }
                String string2 = gpgSignature.toExternalString();
                outputStreamWriter.write(string2);
                outputStreamWriter.flush();
                if (!string2.endsWith("\n")) {
                    byteArrayOutputStream.write(10);
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Deprecated
    public byte[] toByteArray() {
        try {
            return this.build();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String toString() {
        Charset charset;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tag");
        stringBuilder.append("={\n");
        stringBuilder.append("object ");
        stringBuilder.append(this.object != null ? this.object.name() : "NOT_SET");
        stringBuilder.append("\n");
        stringBuilder.append("type ");
        stringBuilder.append(this.object != null ? Constants.typeString(this.type) : "NOT_SET");
        stringBuilder.append("\n");
        stringBuilder.append("tag ");
        stringBuilder.append(this.tag != null ? this.tag : "NOT_SET");
        stringBuilder.append("\n");
        if (this.getTagger() != null) {
            stringBuilder.append("tagger ");
            stringBuilder.append(this.getTagger());
            stringBuilder.append("\n");
        }
        if (!References.isSameObject(charset = this.getEncoding(), StandardCharsets.UTF_8)) {
            stringBuilder.append("encoding ");
            stringBuilder.append(charset.name());
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n");
        stringBuilder.append(this.getMessage() != null ? this.getMessage() : "");
        GpgSignature gpgSignature = this.getGpgSignature();
        stringBuilder.append(gpgSignature != null ? gpgSignature.toExternalString() : "");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

