/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;

public class SymbolicRef
implements Ref {
    private final String name;
    private final Ref target;
    private final long updateIndex;

    public SymbolicRef(@NonNull String string, @NonNull Ref ref) {
        this.name = string;
        this.target = ref;
        this.updateIndex = -1L;
    }

    public SymbolicRef(@NonNull String string, @NonNull Ref ref, long l2) {
        this.name = string;
        this.target = ref;
        this.updateIndex = l2;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSymbolic() {
        return true;
    }

    @Override
    @NonNull
    public Ref getLeaf() {
        Ref ref = this.getTarget();
        while (ref.isSymbolic()) {
            ref = ref.getTarget();
        }
        return ref;
    }

    @Override
    @NonNull
    public Ref getTarget() {
        return this.target;
    }

    @Override
    @Nullable
    public ObjectId getObjectId() {
        return this.getLeaf().getObjectId();
    }

    @Override
    @NonNull
    public Ref$Storage getStorage() {
        return Ref$Storage.LOOSE;
    }

    @Override
    @Nullable
    public ObjectId getPeeledObjectId() {
        return this.getLeaf().getPeeledObjectId();
    }

    @Override
    public boolean isPeeled() {
        return this.getLeaf().isPeeled();
    }

    @Override
    public long getUpdateIndex() {
        if (this.updateIndex == -1L) {
            throw new UnsupportedOperationException();
        }
        return this.updateIndex;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SymbolicRef[");
        Ref ref = this;
        while (ref.isSymbolic()) {
            stringBuilder.append(ref.getName());
            stringBuilder.append(" -> ");
            ref = ref.getTarget();
        }
        stringBuilder.append(ref.getName());
        stringBuilder.append('=');
        stringBuilder.append(ObjectId.toString(ref.getObjectId()));
        stringBuilder.append("(");
        stringBuilder.append(this.updateIndex);
        stringBuilder.append(")]");
        return stringBuilder.toString();
    }
}

