/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache$FileKey;
import org.eclipse.jgit.lib.RepositoryCache$Key;
import org.eclipse.jgit.lib.RepositoryCache$Lock;
import org.eclipse.jgit.lib.RepositoryCacheConfig;
import org.eclipse.jgit.lib.internal.WorkQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryCache {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryCache.class);
    private static final RepositoryCache cache = new RepositoryCache();
    private final Map cacheMap;
    private final RepositoryCache$Lock[] openLocks;
    private ScheduledFuture cleanupTask;
    private volatile long expireAfter;
    private final Object schedulerLock = new RepositoryCache$Lock(null);

    public static Repository open(RepositoryCache$Key repositoryCache$Key) {
        return RepositoryCache.open(repositoryCache$Key, true);
    }

    public static Repository open(RepositoryCache$Key repositoryCache$Key, boolean bl2) {
        return cache.openRepository(repositoryCache$Key, bl2);
    }

    public static void register(Repository repository) {
        if (repository.getDirectory() != null) {
            RepositoryCache$FileKey repositoryCache$FileKey = RepositoryCache$FileKey.exact(repository.getDirectory(), repository.getFS());
            cache.registerRepository(repositoryCache$FileKey, repository);
        }
    }

    public static void close(@NonNull Repository repository) {
        if (repository.getDirectory() != null) {
            RepositoryCache$FileKey repositoryCache$FileKey = RepositoryCache$FileKey.exact(repository.getDirectory(), repository.getFS());
            cache.unregisterAndCloseRepository(repositoryCache$FileKey);
        }
    }

    public static void unregister(Repository repository) {
        if (repository.getDirectory() != null) {
            RepositoryCache.unregister(RepositoryCache$FileKey.exact(repository.getDirectory(), repository.getFS()));
        }
    }

    public static void unregister(RepositoryCache$Key repositoryCache$Key) {
        cache.unregisterRepository(repositoryCache$Key);
    }

    public static Collection getRegisteredKeys() {
        return cache.getKeys();
    }

    static boolean isCached(@NonNull Repository repository) {
        File file = repository.getDirectory();
        if (file == null) {
            return false;
        }
        RepositoryCache$FileKey repositoryCache$FileKey = new RepositoryCache$FileKey(file, repository.getFS());
        return RepositoryCache.cache.cacheMap.get(repositoryCache$FileKey) == repository;
    }

    public static void clear() {
        cache.clearAll();
    }

    static void clearExpired() {
        cache.clearAllExpired();
    }

    static void reconfigure(RepositoryCacheConfig repositoryCacheConfig) {
        cache.configureEviction(repositoryCacheConfig);
    }

    private RepositoryCache() {
        this.cacheMap = new ConcurrentHashMap();
        this.openLocks = new RepositoryCache$Lock[4];
        for (int i2 = 0; i2 < this.openLocks.length; ++i2) {
            this.openLocks[i2] = new RepositoryCache$Lock(null);
        }
        this.configureEviction(new RepositoryCacheConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureEviction(RepositoryCacheConfig repositoryCacheConfig) {
        this.expireAfter = repositoryCacheConfig.getExpireAfter();
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = WorkQueue.getExecutor();
        Object object = this.schedulerLock;
        synchronized (object) {
            long l2;
            if (this.cleanupTask != null) {
                this.cleanupTask.cancel(false);
            }
            if ((l2 = repositoryCacheConfig.getCleanupDelay()) == 0L) {
                return;
            }
            this.cleanupTask = scheduledThreadPoolExecutor.scheduleWithFixedDelay(() -> {
                try {
                    cache.clearAllExpired();
                }
                catch (Throwable throwable) {
                    LOG.error(throwable.getMessage(), throwable);
                }
            }, l2, l2, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Repository openRepository(RepositoryCache$Key repositoryCache$Key, boolean bl2) {
        Repository repository = (Repository)this.cacheMap.get(repositoryCache$Key);
        if (repository == null) {
            RepositoryCache$Lock repositoryCache$Lock = this.lockFor(repositoryCache$Key);
            synchronized (repositoryCache$Lock) {
                repository = (Repository)this.cacheMap.get(repositoryCache$Key);
                if (repository == null) {
                    repository = repositoryCache$Key.open(bl2);
                    this.cacheMap.put(repositoryCache$Key, repository);
                } else {
                    repository.incrementOpen();
                }
            }
        } else {
            repository.incrementOpen();
        }
        return repository;
    }

    private void registerRepository(RepositoryCache$Key repositoryCache$Key, Repository repository) {
        Repository repository2 = this.cacheMap.put(repositoryCache$Key, repository);
        Throwable throwable = null;
        if (repository2 != null) {
            if (throwable != null) {
                try {
                    repository2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                repository2.close();
            }
        }
    }

    private Repository unregisterRepository(RepositoryCache$Key repositoryCache$Key) {
        return (Repository)this.cacheMap.remove(repositoryCache$Key);
    }

    private boolean isExpired(Repository repository) {
        return repository != null && repository.useCnt.get() <= 0 && System.currentTimeMillis() - repository.closedAt.get() > this.expireAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAndCloseRepository(RepositoryCache$Key repositoryCache$Key) {
        RepositoryCache$Lock repositoryCache$Lock = this.lockFor(repositoryCache$Key);
        synchronized (repositoryCache$Lock) {
            Repository repository = this.unregisterRepository(repositoryCache$Key);
            if (repository != null) {
                repository.doClose();
            }
        }
    }

    private Collection getKeys() {
        return new ArrayList(this.cacheMap.keySet());
    }

    private void clearAllExpired() {
        for (Repository repository : this.cacheMap.values()) {
            if (!this.isExpired(repository)) continue;
            RepositoryCache.close(repository);
        }
    }

    private void clearAll() {
        for (RepositoryCache$Key repositoryCache$Key : this.cacheMap.keySet()) {
            this.unregisterAndCloseRepository(repositoryCache$Key);
        }
    }

    private RepositoryCache$Lock lockFor(RepositoryCache$Key repositoryCache$Key) {
        return this.openLocks[(repositoryCache$Key.hashCode() >>> 1) % this.openLocks.length];
    }
}

