/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache$Key;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class RepositoryCache$FileKey
implements RepositoryCache$Key {
    private final File path;
    private final FS fs;

    public static RepositoryCache$FileKey exact(File file, FS fS) {
        return new RepositoryCache$FileKey(file, fS);
    }

    public static RepositoryCache$FileKey lenient(File file, FS fS) {
        File file2 = RepositoryCache$FileKey.resolve(file, fS);
        return new RepositoryCache$FileKey(file2 != null ? file2 : file, fS);
    }

    protected RepositoryCache$FileKey(File file, FS fS) {
        this.path = RepositoryCache$FileKey.canonical(file);
        this.fs = fS;
    }

    private static File canonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    public final File getFile() {
        return this.path;
    }

    @Override
    public Repository open(boolean bl2) {
        if (bl2 && !RepositoryCache$FileKey.isGitRepository(this.path, this.fs)) {
            throw new RepositoryNotFoundException(this.path);
        }
        return ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.path)).setFS(this.fs)).build();
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof RepositoryCache$FileKey && this.path.equals(((RepositoryCache$FileKey)object).path);
    }

    public String toString() {
        return this.path.toString();
    }

    public static boolean isGitRepository(File file, FS fS) {
        File file2;
        try {
            file2 = fS.getCommonDir(file);
        }
        catch (IOException iOException) {
            file2 = null;
        }
        if (file2 == null) {
            file2 = file;
        }
        return fS.resolve(file2, "objects").exists() && fS.resolve(file2, "refs").exists() && (fS.resolve(file2, "reftable").exists() || RepositoryCache$FileKey.isValidHead(new File(file, "HEAD")));
    }

    private static boolean isValidHead(File file) {
        String string = RepositoryCache$FileKey.readFirstLine(file);
        return string != null && (string.startsWith("ref: refs/") || ObjectId.isId(string));
    }

    private static String readFirstLine(File file) {
        try {
            byte[] byArray = IO.readFully(file, 4096);
            int n2 = byArray.length;
            if (n2 == 0) {
                return null;
            }
            if (byArray[n2 - 1] == 10) {
                --n2;
            }
            return RawParseUtils.decode(byArray, 0, n2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File resolve(File file, FS fS) {
        File file2;
        if (RepositoryCache$FileKey.isGitRepository(file, fS)) {
            return file;
        }
        File file3 = new File(file, ".git");
        if (file3.isFile()) {
            try {
                file2 = fS.getSymRef(file, file3);
                if (file2 != null && RepositoryCache$FileKey.isGitRepository(file2, fS)) {
                    return file2;
                }
            }
            catch (IOException iOException) {}
        } else if (RepositoryCache$FileKey.isGitRepository(file3, fS)) {
            return file3;
        }
        if (RepositoryCache$FileKey.isGitRepository(file2 = new File(file.getParentFile(), file.getName() + ".git"), fS)) {
            return file2;
        }
        return null;
    }
}

