/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.CheckoutEntry;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.RebaseTodoFile;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Repository
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Repository.class);
    private static final ListenerList globalListeners = new ListenerList();
    private static final Pattern FORBIDDEN_BRANCH_NAME_COMPONENTS = Pattern.compile("(^|/)(aux|com[1-9]|con|lpt[1-9]|nul|prn)(\\.[^/]*)?", 2);
    final AtomicInteger useCnt = new AtomicInteger(1);
    final AtomicLong closedAt = new AtomicLong();
    private final File gitDir;
    private final File gitCommonDir;
    private final FS fs;
    private final ListenerList myListeners = new ListenerList();
    private final File workTree;
    private final File indexFile;
    private final String initialBranch;

    public static ListenerList getGlobalListenerList() {
        return globalListeners;
    }

    protected Repository(BaseRepositoryBuilder baseRepositoryBuilder) {
        this.gitDir = baseRepositoryBuilder.getGitDir();
        this.gitCommonDir = baseRepositoryBuilder.getGitCommonDir();
        this.fs = baseRepositoryBuilder.getFS();
        this.workTree = baseRepositoryBuilder.getWorkTree();
        this.indexFile = baseRepositoryBuilder.getIndexFile();
        this.initialBranch = baseRepositoryBuilder.getInitialBranch();
    }

    @NonNull
    public ListenerList getListenerList() {
        return this.myListeners;
    }

    public void fireEvent(RepositoryEvent repositoryEvent) {
        repositoryEvent.setRepository(this);
        this.myListeners.dispatch(repositoryEvent);
        globalListeners.dispatch(repositoryEvent);
    }

    public void create() {
        this.create(false);
    }

    public abstract void create(boolean var1);

    public File getDirectory() {
        return this.gitDir;
    }

    public abstract String getIdentifier();

    public File getBaseDirectoryForChild(String string) {
        if (this.hasCommonDirectory() && !string.endsWith("HEAD")) {
            String[] stringArray = new String[]{"branches", "refs", "packed-refs", "logs", "info", "remotes", "config", "shallow", "worktrees", "hooks", "objects"};
            String[] stringArray2 = string.split("/", 1);
            if (Arrays.asList(stringArray).contains(stringArray2[0])) {
                return this.getCommonDirectory();
            }
        }
        return this.getDirectory();
    }

    public File getDirectoryChild(String string) {
        return new File(this.getBaseDirectoryForChild(string), string);
    }

    public File resolveDirectoryChild(String string) {
        return this.getFS().resolve(this.getBaseDirectoryForChild(string), string);
    }

    public File getCommonDirectory() {
        return this.gitCommonDir != null ? this.gitCommonDir : this.gitDir;
    }

    public boolean hasCommonDirectory() {
        return this.gitCommonDir != null;
    }

    @NonNull
    public abstract ObjectDatabase getObjectDatabase();

    @NonNull
    public ObjectInserter newObjectInserter() {
        return this.getObjectDatabase().newInserter();
    }

    @NonNull
    public ObjectReader newObjectReader() {
        return this.getObjectDatabase().newReader();
    }

    @NonNull
    public abstract RefDatabase getRefDatabase();

    @NonNull
    public abstract StoredConfig getConfig();

    @NonNull
    public abstract AttributesNodeProvider createAttributesNodeProvider();

    public FS getFS() {
        return this.fs;
    }

    @Deprecated
    public boolean hasObject(AnyObjectId anyObjectId) {
        try {
            return this.getObjectDatabase().has(anyObjectId);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @NonNull
    public ObjectLoader open(AnyObjectId anyObjectId) {
        return this.getObjectDatabase().open(anyObjectId);
    }

    @NonNull
    public ObjectLoader open(AnyObjectId anyObjectId, int n2) {
        return this.getObjectDatabase().open(anyObjectId, n2);
    }

    @NonNull
    public RefUpdate updateRef(String string) {
        return this.updateRef(string, false);
    }

    @NonNull
    public RefUpdate updateRef(String string, boolean bl2) {
        return this.getRefDatabase().newUpdate(string, bl2);
    }

    @NonNull
    public RefRename renameRef(String string, String string2) {
        return this.getRefDatabase().newRename(string, string2);
    }

    @Nullable
    public ObjectId resolve(String string) {
        try (RevWalk revWalk = new RevWalk(this);){
            revWalk.setRetainBody(false);
            Object object = this.resolve(revWalk, string);
            if (object instanceof String) {
                Ref ref = this.findRef((String)object);
                ObjectId objectId = ref != null ? ref.getLeaf().getObjectId() : null;
                return objectId;
            }
            ObjectId objectId = (ObjectId)object;
            return objectId;
        }
    }

    @Nullable
    public String simplify(String string) {
        try (RevWalk revWalk = new RevWalk(this);){
            revWalk.setRetainBody(true);
            Object object = this.resolve(revWalk, string);
            if (object != null) {
                if (object instanceof String) {
                    String string2 = (String)object;
                    return string2;
                }
                String string3 = ((AnyObjectId)object).getName();
                return string3;
            }
            String string4 = null;
            return string4;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    private Object resolve(RevWalk var1_1, String var2_2) {
        var3_3 = var2_2.toCharArray();
        var4_4 /* !! */  = null;
        var5_5 = null;
        var6_6 = 0;
        block16: for (var7_7 = 0; var7_7 < var3_3.length; ++var7_7) {
            switch (var3_3[var7_7]) {
                case '^': {
                    if (var4_4 /* !! */  == null) {
                        if (var5_5 == null) {
                            if (var6_6 == 0) {
                                var5_5 = new String(var3_3, var6_6, var7_7);
                            } else {
                                var6_6 = var7_7 + 1;
                                continue block16;
                            }
                        }
                        var4_4 /* !! */  = this.parseSimple(var1_1, (String)var5_5);
                        var5_5 = null;
                        if (var4_4 /* !! */  == null) {
                            return null;
                        }
                    }
                    if (var7_7 + 1 >= var3_3.length) ** GOTO lbl72
                    switch (var3_3[var7_7 + 1]) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            var4_4 /* !! */  = var1_1.parseCommit(var4_4 /* !! */ );
                            for (var8_8 = var7_7 + 1; var8_8 < var3_3.length && Character.isDigit(var3_3[var8_8]); ++var8_8) {
                            }
                            var9_11 = new String(var3_3, var7_7 + 1, var8_8 - var7_7 - 1);
                            try {
                                var10_13 = Integer.parseInt(var9_11);
                            }
                            catch (NumberFormatException var11_16) {
                                var12_21 = new RevisionSyntaxException(JGitText.get().invalidCommitParentNumber, var2_2);
                                var12_21.initCause(var11_16);
                                throw var12_21;
                            }
                            if (var10_13 != 0) {
                                var11_17 = (RevCommit)var4_4 /* !! */ ;
                                var4_4 /* !! */  = var10_13 > var11_17.getParentCount() ? null : var11_17.getParent(var10_13 - 1);
                            }
                            var7_7 = var8_8 - 1;
                            var6_6 = var8_8;
                            ** GOTO lbl77
                        }
                        case '{': {
                            var12_21 = null;
                            for (var11_18 = var7_7 + 2; var11_18 < var3_3.length; ++var11_18) {
                                if (var3_3[var11_18] != '}') continue;
                                var12_21 = new String(var3_3, var7_7 + 2, var11_18 - var7_7 - 2);
                                break;
                            }
                            var7_7 = var11_18;
                            if (var12_21 == null) ** GOTO lbl62
                            if (var12_21.equals("tree")) {
                                var4_4 /* !! */  = var1_1.parseTree(var4_4 /* !! */ );
                            } else if (var12_21.equals("commit")) {
                                var4_4 /* !! */  = var1_1.parseCommit(var4_4 /* !! */ );
                            } else if (var12_21.equals("blob")) {
                                if (!((var4_4 /* !! */  = var1_1.peel((RevObject)var4_4 /* !! */ )) instanceof RevBlob)) {
                                    throw new IncorrectObjectTypeException((ObjectId)var4_4 /* !! */ , "blob");
                                }
                            } else if (var12_21.isEmpty()) {
                                var4_4 /* !! */  = var1_1.peel((RevObject)var4_4 /* !! */ );
                            } else {
                                throw new RevisionSyntaxException(var2_2);
lbl62:
                                // 1 sources

                                throw new RevisionSyntaxException(var2_2);
                            }
                            var6_6 = var11_18;
                            ** GOTO lbl77
                        }
                        default: {
                            var4_4 /* !! */  = var1_1.peel((RevObject)var4_4 /* !! */ );
                            if (!(var4_4 /* !! */  instanceof RevCommit)) ** GOTO lbl71
                            var13_22 = (RevCommit)var4_4 /* !! */ ;
                            var4_4 /* !! */  = var13_22.getParentCount() == 0 ? null : var13_22.getParent(0);
                            ** GOTO lbl77
lbl71:
                            // 1 sources

                            throw new IncorrectObjectTypeException((ObjectId)var4_4 /* !! */ , "commit");
                        }
                    }
lbl72:
                    // 1 sources

                    if ((var4_4 /* !! */  = var1_1.peel((RevObject)var4_4 /* !! */ )) instanceof RevCommit) {
                        var8_9 = (RevCommit)var4_4 /* !! */ ;
                        var4_4 /* !! */  = var8_9.getParentCount() == 0 ? null : var8_9.getParent(0);
                    } else {
                        throw new IncorrectObjectTypeException((ObjectId)var4_4 /* !! */ , "commit");
                    }
lbl77:
                    // 4 sources

                    var6_6 = var7_7 + 1;
                    continue block16;
                }
                case '~': {
                    if (var4_4 /* !! */  == null) {
                        if (var5_5 == null) {
                            if (var6_6 == 0) {
                                var5_5 = new String(var3_3, var6_6, var7_7);
                            } else {
                                var6_6 = var7_7 + 1;
                                continue block16;
                            }
                        }
                        var4_4 /* !! */  = this.parseSimple(var1_1, (String)var5_5);
                        var5_5 = null;
                        if (var4_4 /* !! */  == null) {
                            return null;
                        }
                    }
                    if (!((var4_4 /* !! */  = var1_1.peel((RevObject)var4_4 /* !! */ )) instanceof RevCommit)) {
                        throw new IncorrectObjectTypeException((ObjectId)var4_4 /* !! */ , "commit");
                    }
                    for (var8_10 = var7_7 + 1; var8_10 < var3_3.length && Character.isDigit(var3_3[var8_10]); ++var8_10) {
                    }
                    if (var8_10 - var7_7 > 1) {
                        var10_14 = new String(var3_3, var7_7 + 1, var8_10 - var7_7 - 1);
                        try {
                            var9_12 = Integer.parseInt(var10_14);
                        }
                        catch (NumberFormatException var11_19) {
                            var12_21 = new RevisionSyntaxException(JGitText.get().invalidAncestryLength, var2_2);
                            var12_21.initCause(var11_19);
                            throw var12_21;
                        }
                    } else {
                        var9_12 = 1;
                    }
                    while (var9_12 > 0) {
                        var10_15 = (RevCommit)var4_4 /* !! */ ;
                        if (var10_15.getParentCount() == 0) {
                            var4_4 /* !! */  = null;
                            break;
                        }
                        var10_15 = var10_15.getParent(0);
                        var1_1.parseHeaders(var10_15);
                        var4_4 /* !! */  = var10_15;
                        --var9_12;
                    }
                    var7_7 = var8_10 - 1;
                    var6_6 = var8_10;
                    continue block16;
                }
                case '@': {
                    if (var4_4 /* !! */  != null) {
                        throw new RevisionSyntaxException(var2_2);
                    }
                    if (var7_7 + 1 == var3_3.length || var7_7 + 1 < var3_3.length && var3_3[var7_7 + 1] != '{') continue block16;
                    var11_20 = null;
                    for (var10_13 = var7_7 + 2; var10_13 < var3_3.length; ++var10_13) {
                        if (var3_3[var10_13] != '}') continue;
                        var11_20 = new String(var3_3, var7_7 + 2, var10_13 - var7_7 - 2);
                        break;
                    }
                    if (var11_20 != null) {
                        if (var11_20.equals("upstream")) {
                            if (var5_5 == null) {
                                var5_5 = new String(var3_3, var6_6, var7_7);
                            }
                            if (var5_5.isEmpty()) {
                                var5_5 = "HEAD";
                            }
                            if (!Repository.isValidRefName("x/" + (String)var5_5)) {
                                throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().invalidRefName, new Object[]{var5_5}), var2_2);
                            }
                            var12_21 = this.findRef((String)var5_5);
                            var5_5 = null;
                            if (var12_21 == null) {
                                return null;
                            }
                            if (var12_21.isSymbolic()) {
                                var12_21 = var12_21.getLeaf();
                            }
                            var5_5 = var12_21.getName();
                            try {
                                var13_22 = new RemoteConfig(this.getConfig(), "origin");
                            }
                            catch (URISyntaxException var14_24) {
                                var15_25 = new RevisionSyntaxException(var2_2);
                                var15_25.initCause(var14_24);
                                throw var15_25;
                            }
                            var14_23 = this.getConfig().getString("branch", Repository.shortenRefName(var12_21.getName()), "merge");
                            var15_25 = var13_22.getFetchRefSpecs();
                            var16_26 = var15_25.iterator();
                            while (var16_26.hasNext()) {
                                var17_27 = (RefSpec)var16_26.next();
                                if (!var17_27.matchSource(var14_23)) continue;
                                var18_28 = var17_27.expandFromSource(var14_23);
                                var5_5 = var18_28.getDestination();
                                break;
                            }
                            if (var5_5 == null) {
                                throw new RevisionSyntaxException(var2_2);
                            }
                        } else if (var11_20.matches("^-\\d+$")) {
                            if (var5_5 != null) {
                                throw new RevisionSyntaxException(var2_2);
                            }
                            var12_21 = this.resolveReflogCheckout(-Integer.parseInt(var11_20));
                            if (ObjectId.isId((String)var12_21)) {
                                var4_4 /* !! */  = this.parseSimple(var1_1, (String)var12_21);
                            } else {
                                var5_5 = var12_21;
                            }
                        } else {
                            if (var5_5 == null) {
                                var5_5 = new String(var3_3, var6_6, var7_7);
                            }
                            if (var5_5.isEmpty()) {
                                var5_5 = "HEAD";
                            }
                            if (!Repository.isValidRefName("x/" + (String)var5_5)) {
                                throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().invalidRefName, new Object[]{var5_5}), var2_2);
                            }
                            var12_21 = this.findRef((String)var5_5);
                            var5_5 = null;
                            if (var12_21 == null) {
                                return null;
                            }
                            if (var12_21.isSymbolic()) {
                                var12_21 = var12_21.getLeaf();
                            }
                            var4_4 /* !! */  = this.resolveReflog(var1_1, (Ref)var12_21, var11_20);
                        }
                        var7_7 = var10_13;
                        continue block16;
                    }
                    throw new RevisionSyntaxException(var2_2);
                }
                case ':': {
                    if (var4_4 /* !! */  == null) {
                        if (var5_5 == null) {
                            var5_5 = new String(var3_3, var6_6, var7_7);
                        }
                        if (var5_5.isEmpty()) {
                            var5_5 = "HEAD";
                        }
                        var4_4 /* !! */  = this.parseSimple(var1_1, (String)var5_5);
                        var5_5 = null;
                    }
                    if (var4_4 /* !! */  == null) {
                        return null;
                    }
                    var12_21 = var1_1.parseTree(var4_4 /* !! */ );
                    if (var7_7 == var3_3.length - 1) {
                        return var12_21.copy();
                    }
                    var13_22 = TreeWalk.forPath(var1_1.getObjectReader(), new String(var3_3, var7_7 + 1, var3_3.length - var7_7 - 1), new AnyObjectId[]{var12_21});
                    return var13_22 != null ? var13_22.getObjectId(0) : null;
                }
                default: {
                    if (var4_4 /* !! */  == null) continue block16;
                    throw new RevisionSyntaxException(var2_2);
                }
            }
        }
        if (var4_4 /* !! */  != null) {
            return var4_4 /* !! */ .copy();
        }
        if (var5_5 != null) {
            return var5_5;
        }
        if (var6_6 == var2_2.length()) {
            return null;
        }
        var5_5 = var2_2.substring(var6_6);
        if (!Repository.isValidRefName("x/" + (String)var5_5)) {
            throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().invalidRefName, new Object[]{var5_5}), var2_2);
        }
        if (this.findRef((String)var5_5) != null) {
            return var5_5;
        }
        return this.resolveSimple((String)var5_5);
    }

    private static boolean isHex(char c2) {
        return '0' <= c2 && c2 <= '9' || 'a' <= c2 && c2 <= 'f' || 'A' <= c2 && c2 <= 'F';
    }

    private static boolean isAllHex(String string, int n2) {
        while (n2 < string.length()) {
            if (Repository.isHex(string.charAt(n2++))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private RevObject parseSimple(RevWalk revWalk, String string) {
        ObjectId objectId = this.resolveSimple(string);
        return objectId != null ? revWalk.parseAny(objectId) : null;
    }

    @Nullable
    private ObjectId resolveSimple(String string) {
        String string2;
        Ref ref;
        if (ObjectId.isId(string)) {
            return ObjectId.fromString(string);
        }
        if (Repository.isValidRefName("x/" + string) && (ref = this.getRefDatabase().findRef(string)) != null) {
            return ref.getObjectId();
        }
        if (AbbreviatedObjectId.isId(string)) {
            return this.resolveAbbreviation(string);
        }
        int n2 = string.indexOf("-g");
        if (n2 + 5 < string.length() && 0 <= n2 && Repository.isHex(string.charAt(n2 + 2)) && Repository.isHex(string.charAt(n2 + 3)) && Repository.isAllHex(string, n2 + 4) && AbbreviatedObjectId.isId(string2 = string.substring(n2 + 2))) {
            return this.resolveAbbreviation(string2);
        }
        return null;
    }

    @Nullable
    private String resolveReflogCheckout(int n2) {
        ReflogReader reflogReader = this.getReflogReader("HEAD");
        if (reflogReader == null) {
            return null;
        }
        List list = reflogReader.getReverseEntries();
        for (ReflogEntry reflogEntry : list) {
            CheckoutEntry checkoutEntry = reflogEntry.parseCheckout();
            if (checkoutEntry == null || n2-- != 1) continue;
            return checkoutEntry.getFromBranch();
        }
        return null;
    }

    private RevCommit resolveReflog(RevWalk revWalk, Ref ref, String string) {
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            RevisionSyntaxException revisionSyntaxException = new RevisionSyntaxException(MessageFormat.format(JGitText.get().invalidReflogRevision, string));
            revisionSyntaxException.initCause(numberFormatException);
            throw revisionSyntaxException;
        }
        assert (n2 >= 0);
        ReflogReader reflogReader = this.getReflogReader(ref.getName());
        if (reflogReader == null) {
            throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().reflogEntryNotFound, n2, ref.getName()));
        }
        ReflogEntry reflogEntry = reflogReader.getReverseEntry(n2);
        if (reflogEntry == null) {
            throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().reflogEntryNotFound, n2, ref.getName()));
        }
        return revWalk.parseCommit(reflogEntry.getNewId());
    }

    @Nullable
    private ObjectId resolveAbbreviation(String string) {
        AbbreviatedObjectId abbreviatedObjectId = AbbreviatedObjectId.fromString(string);
        Throwable throwable = null;
        try (ObjectReader objectReader = this.newObjectReader();){
            Collection collection = objectReader.resolve(abbreviatedObjectId);
            if (collection.isEmpty()) {
                ObjectId objectId = null;
                return objectId;
            }
            if (collection.size() == 1) {
                ObjectId objectId = (ObjectId)collection.iterator().next();
                return objectId;
            }
            try {
                throw new AmbiguousObjectException(abbreviatedObjectId, collection);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void incrementOpen() {
        this.useCnt.incrementAndGet();
    }

    @Override
    public void close() {
        this.closeReturnValue();
    }

    public boolean closeReturnValue() {
        int n2 = this.useCnt.decrementAndGet();
        boolean bl2 = false;
        if (n2 == 0) {
            if (RepositoryCache.isCached(this)) {
                this.closedAt.set(System.currentTimeMillis());
            } else {
                this.doClose();
                bl2 = true;
            }
        } else if (n2 == -1) {
            String string = MessageFormat.format(JGitText.get().corruptUseCnt, this.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug(string, (Throwable)new IllegalStateException());
            } else {
                LOG.warn(string);
            }
            if (RepositoryCache.isCached(this)) {
                this.closedAt.set(System.currentTimeMillis());
            }
        }
        return bl2;
    }

    protected void doClose() {
        this.getObjectDatabase().close();
        this.getRefDatabase().close();
    }

    @NonNull
    public String toString() {
        File file = this.getDirectory();
        String string = file != null ? file.getPath() : this.getClass().getSimpleName() + "-" + System.identityHashCode(this);
        return "Repository[" + string + "]";
    }

    @Nullable
    public String getFullBranch() {
        Ref ref = this.exactRef("HEAD");
        if (ref == null) {
            return null;
        }
        if (ref.isSymbolic()) {
            return ref.getTarget().getName();
        }
        ObjectId objectId = ref.getObjectId();
        if (objectId != null) {
            return objectId.name();
        }
        return null;
    }

    @Nullable
    public String getBranch() {
        String string = this.getFullBranch();
        if (string != null) {
            return Repository.shortenRefName(string);
        }
        return null;
    }

    @NonNull
    protected String getInitialBranch() {
        return this.initialBranch;
    }

    @NonNull
    public Set getAdditionalHaves() {
        return Collections.emptySet();
    }

    @Nullable
    public final Ref exactRef(String string) {
        return this.getRefDatabase().exactRef(string);
    }

    @Nullable
    public final Ref findRef(String string) {
        return this.getRefDatabase().findRef(string);
    }

    @Deprecated
    @NonNull
    public Map getAllRefs() {
        try {
            return this.getRefDatabase().getRefs("");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Deprecated
    @NonNull
    public Map getTags() {
        try {
            return this.getRefDatabase().getRefs("refs/tags/");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Deprecated
    @NonNull
    public Ref peel(Ref ref) {
        try {
            return this.getRefDatabase().peel(ref);
        }
        catch (IOException iOException) {
            return ref;
        }
    }

    @NonNull
    public Map getAllRefsByPeeledObjectId() {
        Map map = this.getAllRefs();
        HashMap<ObjectId, Set<Ref>> hashMap = new HashMap<ObjectId, Set<Ref>>(map.size());
        for (Ref ref : map.values()) {
            Set<Ref> set;
            ObjectId objectId = (ref = this.peel(ref)).getPeeledObjectId();
            if (objectId == null) {
                objectId = ref.getObjectId();
            }
            if ((set = hashMap.put(objectId, Collections.singleton(ref))) == null) continue;
            if (set.size() == 1) {
                set = new HashSet<Ref>(set);
            }
            hashMap.put(objectId, set);
            set.add(ref);
        }
        return hashMap;
    }

    @NonNull
    public File getIndexFile() {
        if (this.isBare()) {
            throw new NoWorkTreeException();
        }
        return this.indexFile;
    }

    public RevCommit parseCommit(AnyObjectId anyObjectId) {
        if (anyObjectId instanceof RevCommit && ((RevCommit)anyObjectId).getRawBuffer() != null) {
            return (RevCommit)anyObjectId;
        }
        try (RevWalk revWalk = new RevWalk(this);){
            RevCommit revCommit = revWalk.parseCommit(anyObjectId);
            return revCommit;
        }
    }

    @NonNull
    public DirCache readDirCache() {
        return DirCache.read(this);
    }

    @NonNull
    public DirCache lockDirCache() {
        IndexChangedListener indexChangedListener = indexChangedEvent -> this.notifyIndexChanged(true);
        return DirCache.lock(this, indexChangedListener);
    }

    @NonNull
    public RepositoryState getRepositoryState() {
        if (this.isBare() || this.getDirectory() == null) {
            return RepositoryState.BARE;
        }
        if (new File(this.getWorkTree(), ".dotest").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.getDirectory(), ".dotest-merge").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-apply/rebasing").exists()) {
            return RepositoryState.REBASING_REBASING;
        }
        if (new File(this.getDirectory(), "rebase-apply/applying").exists()) {
            return RepositoryState.APPLY;
        }
        if (new File(this.getDirectory(), "rebase-apply").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.getDirectory(), "rebase-merge/interactive").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-merge").exists()) {
            return RepositoryState.REBASING_MERGE;
        }
        if (new File(this.getDirectory(), "MERGE_HEAD").exists()) {
            try {
                if (!this.readDirCache().hasUnmergedPaths()) {
                    return RepositoryState.MERGING_RESOLVED;
                }
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            return RepositoryState.MERGING;
        }
        if (new File(this.getDirectory(), "BISECT_LOG").exists()) {
            return RepositoryState.BISECTING;
        }
        if (new File(this.getDirectory(), "CHERRY_PICK_HEAD").exists()) {
            try {
                if (!this.readDirCache().hasUnmergedPaths()) {
                    return RepositoryState.CHERRY_PICKING_RESOLVED;
                }
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            return RepositoryState.CHERRY_PICKING;
        }
        if (new File(this.getDirectory(), "REVERT_HEAD").exists()) {
            try {
                if (!this.readDirCache().hasUnmergedPaths()) {
                    return RepositoryState.REVERTING_RESOLVED;
                }
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            return RepositoryState.REVERTING;
        }
        return RepositoryState.SAFE;
    }

    public static boolean isValidRefName(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return false;
        }
        if (string.endsWith(".lock")) {
            return false;
        }
        try {
            SystemReader.getInstance().checkPath(string);
        }
        catch (CorruptObjectException corruptObjectException) {
            return false;
        }
        int n3 = 1;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= ' ') {
                return false;
            }
            switch (c2) {
                case '.': {
                    switch (n4) {
                        case 0: 
                        case 46: 
                        case 47: {
                            return false;
                        }
                    }
                    if (i2 != n2 - 1) break;
                    return false;
                }
                case '/': {
                    if (i2 == 0 || i2 == n2 - 1) {
                        return false;
                    }
                    if (n4 == 47) {
                        return false;
                    }
                    ++n3;
                    break;
                }
                case '{': {
                    if (n4 != 64) break;
                    return false;
                }
                case '*': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '~': 
                case '\u007f': {
                    return false;
                }
            }
            n4 = c2;
        }
        return n3 > 1;
    }

    public static String normalizeBranchName(String string) {
        String string2;
        if (string == null || string.isEmpty()) {
            return "";
        }
        String string3 = string.trim();
        String string4 = string2 = string3.startsWith("refs/heads/") ? string3 : "refs/heads/" + string3;
        if (Repository.isValidRefName(string2)) {
            return string3;
        }
        string3 = string3.replaceAll("(?:\\h|\\v)+", "_");
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 47;
        int n3 = string3.length();
        block7: for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = string3.charAt(i2);
            if (n4 < 32 || n4 == 127) continue;
            switch (n4) {
                case 34: 
                case 42: 
                case 58: 
                case 60: 
                case 62: 
                case 63: 
                case 64: 
                case 91: 
                case 92: 
                case 94: 
                case 124: 
                case 126: {
                    n4 = 45;
                    break;
                }
            }
            switch (n4) {
                case 47: {
                    if (n2 == 47) continue block7;
                    n2 = 47;
                    break;
                }
                case 45: 
                case 46: 
                case 95: {
                    if (n2 == 47 || n2 == 45) continue block7;
                    n2 = 45;
                    break;
                }
                default: {
                    n2 = n4;
                }
            }
            stringBuilder.append((char)n4);
        }
        string3 = stringBuilder.toString().replaceFirst("[/_.-]+$", "").replaceAll("\\.lock($|/)", "_lock$1");
        return FORBIDDEN_BRANCH_NAME_COMPONENTS.matcher(string3).replaceAll("$1+$2$3");
    }

    @NonNull
    public static String stripWorkDir(File file, File file2) {
        String string = file2.getPath();
        String string2 = file.getPath();
        if (string.length() <= string2.length() || string.charAt(string2.length()) != File.separatorChar || !string.startsWith(string2)) {
            File file3;
            File file4 = file.isAbsolute() ? file : file.getAbsoluteFile();
            File file5 = file3 = file2.isAbsolute() ? file2 : file2.getAbsoluteFile();
            if (file4.equals(file) && file3.equals(file2)) {
                return "";
            }
            return Repository.stripWorkDir(file4, file3);
        }
        String string3 = string.substring(string2.length() + 1);
        if (File.separatorChar != '/') {
            string3 = string3.replace(File.separatorChar, '/');
        }
        return string3;
    }

    public boolean isBare() {
        return this.workTree == null;
    }

    @NonNull
    public File getWorkTree() {
        if (this.isBare()) {
            throw new NoWorkTreeException();
        }
        return this.workTree;
    }

    public abstract void scanForRepoChanges();

    public abstract void notifyIndexChanged(boolean var1);

    @NonNull
    public static String shortenRefName(String string) {
        if (string.startsWith("refs/heads/")) {
            return string.substring("refs/heads/".length());
        }
        if (string.startsWith("refs/tags/")) {
            return string.substring("refs/tags/".length());
        }
        if (string.startsWith("refs/remotes/")) {
            return string.substring("refs/remotes/".length());
        }
        return string;
    }

    @Nullable
    public String shortenRemoteBranchName(String string) {
        for (String string2 : this.getRemoteNames()) {
            String string3 = "refs/remotes/" + string2 + "/";
            if (!string.startsWith(string3)) continue;
            return string.substring(string3.length());
        }
        return null;
    }

    @Nullable
    public String getRemoteName(String string) {
        for (String string2 : this.getRemoteNames()) {
            String string3 = "refs/remotes/" + string2 + "/";
            if (!string.startsWith(string3)) continue;
            return string2;
        }
        return null;
    }

    @Nullable
    public String getGitwebDescription() {
        return null;
    }

    public void setGitwebDescription(@Nullable String string) {
        throw new IOException(JGitText.get().unsupportedRepositoryDescription);
    }

    @Nullable
    public abstract ReflogReader getReflogReader(String var1);

    @Nullable
    public ReflogReader getReflogReader(@NonNull Ref ref) {
        return this.getReflogReader(ref.getName());
    }

    @Nullable
    public String readMergeCommitMsg() {
        return this.readCommitMsgFile("MERGE_MSG");
    }

    public void writeMergeCommitMsg(String string) {
        File file = new File(this.gitDir, "MERGE_MSG");
        this.writeCommitMsg(file, string);
    }

    @Nullable
    public String readCommitEditMsg() {
        return this.readCommitMsgFile("COMMIT_EDITMSG");
    }

    public void writeCommitEditMsg(String string) {
        File file = new File(this.gitDir, "COMMIT_EDITMSG");
        this.writeCommitMsg(file, string);
    }

    @Nullable
    public List readMergeHeads() {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] byArray = this.readGitDirectoryFile("MERGE_HEAD");
        if (byArray == null) {
            return null;
        }
        LinkedList<ObjectId> linkedList = new LinkedList<ObjectId>();
        int n2 = 0;
        while (n2 < byArray.length) {
            linkedList.add(ObjectId.fromString(byArray, n2));
            n2 = RawParseUtils.nextLF(byArray, n2 + 40);
        }
        return linkedList;
    }

    public void writeMergeHeads(List list) {
        this.writeHeadsFile(list, "MERGE_HEAD");
    }

    @Nullable
    public ObjectId readCherryPickHead() {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] byArray = this.readGitDirectoryFile("CHERRY_PICK_HEAD");
        if (byArray == null) {
            return null;
        }
        return ObjectId.fromString(byArray, 0);
    }

    @Nullable
    public ObjectId readRevertHead() {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] byArray = this.readGitDirectoryFile("REVERT_HEAD");
        if (byArray == null) {
            return null;
        }
        return ObjectId.fromString(byArray, 0);
    }

    public void writeCherryPickHead(ObjectId objectId) {
        List<ObjectId> list = objectId != null ? Collections.singletonList(objectId) : null;
        this.writeHeadsFile(list, "CHERRY_PICK_HEAD");
    }

    public void writeRevertHead(ObjectId objectId) {
        List<ObjectId> list = objectId != null ? Collections.singletonList(objectId) : null;
        this.writeHeadsFile(list, "REVERT_HEAD");
    }

    public void writeOrigHead(ObjectId objectId) {
        List<ObjectId> list = objectId != null ? Collections.singletonList(objectId) : null;
        this.writeHeadsFile(list, "ORIG_HEAD");
    }

    @Nullable
    public ObjectId readOrigHead() {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] byArray = this.readGitDirectoryFile("ORIG_HEAD");
        return byArray != null ? ObjectId.fromString(byArray, 0) : null;
    }

    @Nullable
    public String readSquashCommitMsg() {
        return this.readCommitMsgFile("SQUASH_MSG");
    }

    public void writeSquashCommitMsg(String string) {
        File file = new File(this.gitDir, "SQUASH_MSG");
        this.writeCommitMsg(file, string);
    }

    @Nullable
    private String readCommitMsgFile(String string) {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        File file = this.getDirectoryChild(string);
        try {
            return RawParseUtils.decode(IO.readFully(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (file.exists()) {
                throw fileNotFoundException;
            }
            return null;
        }
    }

    private void writeCommitMsg(File file, String string) {
        if (string != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            }
        } else {
            FileUtils.delete(file, 4);
        }
    }

    private byte[] readGitDirectoryFile(String string) {
        File file = this.getDirectoryChild(string);
        try {
            byte[] byArray = IO.readFully(file);
            return (byte[])(byArray.length > 0 ? byArray : null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (file.exists()) {
                throw fileNotFoundException;
            }
            return null;
        }
    }

    private void writeHeadsFile(List list, String string) {
        File file = new File(this.getDirectory(), string);
        if (list != null) {
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
                for (ObjectId objectId : list) {
                    objectId.copyTo(bufferedOutputStream);
                    ((OutputStream)bufferedOutputStream).write(10);
                }
            }
        } else {
            FileUtils.delete(file, 4);
        }
    }

    @NonNull
    public List readRebaseTodo(String string, boolean bl2) {
        return new RebaseTodoFile(this).readRebaseTodo(string, bl2);
    }

    public void writeRebaseTodoFile(String string, List list, boolean bl2) {
        new RebaseTodoFile(this).writeRebaseTodoFile(string, list, bl2);
    }

    @NonNull
    public Set getRemoteNames() {
        return this.getConfig().getSubsections("remote");
    }

    public void autoGC(ProgressMonitor progressMonitor) {
    }
}

