/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefMap;

public abstract class RefWriter {
    private final Collection refs;

    public RefWriter(Collection collection) {
        this.refs = RefComparator.sort(collection);
    }

    public RefWriter(Map map) {
        this.refs = map instanceof RefMap ? map.values() : RefComparator.sort(map.values());
    }

    public RefWriter(RefList refList) {
        this.refs = refList.asList();
    }

    public void writeInfoRefs() {
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[40];
        for (Ref ref : this.refs) {
            ObjectId objectId;
            if ("HEAD".equals(ref.getName()) || (objectId = ref.getObjectId()) == null) continue;
            objectId.copyTo(cArray, stringWriter);
            stringWriter.write(9);
            stringWriter.write(ref.getName());
            stringWriter.write(10);
            ObjectId objectId2 = ref.getPeeledObjectId();
            if (objectId2 == null) continue;
            objectId2.copyTo(cArray, stringWriter);
            stringWriter.write(9);
            stringWriter.write(ref.getName());
            stringWriter.write("^{}\n");
        }
        this.writeFile("info/refs", Constants.encode(stringWriter.toString()));
    }

    public void writePackedRefs() {
        Object object2;
        boolean bl2 = false;
        for (Object object2 : this.refs) {
            if (!object2.getStorage().isPacked() || !object2.isPeeled()) continue;
            bl2 = true;
            break;
        }
        StringWriter stringWriter = new StringWriter();
        if (bl2) {
            stringWriter.write("# pack-refs with:");
            if (bl2) {
                stringWriter.write(" peeled");
            }
            stringWriter.write(10);
        }
        object2 = new char[40];
        for (Ref ref : this.refs) {
            if (ref.getStorage() != Ref$Storage.PACKED) continue;
            ObjectId objectId = ref.getObjectId();
            if (objectId == null) {
                throw new NullPointerException();
            }
            objectId.copyTo((char[])object2, stringWriter);
            stringWriter.write(32);
            stringWriter.write(ref.getName());
            stringWriter.write(10);
            ObjectId objectId2 = ref.getPeeledObjectId();
            if (objectId2 == null) continue;
            stringWriter.write(94);
            objectId2.copyTo((char[])object2, stringWriter);
            stringWriter.write(10);
        }
        this.writeFile("packed-refs", Constants.encode(stringWriter.toString()));
    }

    protected abstract void writeFile(String var1, byte[] var2);
}

