/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate$1;
import org.eclipse.jgit.lib.RefUpdate$2;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.RefUpdate$Store;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.util.References;

public abstract class RefUpdate {
    private ObjectId newValue;
    private boolean force;
    private PersonIdent refLogIdent;
    private String refLogMessage;
    private boolean refLogIncludeResult;
    private boolean forceRefLog;
    private ObjectId oldValue;
    private ObjectId expValue;
    private RefUpdate$Result result = RefUpdate$Result.NOT_ATTEMPTED;
    private PushCertificate pushCert;
    private final Ref ref;
    private boolean detachingSymbolicRef;
    private boolean checkConflicting = true;

    protected RefUpdate(Ref ref) {
        this.ref = ref;
        this.oldValue = ref.getObjectId();
        this.refLogMessage = "";
    }

    protected abstract RefDatabase getRefDatabase();

    protected abstract Repository getRepository();

    protected abstract boolean tryLock(boolean var1);

    protected abstract void unlock();

    protected abstract RefUpdate$Result doUpdate(RefUpdate$Result var1);

    protected abstract RefUpdate$Result doDelete(RefUpdate$Result var1);

    protected abstract RefUpdate$Result doLink(String var1);

    public String getName() {
        return this.getRef().getName();
    }

    public Ref getRef() {
        return this.ref;
    }

    public ObjectId getNewObjectId() {
        return this.newValue;
    }

    public void setDetachingSymbolicRef() {
        this.detachingSymbolicRef = true;
    }

    public boolean isDetachingSymbolicRef() {
        return this.detachingSymbolicRef;
    }

    public void setNewObjectId(AnyObjectId anyObjectId) {
        this.newValue = anyObjectId.copy();
    }

    public ObjectId getExpectedOldObjectId() {
        return this.expValue;
    }

    public void setExpectedOldObjectId(AnyObjectId anyObjectId) {
        this.expValue = anyObjectId != null ? anyObjectId.toObjectId() : null;
    }

    public boolean isForceUpdate() {
        return this.force;
    }

    public void setForceUpdate(boolean bl2) {
        this.force = bl2;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public void setRefLogIdent(PersonIdent personIdent) {
        this.refLogIdent = personIdent;
    }

    public String getRefLogMessage() {
        return this.refLogMessage;
    }

    protected boolean isRefLogIncludingResult() {
        return this.refLogIncludeResult;
    }

    public void setRefLogMessage(String string, boolean bl2) {
        if (string == null && !bl2) {
            this.disableRefLog();
        } else if (string == null && bl2) {
            this.refLogMessage = "";
            this.refLogIncludeResult = true;
        } else {
            this.refLogMessage = string;
            this.refLogIncludeResult = bl2;
        }
    }

    public void disableRefLog() {
        this.refLogMessage = null;
        this.refLogIncludeResult = false;
    }

    public void setForceRefLog(boolean bl2) {
        this.forceRefLog = bl2;
    }

    protected boolean isForceRefLog() {
        return this.forceRefLog;
    }

    public ObjectId getOldObjectId() {
        return this.oldValue;
    }

    protected void setOldObjectId(ObjectId objectId) {
        this.oldValue = objectId;
    }

    public void setPushCertificate(PushCertificate pushCertificate) {
        this.pushCert = pushCertificate;
    }

    protected PushCertificate getPushCertificate() {
        return this.pushCert;
    }

    public RefUpdate$Result getResult() {
        return this.result;
    }

    private void requireCanDoUpdate() {
        if (this.newValue == null) {
            throw new IllegalStateException(JGitText.get().aNewObjectIdIsRequired);
        }
    }

    public RefUpdate$Result forceUpdate() {
        this.force = true;
        return this.update();
    }

    public RefUpdate$Result update() {
        try (RevWalk revWalk = new RevWalk(this.getRepository());){
            revWalk.setRetainBody(false);
            RefUpdate$Result refUpdate$Result = this.update(revWalk);
            return refUpdate$Result;
        }
    }

    public RefUpdate$Result update(RevWalk revWalk) {
        this.requireCanDoUpdate();
        try {
            this.result = this.updateImpl(revWalk, new RefUpdate$1(this));
            return this.result;
        }
        catch (IOException iOException) {
            this.result = RefUpdate$Result.IO_FAILURE;
            throw iOException;
        }
    }

    public RefUpdate$Result delete() {
        try (RevWalk revWalk = new RevWalk(this.getRepository());){
            revWalk.setRetainBody(false);
            RefUpdate$Result refUpdate$Result = this.delete(revWalk);
            return refUpdate$Result;
        }
    }

    public RefUpdate$Result delete(RevWalk revWalk) {
        String string;
        String string2 = string = this.detachingSymbolicRef ? this.getRef().getName() : this.getRef().getLeaf().getName();
        if (string.startsWith("refs/heads/") && !this.getRepository().isBare()) {
            Ref ref = this.getRefDatabase().exactRef("HEAD");
            while (ref != null && ref.isSymbolic()) {
                if (!string.equals((ref = ref.getTarget()).getName())) continue;
                this.result = RefUpdate$Result.REJECTED_CURRENT_BRANCH;
                return this.result;
            }
        }
        try {
            this.result = this.updateImpl(revWalk, new RefUpdate$2(this));
            return this.result;
        }
        catch (IOException iOException) {
            this.result = RefUpdate$Result.IO_FAILURE;
            throw iOException;
        }
    }

    public RefUpdate$Result link(String string) {
        if (!string.startsWith("refs/")) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalArgumentNotA, "refs/"));
        }
        if (this.checkConflicting && this.getRefDatabase().isNameConflicting(this.getName())) {
            return RefUpdate$Result.LOCK_FAILURE;
        }
        try {
            Ref ref;
            if (!this.tryLock(false)) {
                RefUpdate$Result refUpdate$Result = RefUpdate$Result.LOCK_FAILURE;
                return refUpdate$Result;
            }
            Ref ref2 = this.getRefDatabase().exactRef(this.getName());
            if (ref2 != null && ref2.isSymbolic() && string.equals((ref = ref2.getTarget()).getName())) {
                RefUpdate$Result refUpdate$Result = this.result = RefUpdate$Result.NO_CHANGE;
                return refUpdate$Result;
            }
            if (ref2 != null && ref2.getObjectId() != null) {
                this.setOldObjectId(ref2.getObjectId());
            }
            if ((ref = this.getRefDatabase().exactRef(string)) != null && ref.getObjectId() != null) {
                this.setNewObjectId(ref.getObjectId());
            }
            RefUpdate$Result refUpdate$Result = this.result = this.doLink(string);
            return refUpdate$Result;
        }
        catch (IOException iOException) {
            this.result = RefUpdate$Result.IO_FAILURE;
            throw iOException;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefUpdate$Result updateImpl(RevWalk revWalk, RefUpdate$Store refUpdate$Store) {
        if (this.oldValue == null && this.checkConflicting && this.getRefDatabase().isNameConflicting(this.getName())) {
            return RefUpdate$Result.LOCK_FAILURE;
        }
        try {
            RevObject revObject;
            Object object;
            if (!this.tryLock(!this.detachingSymbolicRef)) {
                RefUpdate$Result refUpdate$Result = RefUpdate$Result.LOCK_FAILURE;
                return refUpdate$Result;
            }
            if (this.expValue != null) {
                ObjectId objectId = object = this.oldValue != null ? this.oldValue : ObjectId.zeroId();
                if (!AnyObjectId.isEqual(this.expValue, object)) {
                    RefUpdate$Result refUpdate$Result = RefUpdate$Result.LOCK_FAILURE;
                    return refUpdate$Result;
                }
            }
            try {
                revObject = RefUpdate.safeParseNew(revWalk, this.newValue);
            }
            catch (MissingObjectException missingObjectException) {
                RefUpdate$Result refUpdate$Result = RefUpdate$Result.REJECTED_MISSING_OBJECT;
                this.unlock();
                return refUpdate$Result;
            }
            if (this.oldValue == null) {
                object = refUpdate$Store.execute(RefUpdate$Result.NEW);
                return object;
            }
            RevObject revObject2 = RefUpdate.safeParseOld(revWalk, this.oldValue);
            if (References.isSameObject(revObject, revObject2) && !this.detachingSymbolicRef) {
                object = refUpdate$Store.execute(RefUpdate$Result.NO_CHANGE);
                return object;
            }
            if (this.isForceUpdate()) {
                object = refUpdate$Store.execute(RefUpdate$Result.FORCED);
                return object;
            }
            if (revObject instanceof RevCommit && revObject2 instanceof RevCommit && revWalk.isMergedInto((RevCommit)revObject2, (RevCommit)revObject)) {
                object = refUpdate$Store.execute(RefUpdate$Result.FAST_FORWARD);
                return object;
            }
            object = RefUpdate$Result.REJECTED;
            return object;
        }
        finally {
            this.unlock();
        }
    }

    public void setCheckConflicting(boolean bl2) {
        this.checkConflicting = bl2;
    }

    private static RevObject safeParseNew(RevWalk revWalk, AnyObjectId anyObjectId) {
        if (anyObjectId == null || ObjectId.zeroId().equals(anyObjectId)) {
            return null;
        }
        return revWalk.parseAny(anyObjectId);
    }

    private static RevObject safeParseOld(RevWalk revWalk, AnyObjectId anyObjectId) {
        try {
            return anyObjectId != null ? revWalk.parseAny(anyObjectId) : null;
        }
        catch (MissingObjectException missingObjectException) {
            return null;
        }
    }
}

