/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;

public abstract class RefRename {
    protected final RefUpdate source;
    protected final RefUpdate destination;
    private RefUpdate$Result result = RefUpdate$Result.NOT_ATTEMPTED;

    protected RefRename(RefUpdate refUpdate, RefUpdate refUpdate2) {
        this.source = refUpdate;
        this.destination = refUpdate2;
        String string = "";
        if (this.source.getName().startsWith("refs/heads/") && this.destination.getName().startsWith("refs/heads/")) {
            string = "Branch: ";
        }
        this.setRefLogMessage(string + "renamed " + Repository.shortenRefName(this.source.getName()) + " to " + Repository.shortenRefName(this.destination.getName()));
    }

    public PersonIdent getRefLogIdent() {
        return this.destination.getRefLogIdent();
    }

    public void setRefLogIdent(PersonIdent personIdent) {
        this.destination.setRefLogIdent(personIdent);
    }

    public String getRefLogMessage() {
        return this.destination.getRefLogMessage();
    }

    public void setRefLogMessage(String string) {
        if (string == null) {
            this.disableRefLog();
        } else {
            this.destination.setRefLogMessage(string, false);
        }
    }

    public void disableRefLog() {
        this.destination.setRefLogMessage("", false);
    }

    public RefUpdate$Result getResult() {
        return this.result;
    }

    public RefUpdate$Result rename() {
        try {
            this.result = this.doRename();
            return this.result;
        }
        catch (IOException iOException) {
            this.result = RefUpdate$Result.IO_FAILURE;
            throw iOException;
        }
    }

    protected abstract RefUpdate$Result doRename();

    protected boolean needToUpdateHEAD() {
        Ref ref = this.source.getRefDatabase().exactRef("HEAD");
        if (ref != null && ref.isSymbolic()) {
            ref = ref.getTarget();
            return ref.getName().equals(this.source.getName());
        }
        return false;
    }
}

