/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;

public abstract class RefDatabase {
    protected static final String[] SEARCH_PATH = new String[]{"", "refs/", "refs/tags/", "refs/heads/", "refs/remotes/"};
    public static final int MAX_SYMBOLIC_REF_DEPTH = 5;
    public static final String ALL = "";

    public abstract void create();

    public abstract void close();

    public boolean hasVersioning() {
        return false;
    }

    public abstract boolean isNameConflicting(String var1);

    @NonNull
    public Collection getConflictingNames(String string) {
        Object object;
        Map map = this.getRefs(ALL);
        int n2 = string.lastIndexOf(47);
        while (0 < n2) {
            object = string.substring(0, n2);
            if (map.containsKey(object)) {
                return Collections.singletonList(object);
            }
            n2 = string.lastIndexOf(47, n2 - 1);
        }
        object = new ArrayList();
        String string2 = string + '/';
        for (String string3 : map.keySet()) {
            if (!string3.startsWith(string2)) continue;
            object.add(string3);
        }
        return object;
    }

    @NonNull
    public abstract RefUpdate newUpdate(String var1, boolean var2);

    @NonNull
    public abstract RefRename newRename(String var1, String var2);

    @NonNull
    public BatchRefUpdate newBatchUpdate() {
        return new BatchRefUpdate(this);
    }

    public boolean performsAtomicTransactions() {
        return false;
    }

    @Deprecated
    @Nullable
    public final Ref getRef(String string) {
        return this.findRef(string);
    }

    @Nullable
    public final Ref findRef(String string) {
        String[] stringArray = new String[SEARCH_PATH.length];
        for (int i2 = 0; i2 < SEARCH_PATH.length; ++i2) {
            stringArray[i2] = SEARCH_PATH[i2] + string;
        }
        return this.firstExactRef(stringArray);
    }

    @Nullable
    public abstract Ref exactRef(String var1);

    @NonNull
    public Map exactRef(String ... stringArray) {
        HashMap<String, Ref> hashMap = new HashMap<String, Ref>(stringArray.length);
        for (String string : stringArray) {
            Ref ref = this.exactRef(string);
            if (ref == null) continue;
            hashMap.put(string, ref);
        }
        return hashMap;
    }

    @Nullable
    public Ref firstExactRef(String ... stringArray) {
        for (String string : stringArray) {
            Ref ref = this.exactRef(string);
            if (ref == null) continue;
            return ref;
        }
        return null;
    }

    @NonNull
    public List getRefs() {
        return this.getRefsByPrefix(ALL);
    }

    @Deprecated
    @NonNull
    public abstract Map getRefs(String var1);

    @NonNull
    public List getRefsByPrefix(String string) {
        List list;
        int n2 = string.lastIndexOf(47);
        Map map = n2 == -1 ? this.getRefs(ALL) : this.getRefs(string.substring(0, n2 + 1));
        if (n2 + 1 == string.length()) {
            list = map.values().stream().collect(Collectors.toList());
        } else {
            String string2 = string.substring(n2 + 1);
            list = map.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(string2)).map(entry -> (Ref)entry.getValue()).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(list);
    }

    @NonNull
    public List getRefsByPrefixWithExclusions(String string, Set set) {
        Stream<Object> stream = this.getRefs(string).values().stream();
        for (String string2 : set) {
            stream = stream.filter(ref -> !ref.getName().startsWith(string2));
        }
        return Collections.unmodifiableList(stream.collect(Collectors.toList()));
    }

    @NonNull
    public List getRefsByPrefix(String ... stringArray) {
        ArrayList arrayList = new ArrayList();
        for (String string : stringArray) {
            arrayList.addAll(this.getRefsByPrefix(string));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @NonNull
    public Set getTipsWithSha1(ObjectId objectId) {
        return this.getRefs().stream().filter(ref -> objectId.equals(ref.getObjectId()) || objectId.equals(ref.getPeeledObjectId())).collect(Collectors.toSet());
    }

    public boolean hasFastTipsWithSha1() {
        return false;
    }

    public boolean hasRefs() {
        return !this.getRefs().isEmpty();
    }

    @NonNull
    public abstract List getAdditionalRefs();

    @NonNull
    public abstract Ref peel(Ref var1);

    public void refresh() {
    }

    @Nullable
    public static Ref findRef(Map map, String string) {
        for (String string2 : SEARCH_PATH) {
            String string3 = string2 + string;
            Ref ref = (Ref)map.get(string3);
            if (ref == null) continue;
            return ref;
        }
        return null;
    }
}

