/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import org.eclipse.jgit.errors.IllegalTodoFileModification;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.RebaseTodoLine$Action;

public class RebaseTodoLine {
    RebaseTodoLine$Action action;
    final AbbreviatedObjectId commit;
    String shortMessage;
    String comment;

    public RebaseTodoLine(String string) {
        this.action = RebaseTodoLine$Action.COMMENT;
        this.setComment(string);
        this.commit = null;
        this.shortMessage = null;
    }

    public RebaseTodoLine(RebaseTodoLine$Action rebaseTodoLine$Action, AbbreviatedObjectId abbreviatedObjectId, String string) {
        this.action = rebaseTodoLine$Action;
        this.commit = abbreviatedObjectId;
        this.shortMessage = string;
        this.comment = null;
    }

    public RebaseTodoLine$Action getAction() {
        return this.action;
    }

    public void setAction(RebaseTodoLine$Action rebaseTodoLine$Action) {
        if (!RebaseTodoLine$Action.COMMENT.equals((Object)this.action) && RebaseTodoLine$Action.COMMENT.equals((Object)rebaseTodoLine$Action)) {
            if (this.comment == null) {
                this.comment = "# " + RebaseTodoLine$Action.access$000(this.action) + " " + (this.commit == null ? "null" : this.commit.name()) + " " + (this.shortMessage == null ? "null" : this.shortMessage);
            }
        } else if (RebaseTodoLine$Action.COMMENT.equals((Object)this.action) && !RebaseTodoLine$Action.COMMENT.equals((Object)rebaseTodoLine$Action) && this.commit == null) {
            throw new IllegalTodoFileModification(MessageFormat.format(JGitText.get().cannotChangeActionOnComment, new Object[]{this.action, rebaseTodoLine$Action}));
        }
        this.action = rebaseTodoLine$Action;
    }

    public void setComment(String string) {
        if (string == null) {
            this.comment = null;
            return;
        }
        if (string.contains("\n") || string.contains("\r")) {
            throw RebaseTodoLine.createInvalidCommentException(string);
        }
        if (string.trim().length() == 0 || string.startsWith("#")) {
            this.comment = string;
            return;
        }
        throw RebaseTodoLine.createInvalidCommentException(string);
    }

    private static IllegalArgumentException createInvalidCommentException(String string) {
        return new IllegalArgumentException(MessageFormat.format(JGitText.get().argumentIsNotAValidCommentString, string));
    }

    public AbbreviatedObjectId getCommit() {
        return this.commit;
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    public void setShortMessage(String string) {
        this.shortMessage = string;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "Step[" + (Object)((Object)this.action) + ", " + (this.commit == null ? "null" : this.commit) + ", " + (this.shortMessage == null ? "null" : this.shortMessage) + ", " + (this.comment == null ? "" : this.comment) + "]";
    }
}

