/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.RebaseTodoLine$Action;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class RebaseTodoFile {
    private Repository repo;

    public RebaseTodoFile(Repository repository) {
        this.repo = repository;
    }

    public List readRebaseTodo(String string, boolean bl2) {
        byte[] byArray = IO.readFully(new File(this.repo.getDirectory(), string));
        int n2 = 0;
        int n3 = 0;
        LinkedList<RebaseTodoLine> linkedList = new LinkedList<RebaseTodoLine>();
        while (n2 < byArray.length) {
            n3 = n2;
            n2 = RawParseUtils.nextLF(byArray, n2);
            int n4 = n3;
            int n5 = n2 - 2;
            if (n5 >= 0 && byArray[n5] == 13) {
                --n5;
            }
            if (byArray[n3] == 35) {
                if (!bl2) continue;
                RebaseTodoFile.parseComments(byArray, n3, linkedList, n5);
                continue;
            }
            if ((n3 = RebaseTodoFile.nextParsableToken(byArray, n3, n5)) == -1) {
                if (!bl2) continue;
                linkedList.add(new RebaseTodoLine(RawParseUtils.decode(byArray, n4, 1 + n5)));
                continue;
            }
            RebaseTodoLine rebaseTodoLine = RebaseTodoFile.parseLine(byArray, n3, n5);
            if (rebaseTodoLine == null) continue;
            linkedList.add(rebaseTodoLine);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseComments(byte[] byArray, int n2, List list, int n3) {
        RebaseTodoLine rebaseTodoLine = null;
        String string = RawParseUtils.decode(byArray, n2, n3 + 1);
        try {
            int n4 = n2 + 1;
            n4 = RebaseTodoFile.nextParsableToken(byArray, n4, n3);
            if (n4 != -1 && (rebaseTodoLine = RebaseTodoFile.parseLine(byArray, n4, n3)) != null) {
                rebaseTodoLine.setAction(RebaseTodoLine$Action.COMMENT);
                rebaseTodoLine.setComment(string);
            }
        }
        catch (Exception exception) {
            rebaseTodoLine = null;
        }
        finally {
            if (rebaseTodoLine == null) {
                rebaseTodoLine = new RebaseTodoLine(string);
            }
            list.add(rebaseTodoLine);
        }
    }

    private static int nextParsableToken(byte[] byArray, int n2, int n3) {
        while (n2 <= n3 && (byArray[n2] == 32 || byArray[n2] == 9 || byArray[n2] == 13)) {
            ++n2;
        }
        if (n2 > n3) {
            return -1;
        }
        return n2;
    }

    private static RebaseTodoLine parseLine(byte[] byArray, int n2, int n3) {
        int n4;
        RebaseTodoLine$Action rebaseTodoLine$Action = null;
        AbbreviatedObjectId abbreviatedObjectId = null;
        int n5 = RawParseUtils.next(byArray, n2, ' ');
        block5: for (n4 = 0; n4 < 3 && n5 <= n3; ++n4) {
            switch (n4) {
                case 0: {
                    String string = new String(byArray, n2, n5 - n2 - 1, StandardCharsets.UTF_8);
                    n2 = n5;
                    rebaseTodoLine$Action = RebaseTodoLine$Action.parse(string);
                    if (rebaseTodoLine$Action != null) continue block5;
                    return null;
                }
                case 1: {
                    n5 = RawParseUtils.next(byArray, n2, ' ');
                    String string = n5 > n3 + 1 ? new String(byArray, n2, n3 - n2 + 1, StandardCharsets.UTF_8) : new String(byArray, n2, n5 - n2 - 1, StandardCharsets.UTF_8);
                    n2 = n5;
                    abbreviatedObjectId = AbbreviatedObjectId.fromString(string);
                    continue block5;
                }
                case 2: {
                    return new RebaseTodoLine(rebaseTodoLine$Action, abbreviatedObjectId, RawParseUtils.decode(byArray, n2, 1 + n3));
                }
            }
        }
        if (n4 == 2) {
            return new RebaseTodoLine(rebaseTodoLine$Action, abbreviatedObjectId, "");
        }
        return null;
    }

    public void writeRebaseTodoFile(String string, List list, boolean bl2) {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.repo.getDirectoryChild(string), bl2));){
            StringBuilder stringBuilder = new StringBuilder();
            for (RebaseTodoLine rebaseTodoLine : list) {
                stringBuilder.setLength(0);
                if (RebaseTodoLine$Action.COMMENT.equals((Object)rebaseTodoLine.action)) {
                    stringBuilder.append(rebaseTodoLine.getComment());
                } else {
                    stringBuilder.append(rebaseTodoLine.getAction().toToken());
                    stringBuilder.append(" ");
                    stringBuilder.append(rebaseTodoLine.getCommit().name());
                    stringBuilder.append(" ");
                    stringBuilder.append(rebaseTodoLine.getShortMessage().trim());
                }
                stringBuilder.append('\n');
                ((OutputStream)bufferedOutputStream).write(Constants.encode(stringBuilder.toString()));
            }
        }
    }
}

