/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.time.ProposedTimestamp;

public class PersonIdent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String emailAddress;
    private final long when;
    private final int tzOffset;

    public static TimeZone getTimeZone(int n2) {
        StringBuilder stringBuilder = new StringBuilder(8);
        stringBuilder.append("GMT");
        PersonIdent.appendTimezone(stringBuilder, n2);
        return TimeZone.getTimeZone(stringBuilder.toString());
    }

    public static void appendTimezone(StringBuilder stringBuilder, int n2) {
        char c2;
        if (n2 < 0) {
            c2 = '-';
            n2 = -n2;
        } else {
            c2 = '+';
        }
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        stringBuilder.append(c2);
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
    }

    public static void appendSanitized(StringBuilder stringBuilder, String string) {
        int n2;
        int n3;
        for (n3 = 0; n3 < string.length() && string.charAt(n3) <= ' '; ++n3) {
        }
        for (n2 = string.length(); n2 > n3 && string.charAt(n2 - 1) <= ' '; --n2) {
        }
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            switch (c2) {
                case '\n': 
                case '<': 
                case '>': {
                    break;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
            ++n3;
        }
    }

    public PersonIdent(Repository repository) {
        this((UserConfig)repository.getConfig().get(UserConfig.KEY));
    }

    public PersonIdent(PersonIdent personIdent) {
        this(personIdent.getName(), personIdent.getEmailAddress());
    }

    public PersonIdent(String string, String string2) {
        this(string, string2, SystemReader.getInstance().getCurrentTime());
    }

    public PersonIdent(String string, String string2, ProposedTimestamp proposedTimestamp) {
        this(string, string2, proposedTimestamp.millis());
    }

    public PersonIdent(PersonIdent personIdent, Date date, TimeZone timeZone) {
        this(personIdent.getName(), personIdent.getEmailAddress(), date, timeZone);
    }

    public PersonIdent(PersonIdent personIdent, Date date) {
        this(personIdent.getName(), personIdent.getEmailAddress(), date.getTime(), personIdent.tzOffset);
    }

    public PersonIdent(String string, String string2, Date date, TimeZone timeZone) {
        this(string, string2, date.getTime(), timeZone.getOffset(date.getTime()) / 60000);
    }

    public PersonIdent(PersonIdent personIdent, long l2, int n2) {
        this(personIdent.getName(), personIdent.getEmailAddress(), l2, n2);
    }

    private PersonIdent(String string, String string2, long l2) {
        this(string, string2, l2, SystemReader.getInstance().getTimezone(l2));
    }

    private PersonIdent(UserConfig userConfig) {
        this(userConfig.getCommitterName(), userConfig.getCommitterEmail());
    }

    public PersonIdent(String string, String string2, long l2, int n2) {
        if (string == null) {
            throw new IllegalArgumentException(JGitText.get().personIdentNameNonNull);
        }
        if (string2 == null) {
            throw new IllegalArgumentException(JGitText.get().personIdentEmailNonNull);
        }
        this.name = string;
        this.emailAddress = string2;
        this.when = l2;
        this.tzOffset = n2;
    }

    public String getName() {
        return this.name;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Date getWhen() {
        return new Date(this.when);
    }

    public TimeZone getTimeZone() {
        return PersonIdent.getTimeZone(this.tzOffset);
    }

    public int getTimeZoneOffset() {
        return this.tzOffset;
    }

    public int hashCode() {
        int n2 = this.getEmailAddress().hashCode();
        n2 *= 31;
        return n2 += (int)(this.when / 1000L);
    }

    public boolean equals(Object object) {
        if (object instanceof PersonIdent) {
            PersonIdent personIdent = (PersonIdent)object;
            return this.getName().equals(personIdent.getName()) && this.getEmailAddress().equals(personIdent.getEmailAddress()) && this.when / 1000L == personIdent.when / 1000L;
        }
        return false;
    }

    public String toExternalString() {
        StringBuilder stringBuilder = new StringBuilder();
        PersonIdent.appendSanitized(stringBuilder, this.getName());
        stringBuilder.append(" <");
        PersonIdent.appendSanitized(stringBuilder, this.getEmailAddress());
        stringBuilder.append("> ");
        stringBuilder.append(this.when / 1000L);
        stringBuilder.append(' ');
        PersonIdent.appendTimezone(stringBuilder, this.tzOffset);
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy Z", Locale.US);
        simpleDateFormat.setTimeZone(this.getTimeZone());
        stringBuilder.append("PersonIdent[");
        stringBuilder.append(this.getName());
        stringBuilder.append(", ");
        stringBuilder.append(this.getEmailAddress());
        stringBuilder.append(", ");
        stringBuilder.append(simpleDateFormat.format(this.when));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

