/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.revwalk.BitmappedObjectReachabilityChecker;
import org.eclipse.jgit.internal.revwalk.BitmappedReachabilityChecker;
import org.eclipse.jgit.internal.revwalk.PedestrianObjectReachabilityChecker;
import org.eclipse.jgit.internal.revwalk.PedestrianReachabilityChecker;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectLoaderQueue;
import org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader$1;
import org.eclipse.jgit.lib.ObjectReader$2;
import org.eclipse.jgit.revwalk.ObjectReachabilityChecker;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.ReachabilityChecker;
import org.eclipse.jgit.revwalk.RevWalk;

public abstract class ObjectReader
implements AutoCloseable {
    public static final int OBJ_ANY = -1;
    protected int streamFileThreshold;

    public abstract ObjectReader newReader();

    public AbbreviatedObjectId abbreviate(AnyObjectId anyObjectId) {
        return this.abbreviate(anyObjectId, 7);
    }

    public AbbreviatedObjectId abbreviate(AnyObjectId anyObjectId, int n2) {
        if (n2 == 40) {
            return AbbreviatedObjectId.fromObjectId(anyObjectId);
        }
        AbbreviatedObjectId abbreviatedObjectId = anyObjectId.abbreviate(n2);
        Collection<ObjectId> collection = this.resolve(abbreviatedObjectId);
        while (1 < collection.size() && n2 < 40) {
            abbreviatedObjectId = anyObjectId.abbreviate(++n2);
            ArrayList<ObjectId> arrayList = new ArrayList<ObjectId>(8);
            for (ObjectId objectId : collection) {
                if (abbreviatedObjectId.prefixCompare(objectId) != 0) continue;
                arrayList.add(objectId);
            }
            if (1 < arrayList.size()) {
                collection = arrayList;
                continue;
            }
            collection = this.resolve(abbreviatedObjectId);
        }
        return abbreviatedObjectId;
    }

    public abstract Collection resolve(AbbreviatedObjectId var1);

    public boolean has(AnyObjectId anyObjectId) {
        return this.has(anyObjectId, -1);
    }

    public boolean has(AnyObjectId anyObjectId, int n2) {
        try {
            this.open(anyObjectId, n2);
            return true;
        }
        catch (MissingObjectException missingObjectException) {
            return false;
        }
    }

    public ObjectLoader open(AnyObjectId anyObjectId) {
        return this.open(anyObjectId, -1);
    }

    public abstract ObjectLoader open(AnyObjectId var1, int var2);

    public abstract Set getShallowCommits();

    public AsyncObjectLoaderQueue open(Iterable iterable, boolean bl2) {
        Iterator iterator = iterable.iterator();
        return new ObjectReader$1(this, iterator);
    }

    public long getObjectSize(AnyObjectId anyObjectId, int n2) {
        return this.open(anyObjectId, n2).getSize();
    }

    public AsyncObjectSizeQueue getObjectSize(Iterable iterable, boolean bl2) {
        Iterator iterator = iterable.iterator();
        return new ObjectReader$2(this, iterator);
    }

    public void setAvoidUnreachableObjects(boolean bl2) {
    }

    public BitmapIndex getBitmapIndex() {
        return null;
    }

    @NonNull
    public ReachabilityChecker createReachabilityChecker(RevWalk revWalk) {
        if (this.getBitmapIndex() != null) {
            return new BitmappedReachabilityChecker(revWalk);
        }
        return new PedestrianReachabilityChecker(true, revWalk);
    }

    @NonNull
    public ObjectReachabilityChecker createObjectReachabilityChecker(ObjectWalk objectWalk) {
        if (this.getBitmapIndex() != null) {
            return new BitmappedObjectReachabilityChecker(objectWalk);
        }
        return new PedestrianObjectReachabilityChecker(objectWalk);
    }

    @Nullable
    public ObjectInserter getCreatedFromInserter() {
        return null;
    }

    @Override
    public abstract void close();

    public void setStreamFileThreshold(int n2) {
        this.streamFileThreshold = n2;
    }

    public int getStreamFileThreshold() {
        return this.streamFileThreshold;
    }
}

