/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.EOFException;
import java.io.OutputStream;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.LargeObjectException$ExceedsByteArrayLimit;
import org.eclipse.jgit.errors.LargeObjectException$ExceedsLimit;
import org.eclipse.jgit.errors.LargeObjectException$OutOfMemory;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.util.IO;

public abstract class ObjectLoader {
    public abstract int getType();

    public abstract long getSize();

    public boolean isLarge() {
        try {
            this.getCachedBytes();
            return false;
        }
        catch (LargeObjectException largeObjectException) {
            return true;
        }
    }

    public final byte[] getBytes() {
        return ObjectLoader.cloneArray(this.getCachedBytes());
    }

    public final byte[] getBytes(int n2) {
        byte[] byArray = this.getCachedBytes(n2);
        try {
            return ObjectLoader.cloneArray(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new LargeObjectException$OutOfMemory(outOfMemoryError);
        }
    }

    public abstract byte[] getCachedBytes();

    public byte[] getCachedBytes(int n2) {
        if (!this.isLarge()) {
            return this.getCachedBytes();
        }
        try (ObjectStream objectStream = this.openStream();){
            byte[] byArray;
            long l2 = objectStream.getSize();
            if ((long)n2 < l2) {
                throw new LargeObjectException$ExceedsLimit(n2, l2);
            }
            if (Integer.MAX_VALUE < l2) {
                throw new LargeObjectException$ExceedsByteArrayLimit();
            }
            try {
                byArray = new byte[(int)l2];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new LargeObjectException$OutOfMemory(outOfMemoryError);
            }
            IO.readFully(objectStream, byArray, 0, byArray.length);
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    public abstract ObjectStream openStream();

    public void copyTo(OutputStream outputStream) {
        block16: {
            if (this.isLarge()) {
                try (ObjectStream objectStream = this.openStream();){
                    int n2;
                    long l2 = objectStream.getSize();
                    byte[] byArray = new byte[8192];
                    for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
                        n2 = objectStream.read(byArray);
                        if (n2 < 0) {
                            throw new EOFException();
                        }
                        outputStream.write(byArray, 0, n2);
                    }
                    if (0 <= objectStream.read()) {
                        throw new EOFException();
                    }
                    break block16;
                }
            }
            outputStream.write(this.getCachedBytes());
        }
    }

    private static byte[] cloneArray(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }
}

