/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.InputStream;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.util.sha1.SHA1;

public abstract class ObjectInserter
implements AutoCloseable {
    private final SHA1 hasher = SHA1.newInstance();
    private byte[] tempBuffer;

    protected ObjectInserter() {
    }

    protected byte[] buffer() {
        byte[] byArray = this.tempBuffer;
        if (byArray == null) {
            this.tempBuffer = byArray = new byte[8192];
        }
        return byArray;
    }

    protected SHA1 digest() {
        return this.hasher.reset();
    }

    public ObjectId idFor(int n2, byte[] byArray) {
        return this.idFor(n2, byArray, 0, byArray.length);
    }

    public ObjectId idFor(int n2, byte[] byArray, int n3, int n4) {
        SHA1 sHA1 = SHA1.newInstance();
        sHA1.update(Constants.encodedTypeString(n2));
        sHA1.update((byte)32);
        sHA1.update(Constants.encodeASCII(n4));
        sHA1.update((byte)0);
        sHA1.update(byArray, n3, n4);
        return sHA1.toObjectId();
    }

    public ObjectId idFor(int n2, long l2, InputStream inputStream) {
        SHA1 sHA1 = SHA1.newInstance();
        sHA1.update(Constants.encodedTypeString(n2));
        sHA1.update((byte)32);
        sHA1.update(Constants.encodeASCII(l2));
        sHA1.update((byte)0);
        byte[] byArray = this.buffer();
        while (l2 > 0L) {
            int n3 = inputStream.read(byArray, 0, (int)Math.min(l2, (long)byArray.length));
            if (n3 < 0) {
                throw new EOFException(JGitText.get().unexpectedEndOfInput);
            }
            sHA1.update(byArray, 0, n3);
            l2 -= (long)n3;
        }
        return sHA1.toObjectId();
    }

    public ObjectId idFor(TreeFormatter treeFormatter) {
        return treeFormatter.computeId(this);
    }

    public final ObjectId insert(TreeFormatter treeFormatter) {
        return treeFormatter.insertTo(this);
    }

    public final ObjectId insert(CommitBuilder commitBuilder) {
        return this.insert(1, commitBuilder.build());
    }

    public final ObjectId insert(TagBuilder tagBuilder) {
        return this.insert(4, tagBuilder.build());
    }

    public ObjectId insert(int n2, byte[] byArray) {
        return this.insert(n2, byArray, 0, byArray.length);
    }

    public ObjectId insert(int n2, byte[] byArray, int n3, int n4) {
        return this.insert(n2, n4, new ByteArrayInputStream(byArray, n3, n4));
    }

    public abstract ObjectId insert(int var1, long var2, InputStream var4);

    public abstract PackParser newPackParser(InputStream var1);

    public abstract ObjectReader newReader();

    public abstract void flush();

    @Override
    public abstract void close();
}

