/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.Iterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectIdSubclassMap$1;

public class ObjectIdSubclassMap
implements Iterable,
ObjectIdSet {
    private static final int INITIAL_TABLE_SIZE = 2048;
    int size;
    private int grow;
    private int mask;
    ObjectId[] table;

    public ObjectIdSubclassMap() {
        this.initTable(2048);
    }

    public void clear() {
        this.size = 0;
        this.initTable(2048);
    }

    public ObjectId get(AnyObjectId anyObjectId) {
        ObjectId objectId;
        int n2 = this.mask;
        int n3 = anyObjectId.w1 & n2;
        ObjectId[] objectIdArray = this.table;
        while ((objectId = objectIdArray[n3]) != null) {
            if (AnyObjectId.isEqual(objectId, anyObjectId)) {
                return objectId;
            }
            n3 = n3 + 1 & n2;
        }
        return null;
    }

    @Override
    public boolean contains(AnyObjectId anyObjectId) {
        return this.get(anyObjectId) != null;
    }

    public void add(ObjectId objectId) {
        if (++this.size == this.grow) {
            this.grow();
        }
        this.insert(objectId);
    }

    public ObjectId addIfAbsent(ObjectId objectId) {
        ObjectId objectId2;
        int n2 = this.mask;
        int n3 = objectId.w1 & n2;
        ObjectId[] objectIdArray = this.table;
        while ((objectId2 = objectIdArray[n3]) != null) {
            if (AnyObjectId.isEqual(objectId2, objectId)) {
                return objectId2;
            }
            n3 = n3 + 1 & n2;
        }
        if (++this.size == this.grow) {
            this.grow();
            this.insert(objectId);
        } else {
            objectIdArray[n3] = objectId;
        }
        return objectId;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Iterator iterator() {
        return new ObjectIdSubclassMap$1(this);
    }

    private void insert(ObjectId objectId) {
        int n2 = this.mask;
        int n3 = objectId.w1 & n2;
        ObjectId[] objectIdArray = this.table;
        while (objectIdArray[n3] != null) {
            n3 = n3 + 1 & n2;
        }
        objectIdArray[n3] = objectId;
    }

    private void grow() {
        ObjectId[] objectIdArray = this.table;
        int n2 = this.table.length;
        this.initTable(n2 << 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            ObjectId objectId = objectIdArray[i2];
            if (objectId == null) continue;
            this.insert(objectId);
        }
    }

    private void initTable(int n2) {
        this.grow = n2 >> 1;
        this.mask = n2 - 1;
        this.table = this.createArray(n2);
    }

    private final ObjectId[] createArray(int n2) {
        return new ObjectId[n2];
    }
}

