/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.IO;

public class ObjectIdSerializer {
    private static final byte NULL_MARKER = 0;
    private static final byte NON_NULL_MARKER = 1;

    public static void write(OutputStream outputStream, @Nullable AnyObjectId anyObjectId) {
        if (anyObjectId != null) {
            outputStream.write(1);
            ObjectIdSerializer.writeWithoutMarker(outputStream, anyObjectId);
        } else {
            outputStream.write(0);
        }
    }

    public static void writeWithoutMarker(OutputStream outputStream, @NonNull AnyObjectId anyObjectId) {
        anyObjectId.copyRawTo(outputStream);
    }

    @Nullable
    public static ObjectId read(InputStream inputStream) {
        byte by = (byte)inputStream.read();
        switch (by) {
            case 0: {
                return null;
            }
            case 1: {
                return ObjectIdSerializer.readWithoutMarker(inputStream);
            }
        }
        throw new IOException("Invalid flag before ObjectId: " + by);
    }

    @NonNull
    public static ObjectId readWithoutMarker(InputStream inputStream) {
        byte[] byArray = new byte[20];
        IO.readFully(inputStream, byArray, 0, 20);
        return ObjectId.fromRaw(byArray);
    }

    private ObjectIdSerializer() {
    }
}

