/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;

public abstract class ObjectIdRef
implements Ref {
    private final String name;
    private final Ref$Storage storage;
    private final ObjectId objectId;
    private final long updateIndex;

    protected ObjectIdRef(@NonNull Ref$Storage ref$Storage, @NonNull String string, @Nullable ObjectId objectId, long l2) {
        this.name = string;
        this.storage = ref$Storage;
        this.objectId = objectId;
        this.updateIndex = l2;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSymbolic() {
        return false;
    }

    @Override
    @NonNull
    public Ref getLeaf() {
        return this;
    }

    @Override
    @NonNull
    public Ref getTarget() {
        return this;
    }

    @Override
    @Nullable
    public ObjectId getObjectId() {
        return this.objectId;
    }

    @Override
    @NonNull
    public Ref$Storage getStorage() {
        return this.storage;
    }

    @Override
    public long getUpdateIndex() {
        if (this.updateIndex == -1L) {
            throw new UnsupportedOperationException();
        }
        return this.updateIndex;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ref[");
        stringBuilder.append(this.getName());
        stringBuilder.append('=');
        stringBuilder.append(ObjectId.toString(this.getObjectId()));
        stringBuilder.append('(');
        stringBuilder.append(this.updateIndex);
        stringBuilder.append(")]");
        return stringBuilder.toString();
    }
}

