/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap$1;
import org.eclipse.jgit.lib.ObjectIdOwnerMap$Entry;
import org.eclipse.jgit.lib.ObjectIdSet;

public class ObjectIdOwnerMap
implements Iterable,
ObjectIdSet {
    private static final int INITIAL_DIRECTORY = 1024;
    private static final int SEGMENT_BITS = 11;
    private static final int SEGMENT_SHIFT = 21;
    ObjectIdOwnerMap$Entry[][] directory;
    int size;
    private int grow = ObjectIdOwnerMap.computeGrowAt(this.bits);
    int bits = 0;
    private int mask = 0;

    public ObjectIdOwnerMap() {
        this.directory = new ObjectIdOwnerMap$Entry[1024][];
        this.directory[0] = this.newSegment();
    }

    public void clear() {
        this.size = 0;
        for (Object[] objectArray : this.directory) {
            if (objectArray == null) break;
            Arrays.fill(objectArray, null);
        }
    }

    public ObjectIdOwnerMap$Entry get(AnyObjectId anyObjectId) {
        if (anyObjectId == null) {
            return null;
        }
        int n2 = anyObjectId.w1;
        ObjectIdOwnerMap$Entry objectIdOwnerMap$Entry = this.directory[n2 & this.mask][n2 >>> 21];
        while (objectIdOwnerMap$Entry != null) {
            if (ObjectIdOwnerMap.equals(objectIdOwnerMap$Entry, anyObjectId)) {
                return objectIdOwnerMap$Entry;
            }
            objectIdOwnerMap$Entry = objectIdOwnerMap$Entry.next;
        }
        return null;
    }

    @Override
    public boolean contains(AnyObjectId anyObjectId) {
        return this.get(anyObjectId) != null;
    }

    public void add(ObjectIdOwnerMap$Entry objectIdOwnerMap$Entry) {
        if (++this.size == this.grow) {
            this.grow();
        }
        int n2 = objectIdOwnerMap$Entry.w1;
        ObjectIdOwnerMap$Entry[] objectIdOwnerMap$EntryArray = this.directory[n2 & this.mask];
        objectIdOwnerMap$Entry.next = objectIdOwnerMap$EntryArray[n2 >>>= 21];
        objectIdOwnerMap$EntryArray[n2] = objectIdOwnerMap$Entry;
    }

    public ObjectIdOwnerMap$Entry addIfAbsent(ObjectIdOwnerMap$Entry objectIdOwnerMap$Entry) {
        int n2 = objectIdOwnerMap$Entry.w1;
        ObjectIdOwnerMap$Entry[] objectIdOwnerMap$EntryArray = this.directory[n2 & this.mask];
        ObjectIdOwnerMap$Entry objectIdOwnerMap$Entry2 = objectIdOwnerMap$EntryArray[n2 >>>= 21];
        while (objectIdOwnerMap$Entry2 != null) {
            if (ObjectIdOwnerMap.equals(objectIdOwnerMap$Entry2, objectIdOwnerMap$Entry)) {
                return objectIdOwnerMap$Entry2;
            }
            objectIdOwnerMap$Entry2 = objectIdOwnerMap$Entry2.next;
        }
        objectIdOwnerMap$Entry.next = objectIdOwnerMap$EntryArray[n2];
        objectIdOwnerMap$EntryArray[n2] = objectIdOwnerMap$Entry;
        if (++this.size == this.grow) {
            this.grow();
        }
        return objectIdOwnerMap$Entry;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Iterator iterator() {
        return new ObjectIdOwnerMap$1(this);
    }

    private void grow() {
        int n2 = 1 << this.bits;
        int n3 = 1 << this.bits;
        ++this.bits;
        this.mask = (1 << this.bits) - 1;
        this.grow = ObjectIdOwnerMap.computeGrowAt(this.bits);
        int n4 = 1 << this.bits;
        if (this.directory.length < n4) {
            ObjectIdOwnerMap$Entry[][] objectIdOwnerMap$EntryArray = new ObjectIdOwnerMap$Entry[n4 << 1][];
            System.arraycopy(this.directory, 0, objectIdOwnerMap$EntryArray, 0, n2);
            this.directory = objectIdOwnerMap$EntryArray;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ObjectIdOwnerMap$Entry[] objectIdOwnerMap$EntryArray = this.directory[i2];
            ObjectIdOwnerMap$Entry[] objectIdOwnerMap$EntryArray2 = this.newSegment();
            for (int i3 = 0; i3 < objectIdOwnerMap$EntryArray.length; ++i3) {
                ObjectIdOwnerMap$Entry objectIdOwnerMap$Entry = null;
                ObjectIdOwnerMap$Entry objectIdOwnerMap$Entry2 = null;
                ObjectIdOwnerMap$Entry objectIdOwnerMap$Entry3 = objectIdOwnerMap$EntryArray[i3];
                while (objectIdOwnerMap$Entry3 != null) {
                    ObjectIdOwnerMap$Entry objectIdOwnerMap$Entry4 = objectIdOwnerMap$Entry3.next;
                    if ((objectIdOwnerMap$Entry3.w1 & n3) == 0) {
                        objectIdOwnerMap$Entry3.next = objectIdOwnerMap$Entry;
                        objectIdOwnerMap$Entry = objectIdOwnerMap$Entry3;
                    } else {
                        objectIdOwnerMap$Entry3.next = objectIdOwnerMap$Entry2;
                        objectIdOwnerMap$Entry2 = objectIdOwnerMap$Entry3;
                    }
                    objectIdOwnerMap$Entry3 = objectIdOwnerMap$Entry4;
                }
                objectIdOwnerMap$EntryArray[i3] = objectIdOwnerMap$Entry;
                objectIdOwnerMap$EntryArray2[i3] = objectIdOwnerMap$Entry2;
            }
            this.directory[n2 + i2] = objectIdOwnerMap$EntryArray2;
        }
    }

    private final ObjectIdOwnerMap$Entry[] newSegment() {
        return new ObjectIdOwnerMap$Entry[2048];
    }

    private static final int computeGrowAt(int n2) {
        return 1 << n2 + 11;
    }

    private static final boolean equals(AnyObjectId anyObjectId, AnyObjectId anyObjectId2) {
        return anyObjectId.w2 == anyObjectId2.w2 && anyObjectId.w3 == anyObjectId2.w3 && anyObjectId.w4 == anyObjectId2.w4 && anyObjectId.w5 == anyObjectId2.w5 && anyObjectId.w1 == anyObjectId2.w1;
    }
}

