/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

public class ObjectId
extends AnyObjectId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectId ZEROID = new ObjectId(0, 0, 0, 0, 0);
    private static final String ZEROID_STR = ZEROID.name();

    public static final ObjectId zeroId() {
        return ZEROID;
    }

    public static final boolean isId(@Nullable String string) {
        if (string == null) {
            return false;
        }
        if (string.length() != 40) {
            return false;
        }
        try {
            for (int i2 = 0; i2 < 40; ++i2) {
                RawParseUtils.parseHexInt4((byte)string.charAt(i2));
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static final String toString(ObjectId objectId) {
        return objectId != null ? objectId.name() : ZEROID_STR;
    }

    public static boolean equals(byte[] byArray, int n2, byte[] byArray2, int n3) {
        return byArray[n2] == byArray2[n3] && byArray[n2 + 1] == byArray2[n3 + 1] && byArray[n2 + 2] == byArray2[n3 + 2] && byArray[n2 + 3] == byArray2[n3 + 3] && byArray[n2 + 4] == byArray2[n3 + 4] && byArray[n2 + 5] == byArray2[n3 + 5] && byArray[n2 + 6] == byArray2[n3 + 6] && byArray[n2 + 7] == byArray2[n3 + 7] && byArray[n2 + 8] == byArray2[n3 + 8] && byArray[n2 + 9] == byArray2[n3 + 9] && byArray[n2 + 10] == byArray2[n3 + 10] && byArray[n2 + 11] == byArray2[n3 + 11] && byArray[n2 + 12] == byArray2[n3 + 12] && byArray[n2 + 13] == byArray2[n3 + 13] && byArray[n2 + 14] == byArray2[n3 + 14] && byArray[n2 + 15] == byArray2[n3 + 15] && byArray[n2 + 16] == byArray2[n3 + 16] && byArray[n2 + 17] == byArray2[n3 + 17] && byArray[n2 + 18] == byArray2[n3 + 18] && byArray[n2 + 19] == byArray2[n3 + 19];
    }

    public static final ObjectId fromRaw(byte[] byArray) {
        return ObjectId.fromRaw(byArray, 0);
    }

    public static final ObjectId fromRaw(byte[] byArray, int n2) {
        int n3 = NB.decodeInt32(byArray, n2);
        int n4 = NB.decodeInt32(byArray, n2 + 4);
        int n5 = NB.decodeInt32(byArray, n2 + 8);
        int n6 = NB.decodeInt32(byArray, n2 + 12);
        int n7 = NB.decodeInt32(byArray, n2 + 16);
        return new ObjectId(n3, n4, n5, n6, n7);
    }

    public static final ObjectId fromRaw(int[] nArray) {
        return ObjectId.fromRaw(nArray, 0);
    }

    public static final ObjectId fromRaw(int[] nArray, int n2) {
        return new ObjectId(nArray[n2], nArray[n2 + 1], nArray[n2 + 2], nArray[n2 + 3], nArray[n2 + 4]);
    }

    public static final ObjectId fromString(byte[] byArray, int n2) {
        return ObjectId.fromHexString(byArray, n2);
    }

    public static ObjectId fromString(String string) {
        if (string.length() != 40) {
            throw new InvalidObjectIdException(string);
        }
        return ObjectId.fromHexString(Constants.encodeASCII(string), 0);
    }

    public static ObjectId parse(String string) {
        try {
            return ObjectId.fromString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Invalid SHA '" + string + "'.");
        }
    }

    private static final ObjectId fromHexString(byte[] byArray, int n2) {
        try {
            int n3 = RawParseUtils.parseHexInt32(byArray, n2);
            int n4 = RawParseUtils.parseHexInt32(byArray, n2 + 8);
            int n5 = RawParseUtils.parseHexInt32(byArray, n2 + 16);
            int n6 = RawParseUtils.parseHexInt32(byArray, n2 + 24);
            int n7 = RawParseUtils.parseHexInt32(byArray, n2 + 32);
            return new ObjectId(n3, n4, n5, n6, n7);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            InvalidObjectIdException invalidObjectIdException = new InvalidObjectIdException(byArray, n2, 40);
            invalidObjectIdException.initCause(arrayIndexOutOfBoundsException);
            throw invalidObjectIdException;
        }
    }

    public ObjectId(int n2, int n3, int n4, int n5, int n6) {
        this.w1 = n2;
        this.w2 = n3;
        this.w3 = n4;
        this.w4 = n5;
        this.w5 = n6;
    }

    protected ObjectId(AnyObjectId anyObjectId) {
        this.w1 = anyObjectId.w1;
        this.w2 = anyObjectId.w2;
        this.w3 = anyObjectId.w3;
        this.w4 = anyObjectId.w4;
        this.w5 = anyObjectId.w5;
    }

    @Override
    public ObjectId toObjectId() {
        return this;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeInt(this.w1);
        objectOutputStream.writeInt(this.w2);
        objectOutputStream.writeInt(this.w3);
        objectOutputStream.writeInt(this.w4);
        objectOutputStream.writeInt(this.w5);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.w1 = objectInputStream.readInt();
        this.w2 = objectInputStream.readInt();
        this.w3 = objectInputStream.readInt();
        this.w4 = objectInputStream.readInt();
        this.w5 = objectInputStream.readInt();
    }
}

