/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;

public abstract class ObjectDatabase {
    protected ObjectDatabase() {
    }

    public boolean exists() {
        return true;
    }

    public void create() {
    }

    public abstract ObjectInserter newInserter();

    public abstract ObjectReader newReader();

    public abstract void close();

    public boolean has(AnyObjectId anyObjectId) {
        try (ObjectReader objectReader = this.newReader();){
            boolean bl2 = objectReader.has(anyObjectId);
            return bl2;
        }
    }

    public ObjectLoader open(AnyObjectId anyObjectId) {
        return this.open(anyObjectId, -1);
    }

    public ObjectLoader open(AnyObjectId anyObjectId, int n2) {
        try (ObjectReader objectReader = this.newReader();){
            ObjectLoader objectLoader = objectReader.open(anyObjectId, n2);
            return objectLoader;
        }
    }

    public ObjectDatabase newCachedDatabase() {
        return this;
    }
}

