/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BlobObjectChecker;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.GitmoduleEntry;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectChecker$ErrorType;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectInserter$Formatter;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.Paths;
import org.eclipse.jgit.util.RawParseUtils;

public class ObjectChecker {
    public static final byte[] tree = Constants.encodeASCII("tree ");
    public static final byte[] parent = Constants.encodeASCII("parent ");
    public static final byte[] author = Constants.encodeASCII("author ");
    public static final byte[] committer = Constants.encodeASCII("committer ");
    public static final byte[] encoding = Constants.encodeASCII("encoding ");
    public static final byte[] object = Constants.encodeASCII("object ");
    public static final byte[] type = Constants.encodeASCII("type ");
    public static final byte[] tag = Constants.encodeASCII("tag ");
    public static final byte[] tagger = Constants.encodeASCII("tagger ");
    private static final byte[] dotGitmodules = Constants.encodeASCII(".gitmodules");
    private final MutableObjectId tempId = new MutableObjectId();
    private final MutableInteger bufPtr = new MutableInteger();
    private EnumSet errors = EnumSet.allOf(ObjectChecker$ErrorType.class);
    private ObjectIdSet skipList;
    private boolean allowInvalidPersonIdent;
    private boolean windows;
    private boolean macosx;
    private final List gitsubmodules = new ArrayList();

    public ObjectChecker setSkipList(@Nullable ObjectIdSet objectIdSet) {
        this.skipList = objectIdSet;
        return this;
    }

    public ObjectChecker setIgnore(@Nullable Set set) {
        this.errors = EnumSet.allOf(ObjectChecker$ErrorType.class);
        if (set != null) {
            this.errors.removeAll(set);
        }
        return this;
    }

    public ObjectChecker setIgnore(ObjectChecker$ErrorType objectChecker$ErrorType, boolean bl2) {
        if (bl2) {
            this.errors.remove((Object)objectChecker$ErrorType);
        } else {
            this.errors.add(objectChecker$ErrorType);
        }
        return this;
    }

    public ObjectChecker setAllowLeadingZeroFileMode(boolean bl2) {
        return this.setIgnore(ObjectChecker$ErrorType.ZERO_PADDED_FILEMODE, bl2);
    }

    public ObjectChecker setAllowInvalidPersonIdent(boolean bl2) {
        this.allowInvalidPersonIdent = bl2;
        return this;
    }

    public ObjectChecker setSafeForWindows(boolean bl2) {
        this.windows = bl2;
        return this;
    }

    public ObjectChecker setSafeForMacOS(boolean bl2) {
        this.macosx = bl2;
        return this;
    }

    public void check(int n2, byte[] byArray) {
        this.check(this.idFor(n2, byArray), n2, byArray);
    }

    public void check(@Nullable AnyObjectId anyObjectId, int n2, byte[] byArray) {
        switch (n2) {
            case 1: {
                this.checkCommit(anyObjectId, byArray);
                break;
            }
            case 4: {
                this.checkTag(anyObjectId, byArray);
                break;
            }
            case 2: {
                this.checkTree(anyObjectId, byArray);
                break;
            }
            case 3: {
                BlobObjectChecker blobObjectChecker = this.newBlobObjectChecker();
                if (blobObjectChecker == null) {
                    this.checkBlob(byArray);
                    break;
                }
                blobObjectChecker.update(byArray, 0, byArray.length);
                blobObjectChecker.endBlob(anyObjectId);
                break;
            }
            default: {
                this.report(ObjectChecker$ErrorType.UNKNOWN_TYPE, anyObjectId, MessageFormat.format(JGitText.get().corruptObjectInvalidType2, n2));
            }
        }
    }

    private boolean checkId(byte[] byArray) {
        int n2 = this.bufPtr.value;
        try {
            this.tempId.fromString(byArray, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.bufPtr.value = RawParseUtils.nextLF(byArray, n2);
            return false;
        }
        if (byArray[n2 += 40] == 10) {
            this.bufPtr.value = n2 + 1;
            return true;
        }
        this.bufPtr.value = RawParseUtils.nextLF(byArray, n2);
        return false;
    }

    private void checkPersonIdent(byte[] byArray, @Nullable AnyObjectId anyObjectId) {
        if (this.allowInvalidPersonIdent) {
            this.bufPtr.value = RawParseUtils.nextLF(byArray, this.bufPtr.value);
            return;
        }
        int n2 = RawParseUtils.nextLF(byArray, this.bufPtr.value, '<');
        if (n2 == this.bufPtr.value || byArray[n2 - 1] != 60) {
            this.report(ObjectChecker$ErrorType.MISSING_EMAIL, anyObjectId, JGitText.get().corruptObjectMissingEmail);
            this.bufPtr.value = RawParseUtils.nextLF(byArray, this.bufPtr.value);
            return;
        }
        int n3 = RawParseUtils.nextLF(byArray, n2, '>');
        if (n3 == n2 || byArray[n3 - 1] != 62) {
            this.report(ObjectChecker$ErrorType.BAD_EMAIL, anyObjectId, JGitText.get().corruptObjectBadEmail);
            this.bufPtr.value = RawParseUtils.nextLF(byArray, this.bufPtr.value);
            return;
        }
        if (n3 == byArray.length || byArray[n3] != 32) {
            this.report(ObjectChecker$ErrorType.MISSING_SPACE_BEFORE_DATE, anyObjectId, JGitText.get().corruptObjectBadDate);
            this.bufPtr.value = RawParseUtils.nextLF(byArray, this.bufPtr.value);
            return;
        }
        RawParseUtils.parseBase10(byArray, n3 + 1, this.bufPtr);
        if (n3 + 1 == this.bufPtr.value || this.bufPtr.value == byArray.length || byArray[this.bufPtr.value] != 32) {
            this.report(ObjectChecker$ErrorType.BAD_DATE, anyObjectId, JGitText.get().corruptObjectBadDate);
            this.bufPtr.value = RawParseUtils.nextLF(byArray, this.bufPtr.value);
            return;
        }
        int n4 = this.bufPtr.value + 1;
        RawParseUtils.parseBase10(byArray, n4, this.bufPtr);
        if (n4 == this.bufPtr.value) {
            this.report(ObjectChecker$ErrorType.BAD_TIMEZONE, anyObjectId, JGitText.get().corruptObjectBadTimezone);
            this.bufPtr.value = RawParseUtils.nextLF(byArray, this.bufPtr.value);
            return;
        }
        n4 = this.bufPtr.value;
        if (byArray[n4] == 10) {
            this.bufPtr.value = n4 + 1;
        } else {
            this.report(ObjectChecker$ErrorType.BAD_TIMEZONE, anyObjectId, JGitText.get().corruptObjectBadTimezone);
            this.bufPtr.value = RawParseUtils.nextLF(byArray, n4);
        }
    }

    public void checkCommit(byte[] byArray) {
        this.checkCommit(this.idFor(1, byArray), byArray);
    }

    public void checkCommit(@Nullable AnyObjectId anyObjectId, byte[] byArray) {
        this.bufPtr.value = 0;
        if (!this.match(byArray, tree)) {
            this.report(ObjectChecker$ErrorType.MISSING_TREE, anyObjectId, JGitText.get().corruptObjectNotreeHeader);
        } else if (!this.checkId(byArray)) {
            this.report(ObjectChecker$ErrorType.BAD_TREE_SHA1, anyObjectId, JGitText.get().corruptObjectInvalidTree);
        }
        while (this.match(byArray, parent)) {
            if (this.checkId(byArray)) continue;
            this.report(ObjectChecker$ErrorType.BAD_PARENT_SHA1, anyObjectId, JGitText.get().corruptObjectInvalidParent);
        }
        if (this.match(byArray, author)) {
            this.checkPersonIdent(byArray, anyObjectId);
        } else {
            this.report(ObjectChecker$ErrorType.MISSING_AUTHOR, anyObjectId, JGitText.get().corruptObjectNoAuthor);
        }
        if (this.match(byArray, committer)) {
            this.checkPersonIdent(byArray, anyObjectId);
        } else {
            this.report(ObjectChecker$ErrorType.MISSING_COMMITTER, anyObjectId, JGitText.get().corruptObjectNoCommitter);
        }
    }

    public void checkTag(byte[] byArray) {
        this.checkTag(this.idFor(4, byArray), byArray);
    }

    public void checkTag(@Nullable AnyObjectId anyObjectId, byte[] byArray) {
        this.bufPtr.value = 0;
        if (!this.match(byArray, object)) {
            this.report(ObjectChecker$ErrorType.MISSING_OBJECT, anyObjectId, JGitText.get().corruptObjectNoObjectHeader);
        } else if (!this.checkId(byArray)) {
            this.report(ObjectChecker$ErrorType.BAD_OBJECT_SHA1, anyObjectId, JGitText.get().corruptObjectInvalidObject);
        }
        if (!this.match(byArray, type)) {
            this.report(ObjectChecker$ErrorType.MISSING_TYPE_ENTRY, anyObjectId, JGitText.get().corruptObjectNoTypeHeader);
        }
        this.bufPtr.value = RawParseUtils.nextLF(byArray, this.bufPtr.value);
        if (!this.match(byArray, tag)) {
            this.report(ObjectChecker$ErrorType.MISSING_TAG_ENTRY, anyObjectId, JGitText.get().corruptObjectNoTagHeader);
        }
        this.bufPtr.value = RawParseUtils.nextLF(byArray, this.bufPtr.value);
        if (this.match(byArray, tagger)) {
            this.checkPersonIdent(byArray, anyObjectId);
        }
    }

    private static boolean duplicateName(byte[] byArray, int n2, int n3) {
        int n4 = byArray.length;
        int n5 = n3 + 1 + 20;
        while (true) {
            int n6;
            int n7;
            int n8 = 0;
            while (true) {
                if (n5 >= n4) {
                    return false;
                }
                if (32 == (n7 = byArray[n5++])) break;
                n8 <<= 3;
                n8 += n7 - 48;
            }
            n7 = n5;
            do {
                if (n5 != n4) continue;
                return false;
            } while ((n6 = byArray[n5++]) != 0);
            if (n7 + 1 == n5) {
                return false;
            }
            n6 = Paths.compareSameName(byArray, n2, n3, byArray, n7, n5 - 1, n8);
            if (n6 < 0) {
                return false;
            }
            if (n6 == 0) {
                return true;
            }
            n5 += 20;
        }
    }

    public void checkTree(byte[] byArray) {
        this.checkTree(this.idFor(2, byArray), byArray);
    }

    public void checkTree(@Nullable AnyObjectId anyObjectId, byte[] byArray) {
        HashSet<String> hashSet;
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        HashSet<String> hashSet2 = hashSet = this.windows || this.macosx ? new HashSet<String>() : null;
        while (n3 < n2) {
            int n7;
            int n8;
            int n9 = 0;
            while (true) {
                if (n3 == n2) {
                    throw new CorruptObjectException(JGitText.get().corruptObjectTruncatedInMode);
                }
                if (32 == (n8 = byArray[n3++])) break;
                if (n8 < 48 || n8 > 55) {
                    throw new CorruptObjectException(JGitText.get().corruptObjectInvalidModeChar);
                }
                if (n9 == 0 && n8 == 48) {
                    this.report(ObjectChecker$ErrorType.ZERO_PADDED_FILEMODE, anyObjectId, JGitText.get().corruptObjectInvalidModeStartsZero);
                }
                n9 <<= 3;
                n9 += n8 - 48;
            }
            if (FileMode.fromBits(n9).getObjectType() == -1) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode2, n9));
            }
            n8 = n3;
            if ((n3 = this.scanPathSegment(byArray, n3, n2, anyObjectId)) == n2 || byArray[n3] != 0) {
                throw new CorruptObjectException(JGitText.get().corruptObjectTruncatedInName);
            }
            this.checkPathSegment2(byArray, n8, n3, anyObjectId);
            if (hashSet != null) {
                if (!hashSet.add(this.normalize(byArray, n8, n3))) {
                    this.report(ObjectChecker$ErrorType.DUPLICATE_ENTRIES, anyObjectId, JGitText.get().corruptObjectDuplicateEntryNames);
                }
            } else if (ObjectChecker.duplicateName(byArray, n8, n3)) {
                this.report(ObjectChecker$ErrorType.DUPLICATE_ENTRIES, anyObjectId, JGitText.get().corruptObjectDuplicateEntryNames);
            }
            if (n4 != 0 && (n7 = Paths.compare(byArray, n4, n5, n6, byArray, n8, n3, n9)) > 0) {
                this.report(ObjectChecker$ErrorType.TREE_NOT_SORTED, anyObjectId, JGitText.get().corruptObjectIncorrectSorting);
            }
            n4 = n8;
            n5 = n3;
            n6 = n9;
            if ((n3 += 21) > n2) {
                throw new CorruptObjectException(JGitText.get().corruptObjectTruncatedInObjectId);
            }
            if (ObjectId.zeroId().compareTo(byArray, n3 - 20) == 0) {
                this.report(ObjectChecker$ErrorType.NULL_SHA1, anyObjectId, JGitText.get().corruptObjectZeroId);
            }
            if (anyObjectId == null || !this.isGitmodules(byArray, n4, n5, anyObjectId)) continue;
            ObjectId objectId = ObjectId.fromRaw(byArray, n3 - 20);
            this.gitsubmodules.add(new GitmoduleEntry(anyObjectId, objectId));
        }
    }

    private int scanPathSegment(byte[] byArray, int n2, int n3, @Nullable AnyObjectId anyObjectId) {
        while (n2 < n3) {
            byte by = byArray[n2];
            if (by == 0) {
                return n2;
            }
            if (by == 47) {
                this.report(ObjectChecker$ErrorType.FULL_PATHNAME, anyObjectId, JGitText.get().corruptObjectNameContainsSlash);
            }
            if (this.windows && ObjectChecker.isInvalidOnWindows(by)) {
                if (by > 31) {
                    throw new CorruptObjectException(String.format(JGitText.get().corruptObjectNameContainsChar, by));
                }
                throw new CorruptObjectException(String.format(JGitText.get().corruptObjectNameContainsByte, by & 0xFF));
            }
            ++n2;
        }
        return n2;
    }

    @Nullable
    private ObjectId idFor(int n2, byte[] byArray) {
        if (this.skipList != null) {
            try (ObjectInserter$Formatter objectInserter$Formatter = new ObjectInserter$Formatter();){
                ObjectId objectId = objectInserter$Formatter.idFor(n2, byArray);
                return objectId;
            }
        }
        return null;
    }

    private void report(@NonNull ObjectChecker$ErrorType objectChecker$ErrorType, @Nullable AnyObjectId anyObjectId, String string) {
        if (this.errors.contains((Object)objectChecker$ErrorType) && (anyObjectId == null || this.skipList == null || !this.skipList.contains(anyObjectId))) {
            if (anyObjectId != null) {
                throw new CorruptObjectException(objectChecker$ErrorType, anyObjectId, string);
            }
            throw new CorruptObjectException(string);
        }
    }

    public void checkPath(String string) {
        byte[] byArray = Constants.encode(string);
        this.checkPath(byArray, 0, byArray.length);
    }

    public void checkPath(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        while (n2 < n3) {
            if (byArray[n2] == 47) {
                this.checkPathSegment(byArray, n4, n2);
                n4 = n2 + 1;
            }
            ++n2;
        }
        this.checkPathSegment(byArray, n4, n3);
    }

    public void checkPathSegment(byte[] byArray, int n2, int n3) {
        int n4 = this.scanPathSegment(byArray, n2, n3, null);
        if (n4 < n3 && byArray[n4] == 0) {
            throw new CorruptObjectException(JGitText.get().corruptObjectNameContainsNullByte);
        }
        this.checkPathSegment2(byArray, n2, n3, null);
    }

    private void checkPathSegment2(byte[] byArray, int n2, int n3, @Nullable AnyObjectId anyObjectId) {
        block13: {
            block12: {
                if (n2 == n3) {
                    this.report(ObjectChecker$ErrorType.EMPTY_NAME, anyObjectId, JGitText.get().corruptObjectNameZeroLength);
                    return;
                }
                if (byArray[n2] != 46) break block12;
                switch (n3 - n2) {
                    case 1: {
                        this.report(ObjectChecker$ErrorType.HAS_DOT, anyObjectId, JGitText.get().corruptObjectNameDot);
                        break;
                    }
                    case 2: {
                        if (byArray[n2 + 1] == 46) {
                            this.report(ObjectChecker$ErrorType.HAS_DOTDOT, anyObjectId, JGitText.get().corruptObjectNameDotDot);
                            break;
                        }
                        break block13;
                    }
                    case 4: {
                        if (ObjectChecker.isGit(byArray, n2 + 1)) {
                            this.report(ObjectChecker$ErrorType.HAS_DOTGIT, anyObjectId, String.format(JGitText.get().corruptObjectInvalidName, RawParseUtils.decode(byArray, n2, n3)));
                            break;
                        }
                        break block13;
                    }
                    default: {
                        if (n3 - n2 > 4 && ObjectChecker.isNormalizedGit(byArray, n2 + 1, n3)) {
                            this.report(ObjectChecker$ErrorType.HAS_DOTGIT, anyObjectId, String.format(JGitText.get().corruptObjectInvalidName, RawParseUtils.decode(byArray, n2, n3)));
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            if (ObjectChecker.isGitTilde1(byArray, n2, n3)) {
                this.report(ObjectChecker$ErrorType.HAS_DOTGIT, anyObjectId, String.format(JGitText.get().corruptObjectInvalidName, RawParseUtils.decode(byArray, n2, n3)));
            }
        }
        if (this.macosx && this.isMacHFSGit(byArray, n2, n3, anyObjectId)) {
            this.report(ObjectChecker$ErrorType.HAS_DOTGIT, anyObjectId, String.format(JGitText.get().corruptObjectInvalidNameIgnorableUnicode, RawParseUtils.decode(byArray, n2, n3)));
        }
        if (this.windows) {
            // empty if block
        }
    }

    private boolean isMacHFSPath(byte[] byArray, int n2, int n3, byte[] byArray2, @Nullable AnyObjectId anyObjectId) {
        boolean bl2 = false;
        int n4 = 0;
        block14: while (n2 < n3) {
            switch (byArray[n2]) {
                case -30: {
                    if (!this.checkTruncatedIgnorableUTF8(byArray, n2, n3, anyObjectId)) {
                        return false;
                    }
                    switch (byArray[n2 + 1]) {
                        case -128: {
                            switch (byArray[n2 + 2]) {
                                case -116: 
                                case -115: 
                                case -114: 
                                case -113: 
                                case -86: 
                                case -85: 
                                case -84: 
                                case -83: 
                                case -82: {
                                    bl2 = true;
                                    n2 += 3;
                                    continue block14;
                                }
                            }
                            return false;
                        }
                        case -127: {
                            switch (byArray[n2 + 2]) {
                                case -86: 
                                case -85: 
                                case -84: 
                                case -83: 
                                case -82: 
                                case -81: {
                                    bl2 = true;
                                    n2 += 3;
                                    continue block14;
                                }
                            }
                            return false;
                        }
                    }
                    return false;
                }
                case -17: {
                    if (!this.checkTruncatedIgnorableUTF8(byArray, n2, n3, anyObjectId)) {
                        return false;
                    }
                    if (byArray[n2 + 1] == -69 && byArray[n2 + 2] == -65) {
                        bl2 = true;
                        n2 += 3;
                        continue block14;
                    }
                    return false;
                }
            }
            if (n4 == byArray2.length) {
                return false;
            }
            if (ObjectChecker.toLower(byArray[n2++]) == byArray2[n4++]) continue;
            return false;
        }
        return n4 == byArray2.length && bl2;
    }

    private boolean isMacHFSGit(byte[] byArray, int n2, int n3, @Nullable AnyObjectId anyObjectId) {
        byte[] byArray2 = new byte[]{46, 103, 105, 116};
        return this.isMacHFSPath(byArray, n2, n3, byArray2, anyObjectId);
    }

    private boolean isMacHFSGitmodules(byte[] byArray, int n2, int n3, @Nullable AnyObjectId anyObjectId) {
        return this.isMacHFSPath(byArray, n2, n3, dotGitmodules, anyObjectId);
    }

    private boolean checkTruncatedIgnorableUTF8(byte[] byArray, int n2, int n3, @Nullable AnyObjectId anyObjectId) {
        if (n2 + 2 >= n3) {
            this.report(ObjectChecker$ErrorType.BAD_UTF8, anyObjectId, MessageFormat.format(JGitText.get().corruptObjectInvalidNameInvalidUtf8, ObjectChecker.toHexString(byArray, n2, n3)));
            return false;
        }
        return true;
    }

    private static String toHexString(byte[] byArray, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder("0x");
        for (int i2 = n2; i2 < n3; ++i2) {
            stringBuilder.append(String.format("%02x", byArray[i2]));
        }
        return stringBuilder.toString();
    }

    private void checkNotWindowsDevice(byte[] byArray, int n2, int n3, @Nullable AnyObjectId anyObjectId) {
        switch (ObjectChecker.toLower(byArray[n2])) {
            case 'a': {
                if (n3 - n2 < 3 || ObjectChecker.toLower(byArray[n2 + 1]) != 'u' || ObjectChecker.toLower(byArray[n2 + 2]) != 'x' || n3 - n2 != 3 && byArray[n2 + 3] != 46) break;
                this.report(ObjectChecker$ErrorType.WIN32_BAD_NAME, anyObjectId, JGitText.get().corruptObjectInvalidNameAux);
                break;
            }
            case 'c': {
                if (n3 - n2 >= 3 && ObjectChecker.toLower(byArray[n2 + 2]) == 'n' && ObjectChecker.toLower(byArray[n2 + 1]) == 'o' && (n3 - n2 == 3 || byArray[n2 + 3] == 46)) {
                    this.report(ObjectChecker$ErrorType.WIN32_BAD_NAME, anyObjectId, JGitText.get().corruptObjectInvalidNameCon);
                }
                if (n3 - n2 < 4 || ObjectChecker.toLower(byArray[n2 + 2]) != 'm' || ObjectChecker.toLower(byArray[n2 + 1]) != 'o' || !ObjectChecker.isPositiveDigit(byArray[n2 + 3]) || n3 - n2 != 4 && byArray[n2 + 4] != 46) break;
                this.report(ObjectChecker$ErrorType.WIN32_BAD_NAME, anyObjectId, String.format(JGitText.get().corruptObjectInvalidNameCom, Character.valueOf((char)byArray[n2 + 3])));
                break;
            }
            case 'l': {
                if (n3 - n2 < 4 || ObjectChecker.toLower(byArray[n2 + 1]) != 'p' || ObjectChecker.toLower(byArray[n2 + 2]) != 't' || !ObjectChecker.isPositiveDigit(byArray[n2 + 3]) || n3 - n2 != 4 && byArray[n2 + 4] != 46) break;
                this.report(ObjectChecker$ErrorType.WIN32_BAD_NAME, anyObjectId, String.format(JGitText.get().corruptObjectInvalidNameLpt, Character.valueOf((char)byArray[n2 + 3])));
                break;
            }
            case 'n': {
                if (n3 - n2 < 3 || ObjectChecker.toLower(byArray[n2 + 1]) != 'u' || ObjectChecker.toLower(byArray[n2 + 2]) != 'l' || n3 - n2 != 3 && byArray[n2 + 3] != 46) break;
                this.report(ObjectChecker$ErrorType.WIN32_BAD_NAME, anyObjectId, JGitText.get().corruptObjectInvalidNameNul);
                break;
            }
            case 'p': {
                if (n3 - n2 < 3 || ObjectChecker.toLower(byArray[n2 + 1]) != 'r' || ObjectChecker.toLower(byArray[n2 + 2]) != 'n' || n3 - n2 != 3 && byArray[n2 + 3] != 46) break;
                this.report(ObjectChecker$ErrorType.WIN32_BAD_NAME, anyObjectId, JGitText.get().corruptObjectInvalidNamePrn);
            }
        }
    }

    private static boolean isInvalidOnWindows(byte by) {
        switch (by) {
            case 34: 
            case 42: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 92: 
            case 124: {
                return true;
            }
        }
        return 1 <= by && by <= 31;
    }

    private static boolean isGit(byte[] byArray, int n2) {
        return ObjectChecker.toLower(byArray[n2]) == 'g' && ObjectChecker.toLower(byArray[n2 + 1]) == 'i' && ObjectChecker.toLower(byArray[n2 + 2]) == 't';
    }

    private boolean isGitmodules(byte[] byArray, int n2, int n3, @Nullable AnyObjectId anyObjectId) {
        if (n3 - n2 < 8) {
            return false;
        }
        return n3 - n2 == dotGitmodules.length && RawParseUtils.match(byArray, n2, dotGitmodules) != -1 || this.macosx && this.isMacHFSGitmodules(byArray, n2, n3, anyObjectId) || this.windows && this.isNTFSGitmodules(byArray, n2, n3);
    }

    private boolean matchLowerCase(byte[] byArray, int n2, byte[] byArray2) {
        if (n2 + byArray2.length > byArray.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < byArray2.length) {
            if (ObjectChecker.toLower(byArray[n2]) != byArray2[n3]) {
                return false;
            }
            ++n3;
            ++n2;
        }
        return true;
    }

    private boolean isNTFSGitmodules(byte[] byArray, int n2, int n3) {
        if (n3 - n2 == 11) {
            return this.matchLowerCase(byArray, n2, dotGitmodules);
        }
        if (n3 - n2 != 8) {
            return false;
        }
        byte[] byArray2 = new byte[]{103, 105, 116, 109, 111, 100, 126};
        if (this.matchLowerCase(byArray, n2, byArray2)) {
            n2 += 6;
        } else {
            byte by;
            byte[] byArray3 = new byte[]{103, 105, 55, 101, 98, 97};
            int n4 = 0;
            while (n4 < byArray3.length && (by = (byte)ObjectChecker.toLower(byArray[n2])) != 126) {
                if (by != byArray3[n4]) {
                    return false;
                }
                ++n4;
                ++n2;
            }
        }
        if (n3 - n2 < 2) {
            return false;
        }
        if (byArray[n2] != 126) {
            return false;
        }
        if (byArray[++n2] < 49 || byArray[n2] > 57) {
            return false;
        }
        ++n2;
        while (n2 != n3) {
            if (byArray[n2] < 48 || byArray[n2] > 57) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isGitTilde1(byte[] byArray, int n2, int n3) {
        if (n3 - n2 != 5) {
            return false;
        }
        return ObjectChecker.toLower(byArray[n2]) == 'g' && ObjectChecker.toLower(byArray[n2 + 1]) == 'i' && ObjectChecker.toLower(byArray[n2 + 2]) == 't' && byArray[n2 + 3] == 126 && byArray[n2 + 4] == 49;
    }

    private static boolean isNormalizedGit(byte[] byArray, int n2, int n3) {
        if (ObjectChecker.isGit(byArray, n2)) {
            int n4;
            int n5 = 0;
            boolean bl2 = false;
            for (n4 = n3 - 1; n2 + 2 < n4; --n4) {
                if (byArray[n4] == 46) {
                    ++n5;
                    continue;
                }
                if (byArray[n4] != 32) break;
                bl2 = true;
            }
            return n4 == n2 + 2 && (n5 == 1 || bl2);
        }
        return false;
    }

    private boolean match(byte[] byArray, byte[] byArray2) {
        int n2 = RawParseUtils.match(byArray, this.bufPtr.value, byArray2);
        if (n2 < 0) {
            return false;
        }
        this.bufPtr.value = n2;
        return true;
    }

    private static char toLower(byte by) {
        if (65 <= by && by <= 90) {
            return (char)(by + 32);
        }
        return (char)by;
    }

    private static boolean isPositiveDigit(byte by) {
        return 49 <= by && by <= 57;
    }

    @Nullable
    public BlobObjectChecker newBlobObjectChecker() {
        return null;
    }

    public void checkBlob(byte[] byArray) {
    }

    private String normalize(byte[] byArray, int n2, int n3) {
        String string = RawParseUtils.decode(byArray, n2, n3).toLowerCase(Locale.US);
        return this.macosx ? Normalizer.normalize(string, Normalizer.Form.NFC) : string;
    }

    public List getGitsubmodules() {
        return this.gitsubmodules;
    }

    public void reset() {
        this.gitsubmodules.clear();
    }
}

