/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.References;

public abstract class ObjectBuilder {
    private static final byte[] hencoding = Constants.encodeASCII("encoding");
    private PersonIdent author;
    private GpgSignature gpgSignature;
    private String message;
    private Charset encoding = StandardCharsets.UTF_8;

    protected PersonIdent getAuthor() {
        return this.author;
    }

    protected void setAuthor(PersonIdent personIdent) {
        this.author = Objects.requireNonNull(personIdent);
    }

    public void setGpgSignature(@Nullable GpgSignature gpgSignature) {
        this.gpgSignature = gpgSignature;
    }

    @Nullable
    public GpgSignature getGpgSignature() {
        return this.gpgSignature;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String string) {
        this.message = string;
    }

    @NonNull
    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(@NonNull Charset charset) {
        this.encoding = charset;
    }

    @NonNull
    public abstract byte[] build();

    static void writeMultiLineHeader(@NonNull String string, @NonNull OutputStream outputStream, boolean bl2) {
        int n2 = string.length();
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\r': {
                    if (i2 + 1 < n2 && string.charAt(i2 + 1) == '\n') {
                        ++i2;
                    }
                    if (i2 + 1 >= n2) continue block4;
                    outputStream.write(10);
                    outputStream.write(32);
                    continue block4;
                }
                case '\n': {
                    if (i2 + 1 >= n2) continue block4;
                    outputStream.write(10);
                    outputStream.write(32);
                    continue block4;
                }
                default: {
                    if (c2 > '\u007f' && bl2) {
                        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().notASCIIString, string));
                    }
                    outputStream.write(c2);
                }
            }
        }
    }

    static void writeEncoding(@NonNull Charset charset, @NonNull OutputStream outputStream) {
        if (!References.isSameObject(charset, StandardCharsets.UTF_8)) {
            outputStream.write(hencoding);
            outputStream.write(32);
            outputStream.write(Constants.encodeASCII(charset.name()));
            outputStream.write(10);
        }
    }
}

