/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

public class MutableObjectId
extends AnyObjectId {
    public MutableObjectId() {
    }

    MutableObjectId(MutableObjectId mutableObjectId) {
        this.fromObjectId(mutableObjectId);
    }

    public void setByte(int n2, int n3) {
        switch (n2 >> 2) {
            case 0: {
                this.w1 = MutableObjectId.set(this.w1, n2 & 3, n3);
                break;
            }
            case 1: {
                this.w2 = MutableObjectId.set(this.w2, n2 & 3, n3);
                break;
            }
            case 2: {
                this.w3 = MutableObjectId.set(this.w3, n2 & 3, n3);
                break;
            }
            case 3: {
                this.w4 = MutableObjectId.set(this.w4, n2 & 3, n3);
                break;
            }
            case 4: {
                this.w5 = MutableObjectId.set(this.w5, n2 & 3, n3);
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
        }
    }

    private static int set(int n2, int n3, int n4) {
        n4 &= 0xFF;
        switch (n3) {
            case 0: {
                return n2 & 0xFFFFFF | n4 << 24;
            }
            case 1: {
                return n2 & 0xFF00FFFF | n4 << 16;
            }
            case 2: {
                return n2 & 0xFFFF00FF | n4 << 8;
            }
            case 3: {
                return n2 & 0xFFFFFF00 | n4;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void clear() {
        this.w1 = 0;
        this.w2 = 0;
        this.w3 = 0;
        this.w4 = 0;
        this.w5 = 0;
    }

    public void fromObjectId(AnyObjectId anyObjectId) {
        this.w1 = anyObjectId.w1;
        this.w2 = anyObjectId.w2;
        this.w3 = anyObjectId.w3;
        this.w4 = anyObjectId.w4;
        this.w5 = anyObjectId.w5;
    }

    public void fromRaw(byte[] byArray) {
        this.fromRaw(byArray, 0);
    }

    public void fromRaw(byte[] byArray, int n2) {
        this.w1 = NB.decodeInt32(byArray, n2);
        this.w2 = NB.decodeInt32(byArray, n2 + 4);
        this.w3 = NB.decodeInt32(byArray, n2 + 8);
        this.w4 = NB.decodeInt32(byArray, n2 + 12);
        this.w5 = NB.decodeInt32(byArray, n2 + 16);
    }

    public void fromRaw(int[] nArray) {
        this.fromRaw(nArray, 0);
    }

    public void fromRaw(int[] nArray, int n2) {
        this.w1 = nArray[n2];
        this.w2 = nArray[n2 + 1];
        this.w3 = nArray[n2 + 2];
        this.w4 = nArray[n2 + 3];
        this.w5 = nArray[n2 + 4];
    }

    public void set(int n2, int n3, int n4, int n5, int n6) {
        this.w1 = n2;
        this.w2 = n3;
        this.w3 = n4;
        this.w4 = n5;
        this.w5 = n6;
    }

    public void fromString(byte[] byArray, int n2) {
        this.fromHexString(byArray, n2);
    }

    public void fromString(String string) {
        if (string.length() != 40) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidId, string));
        }
        this.fromHexString(Constants.encodeASCII(string), 0);
    }

    private void fromHexString(byte[] byArray, int n2) {
        try {
            this.w1 = RawParseUtils.parseHexInt32(byArray, n2);
            this.w2 = RawParseUtils.parseHexInt32(byArray, n2 + 8);
            this.w3 = RawParseUtils.parseHexInt32(byArray, n2 + 16);
            this.w4 = RawParseUtils.parseHexInt32(byArray, n2 + 24);
            this.w5 = RawParseUtils.parseHexInt32(byArray, n2 + 32);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            InvalidObjectIdException invalidObjectIdException = new InvalidObjectIdException(byArray, n2, 40);
            invalidObjectIdException.initCause(arrayIndexOutOfBoundsException);
            throw invalidObjectIdException;
        }
    }

    @Override
    public ObjectId toObjectId() {
        return new ObjectId(this);
    }
}

