/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.zip.Inflater;

public class InflaterCache {
    private static final int SZ = 4;
    private static final Inflater[] inflaterCache = new Inflater[4];
    private static int openInflaterCount;

    public static Inflater get() {
        Inflater inflater = InflaterCache.getImpl();
        return inflater != null ? inflater : new Inflater(false);
    }

    private static synchronized Inflater getImpl() {
        if (openInflaterCount > 0) {
            Inflater inflater = inflaterCache[--openInflaterCount];
            InflaterCache.inflaterCache[InflaterCache.openInflaterCount] = null;
            return inflater;
        }
        return null;
    }

    public static void release(Inflater inflater) {
        if (inflater != null) {
            inflater.reset();
            if (InflaterCache.releaseImpl(inflater)) {
                inflater.end();
            }
        }
    }

    private static synchronized boolean releaseImpl(Inflater inflater) {
        if (openInflaterCount < 4) {
            InflaterCache.inflaterCache[InflaterCache.openInflaterCount++] = inflater;
            return false;
        }
        return true;
    }

    private InflaterCache() {
        throw new UnsupportedOperationException();
    }
}

