/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.IndexDiff$ProgressReportingFilter;
import org.eclipse.jgit.lib.IndexDiff$StageState;
import org.eclipse.jgit.lib.IndexDiff$WorkingTreeIteratorFactory;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilderFactory;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk$IgnoreSubmoduleMode;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk$OperationType;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.SkipWorkTreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class IndexDiff {
    private static final int TREE = 0;
    private static final int INDEX = 1;
    private static final int WORKDIR = 2;
    private final Repository repository;
    private final AnyObjectId tree;
    private TreeFilter filter = null;
    private final WorkingTreeIterator initialWorkingTreeIterator;
    private Set added = new HashSet();
    private Set changed = new HashSet();
    private Set removed = new HashSet();
    private Set missing = new HashSet();
    private Set missingSubmodules = new HashSet();
    private Set modified = new HashSet();
    private Set untracked = new HashSet();
    private Map conflicts = new HashMap();
    private Set ignored;
    private Set assumeUnchanged;
    private DirCache dirCache;
    private IndexDiffFilter indexDiffFilter;
    private Map submoduleIndexDiffs = new HashMap();
    private SubmoduleWalk$IgnoreSubmoduleMode ignoreSubmoduleMode = null;
    private Map fileModes = new HashMap();
    private IndexDiff$WorkingTreeIteratorFactory wTreeIt = FileTreeIterator::new;

    public IndexDiff(Repository repository, String string, WorkingTreeIterator workingTreeIterator) {
        this(repository, repository.resolve(string), workingTreeIterator);
    }

    public IndexDiff(Repository repository, ObjectId objectId, WorkingTreeIterator workingTreeIterator) {
        this.repository = repository;
        if (objectId != null) {
            try (RevWalk revWalk = new RevWalk(repository);){
                this.tree = revWalk.parseTree(objectId);
            }
        } else {
            this.tree = null;
        }
        this.initialWorkingTreeIterator = workingTreeIterator;
    }

    public void setIgnoreSubmoduleMode(SubmoduleWalk$IgnoreSubmoduleMode submoduleWalk$IgnoreSubmoduleMode) {
        this.ignoreSubmoduleMode = submoduleWalk$IgnoreSubmoduleMode;
    }

    public void setWorkingTreeItFactory(IndexDiff$WorkingTreeIteratorFactory indexDiff$WorkingTreeIteratorFactory) {
        this.wTreeIt = indexDiff$WorkingTreeIteratorFactory;
    }

    public void setFilter(TreeFilter treeFilter) {
        this.filter = treeFilter;
    }

    public boolean diff() {
        return this.diff(null);
    }

    public boolean diff(RepositoryBuilderFactory repositoryBuilderFactory) {
        return this.diff(null, 0, 0, "", repositoryBuilderFactory);
    }

    public boolean diff(ProgressMonitor progressMonitor, int n2, int n3, String string) {
        return this.diff(progressMonitor, n2, n3, string, null);
    }

    public boolean diff(ProgressMonitor progressMonitor, int n2, int n3, String string, RepositoryBuilderFactory repositoryBuilderFactory) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.dirCache = this.repository.readDirCache();
        try (AutoCloseable autoCloseable = new TreeWalk(this.repository);){
            ((TreeWalk)autoCloseable).setOperationType(TreeWalk$OperationType.CHECKIN_OP);
            ((TreeWalk)autoCloseable).setRecursive(true);
            if (this.tree != null) {
                ((TreeWalk)autoCloseable).addTree(this.tree);
            } else {
                ((TreeWalk)autoCloseable).addTree(new EmptyTreeIterator());
            }
            ((TreeWalk)autoCloseable).addTree(new DirCacheIterator(this.dirCache));
            ((TreeWalk)autoCloseable).addTree(this.initialWorkingTreeIterator);
            this.initialWorkingTreeIterator.setDirCacheIterator((TreeWalk)autoCloseable, 1);
            object4 = new ArrayList<TreeFilter>(4);
            if (progressMonitor != null) {
                if (n3 == 0) {
                    n3 = this.dirCache.getEntryCount();
                }
                int n4 = Math.max(n3 * 10 / 9, n2 * 10 / 9);
                progressMonitor.beginTask(string, n4);
                object4.add(new IndexDiff$ProgressReportingFilter(progressMonitor, n4));
            }
            if (this.filter != null) {
                object4.add(this.filter);
            }
            object4.add(new SkipWorkTreeFilter(1));
            this.indexDiffFilter = new IndexDiffFilter(1, 2);
            object4.add(this.indexDiffFilter);
            ((TreeWalk)autoCloseable).setFilter(AndTreeFilter.create(object4));
            this.fileModes.clear();
            while (((TreeWalk)autoCloseable).next()) {
                int n5;
                AbstractTreeIterator abstractTreeIterator = ((TreeWalk)autoCloseable).getTree(0, AbstractTreeIterator.class);
                object3 = (DirCacheIterator)((TreeWalk)autoCloseable).getTree(1, DirCacheIterator.class);
                object2 = (WorkingTreeIterator)((TreeWalk)autoCloseable).getTree(2, WorkingTreeIterator.class);
                if (object3 != null && (object = ((DirCacheIterator)object3).getDirCacheEntry()) != null && (n5 = ((DirCacheEntry)object).getStage()) > 0) {
                    String string2 = ((TreeWalk)autoCloseable).getPathString();
                    this.addConflict(string2, n5);
                    continue;
                }
                if (abstractTreeIterator != null) {
                    if (object3 != null) {
                        if (!(abstractTreeIterator.idEqual((AbstractTreeIterator)object3) && abstractTreeIterator.getEntryRawMode() == ((AbstractTreeIterator)object3).getEntryRawMode() || this.isEntryGitLink(abstractTreeIterator) && this.isEntryGitLink((AbstractTreeIterator)object3) && this.ignoreSubmoduleMode == SubmoduleWalk$IgnoreSubmoduleMode.ALL)) {
                            this.changed.add(((TreeWalk)autoCloseable).getPathString());
                        }
                    } else {
                        if (!this.isEntryGitLink(abstractTreeIterator) || this.ignoreSubmoduleMode != SubmoduleWalk$IgnoreSubmoduleMode.ALL) {
                            this.removed.add(((TreeWalk)autoCloseable).getPathString());
                        }
                        if (object2 != null) {
                            this.untracked.add(((TreeWalk)autoCloseable).getPathString());
                        }
                    }
                } else if (object3 != null) {
                    if (!this.isEntryGitLink((AbstractTreeIterator)object3) || this.ignoreSubmoduleMode != SubmoduleWalk$IgnoreSubmoduleMode.ALL) {
                        this.added.add(((TreeWalk)autoCloseable).getPathString());
                    }
                } else if (object2 != null && !((WorkingTreeIterator)object2).isEntryIgnored()) {
                    this.untracked.add(((TreeWalk)autoCloseable).getPathString());
                }
                if (object3 != null) {
                    if (object2 == null) {
                        boolean bl2 = this.isEntryGitLink((AbstractTreeIterator)object3);
                        if (!bl2 || this.ignoreSubmoduleMode != SubmoduleWalk$IgnoreSubmoduleMode.ALL) {
                            String string3 = ((TreeWalk)autoCloseable).getPathString();
                            this.missing.add(string3);
                            if (bl2) {
                                this.missingSubmodules.add(string3);
                            }
                        }
                    } else if (((WorkingTreeIterator)object2).isModified(((DirCacheIterator)object3).getDirCacheEntry(), true, ((TreeWalk)autoCloseable).getObjectReader()) && (!this.isEntryGitLink((AbstractTreeIterator)object3) || !this.isEntryGitLink((AbstractTreeIterator)object2) || this.ignoreSubmoduleMode != SubmoduleWalk$IgnoreSubmoduleMode.ALL && this.ignoreSubmoduleMode != SubmoduleWalk$IgnoreSubmoduleMode.DIRTY)) {
                        this.modified.add(((TreeWalk)autoCloseable).getPathString());
                    }
                }
                if ((object = ((TreeWalk)autoCloseable).getPathString()) == null) continue;
                for (n5 = 0; n5 < ((TreeWalk)autoCloseable).getTreeCount(); ++n5) {
                    this.recordFileMode((String)object, ((TreeWalk)autoCloseable).getFileMode(n5));
                }
            }
        }
        if (this.ignoreSubmoduleMode != SubmoduleWalk$IgnoreSubmoduleMode.ALL) {
            autoCloseable = new SubmoduleWalk(this.repository);
            var7_7 = null;
            try {
                ((SubmoduleWalk)autoCloseable).setTree(new DirCacheIterator(this.dirCache));
                ((SubmoduleWalk)autoCloseable).setBuilderFactory(repositoryBuilderFactory);
                while (((SubmoduleWalk)autoCloseable).next()) {
                    object4 = this.ignoreSubmoduleMode;
                    try {
                        if (object4 == null) {
                            object4 = ((SubmoduleWalk)autoCloseable).getModulesIgnore();
                        }
                        if (SubmoduleWalk$IgnoreSubmoduleMode.ALL.equals(object4)) {
                            continue;
                        }
                    }
                    catch (ConfigInvalidException configInvalidException) {
                        throw new IOException(MessageFormat.format(JGitText.get().invalidIgnoreParamSubmodule, ((SubmoduleWalk)autoCloseable).getPath()), configInvalidException);
                    }
                    Repository repository = ((SubmoduleWalk)autoCloseable).getRepository();
                    object3 = null;
                    try {
                        Object object5;
                        object2 = ((SubmoduleWalk)autoCloseable).getPath();
                        if (repository != null) {
                            object = repository.resolve("HEAD");
                            if (object != null && !((AnyObjectId)object).equals(((SubmoduleWalk)autoCloseable).getObjectId())) {
                                this.modified.add(object2);
                                this.recordFileMode((String)object2, FileMode.GITLINK);
                                continue;
                            }
                            if (object4 == SubmoduleWalk$IgnoreSubmoduleMode.DIRTY) continue;
                            object5 = (IndexDiff)this.submoduleIndexDiffs.get(((SubmoduleWalk)autoCloseable).getPath());
                            if (object5 == null) {
                                object5 = new IndexDiff(repository, ((SubmoduleWalk)autoCloseable).getObjectId(), this.wTreeIt.getWorkingTreeIterator(repository));
                                this.submoduleIndexDiffs.put(object2, object5);
                            }
                            if (!((IndexDiff)object5).diff(repositoryBuilderFactory) || object4 == SubmoduleWalk$IgnoreSubmoduleMode.UNTRACKED && ((IndexDiff)object5).getAdded().isEmpty() && ((IndexDiff)object5).getChanged().isEmpty() && ((IndexDiff)object5).getConflicting().isEmpty() && ((IndexDiff)object5).getMissing().isEmpty() && ((IndexDiff)object5).getModified().isEmpty() && ((IndexDiff)object5).getRemoved().isEmpty()) continue;
                            this.modified.add(object2);
                            this.recordFileMode((String)object2, FileMode.GITLINK);
                            continue;
                        }
                        if (!this.missingSubmodules.remove(object2) || ((File)(object = new File(new File(this.repository.getDirectory(), "modules"), (String)object2))).isDirectory() || !((File)(object5 = SubmoduleWalk.getSubmoduleDirectory(this.repository, (String)object2))).isDirectory() || this.hasFiles((File)object5)) continue;
                        this.missing.remove(object2);
                    }
                    catch (Throwable throwable) {
                        object3 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (repository == null) continue;
                        if (object3 != null) {
                            try {
                                repository.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object3).addSuppressed(throwable);
                            }
                            continue;
                        }
                        repository.close();
                    }
                }
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (autoCloseable != null) {
                    if (var7_7 != null) {
                        try {
                            ((SubmoduleWalk)autoCloseable).close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        ((SubmoduleWalk)autoCloseable).close();
                    }
                }
            }
        }
        if (progressMonitor != null) {
            progressMonitor.endTask();
        }
        this.ignored = this.indexDiffFilter.getIgnoredPaths();
        return !this.added.isEmpty() || !this.changed.isEmpty() || !this.removed.isEmpty() || !this.missing.isEmpty() || !this.modified.isEmpty() || !this.untracked.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasFiles(File file) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(file.toPath());){
            boolean bl2 = directoryStream.iterator().hasNext();
            return bl2;
        }
        catch (IOException | DirectoryIteratorException exception) {
            return false;
        }
    }

    private void recordFileMode(String string, FileMode fileMode) {
        HashSet<String> hashSet = (HashSet<String>)this.fileModes.get(fileMode);
        if (string != null) {
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                this.fileModes.put(fileMode, hashSet);
            }
            hashSet.add(string);
        }
    }

    private boolean isEntryGitLink(AbstractTreeIterator abstractTreeIterator) {
        return abstractTreeIterator != null && abstractTreeIterator.getEntryRawMode() == FileMode.GITLINK.getBits();
    }

    private void addConflict(String string, int n2) {
        IndexDiff$StageState indexDiff$StageState = (IndexDiff$StageState)((Object)this.conflicts.get(string));
        byte by = 0;
        if (indexDiff$StageState != null) {
            by = (byte)(by | (byte)indexDiff$StageState.getStageMask());
        }
        int n3 = n2 - 1;
        by = (byte)(by | (byte)(1 << n3));
        IndexDiff$StageState indexDiff$StageState2 = IndexDiff$StageState.fromMask(by);
        this.conflicts.put(string, indexDiff$StageState2);
    }

    public Set getAdded() {
        return this.added;
    }

    public Set getChanged() {
        return this.changed;
    }

    public Set getRemoved() {
        return this.removed;
    }

    public Set getMissing() {
        return this.missing;
    }

    public Set getModified() {
        return this.modified;
    }

    public Set getUntracked() {
        return this.untracked;
    }

    public Set getConflicting() {
        return this.conflicts.keySet();
    }

    public Map getConflictingStageStates() {
        return this.conflicts;
    }

    public Set getIgnoredNotInIndex() {
        return this.ignored;
    }

    public Set getAssumeUnchanged() {
        if (this.assumeUnchanged == null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i2 = 0; i2 < this.dirCache.getEntryCount(); ++i2) {
                if (!this.dirCache.getEntry(i2).isAssumeValid()) continue;
                hashSet.add(this.dirCache.getEntry(i2).getPathString());
            }
            this.assumeUnchanged = hashSet;
        }
        return this.assumeUnchanged;
    }

    public Set getUntrackedFolders() {
        return this.indexDiffFilter == null ? Collections.emptySet() : new HashSet(this.indexDiffFilter.getUntrackedFolders());
    }

    public FileMode getIndexMode(String string) {
        DirCacheEntry dirCacheEntry = this.dirCache.getEntry(string);
        return dirCacheEntry != null ? dirCacheEntry.getFileMode() : FileMode.MISSING;
    }

    public Set getPathsWithIndexMode(FileMode fileMode) {
        HashSet hashSet = (HashSet)this.fileModes.get(fileMode);
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        return hashSet;
    }
}

