/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GpgSigner {
    private static final Logger LOG = LoggerFactory.getLogger(GpgSigner.class);
    private static GpgSigner defaultSigner = GpgSigner.loadGpgSigner();

    private static GpgSigner loadGpgSigner() {
        try {
            ServiceLoader<GpgSigner> serviceLoader = ServiceLoader.load(GpgSigner.class);
            Iterator<GpgSigner> iterator = serviceLoader.iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            LOG.error(serviceConfigurationError.getMessage(), (Throwable)serviceConfigurationError);
        }
        return null;
    }

    public static GpgSigner getDefault() {
        return defaultSigner;
    }

    public static void setDefault(GpgSigner gpgSigner) {
        defaultSigner = gpgSigner;
    }

    public abstract void sign(@NonNull CommitBuilder var1, @Nullable String var2, @NonNull PersonIdent var3, CredentialsProvider var4);

    public abstract boolean canLocateSigningKey(@Nullable String var1, @NonNull PersonIdent var2, CredentialsProvider var3);
}

