/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.eclipse.jgit.lib.GpgSignatureVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GpgSignatureVerifierFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GpgSignatureVerifierFactory.class);
    private static volatile GpgSignatureVerifierFactory defaultFactory = GpgSignatureVerifierFactory.loadDefault();

    private static GpgSignatureVerifierFactory loadDefault() {
        try {
            ServiceLoader<GpgSignatureVerifierFactory> serviceLoader = ServiceLoader.load(GpgSignatureVerifierFactory.class);
            Iterator<GpgSignatureVerifierFactory> iterator = serviceLoader.iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            LOG.error(serviceConfigurationError.getMessage(), (Throwable)serviceConfigurationError);
        }
        return null;
    }

    public static GpgSignatureVerifierFactory getDefault() {
        return defaultFactory;
    }

    public static void setDefault(GpgSignatureVerifierFactory gpgSignatureVerifierFactory) {
        defaultFactory = gpgSignatureVerifierFactory;
    }

    public abstract GpgSignatureVerifier getVerifier();
}

