/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.GpgConfig$GpgFormat;

public class GpgConfig {
    private final GpgConfig$GpgFormat keyFormat;
    private final String signingKey;
    private final String program;
    private final boolean signCommits;
    private final boolean signAllTags;
    private final boolean forceAnnotated;

    public GpgConfig(String string, GpgConfig$GpgFormat gpgConfig$GpgFormat, String string2) {
        this.keyFormat = gpgConfig$GpgFormat;
        this.signingKey = string;
        this.program = string2;
        this.signCommits = true;
        this.signAllTags = false;
        this.forceAnnotated = false;
    }

    public GpgConfig(Config config) {
        this.keyFormat = (GpgConfig$GpgFormat)config.getEnum(GpgConfig$GpgFormat.values(), "gpg", null, "format", GpgConfig$GpgFormat.OPENPGP);
        this.signingKey = config.getString("user", null, "signingKey");
        String string = config.getString("gpg", this.keyFormat.toConfigValue(), "program");
        if (string == null) {
            string = config.getString("gpg", null, "program");
        }
        this.program = string;
        this.signCommits = config.getBoolean("commit", "gpgSign", false);
        this.signAllTags = config.getBoolean("tag", "gpgSign", false);
        this.forceAnnotated = config.getBoolean("tag", "forceSignAnnotated", false);
    }

    public GpgConfig$GpgFormat getKeyFormat() {
        return this.keyFormat;
    }

    public String getProgram() {
        return this.program;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public boolean isSignCommits() {
        return this.signCommits;
    }

    public boolean isSignAllTags() {
        return this.signAllTags;
    }

    public boolean isSignAnnotated() {
        return this.forceAnnotated;
    }
}

