/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.FileModeCache$CacheItem;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;

public class FileModeCache {
    @NonNull
    private final FileModeCache$CacheItem root = new FileModeCache$CacheItem(FileMode.TREE);
    @NonNull
    private final Repository repo;

    public FileModeCache(@NonNull Repository repository) {
        this.repo = repository;
    }

    @NonNull
    public Repository getRepository() {
        return this.repo;
    }

    @NonNull
    public FileModeCache$CacheItem getRoot() {
        return this.root;
    }

    public void safeCreateParentDirectory(String string, File file, boolean bl2) {
        FileModeCache$CacheItem fileModeCache$CacheItem = this.safeCreateDirectory(string, file, bl2);
        fileModeCache$CacheItem.remove(string.substring(string.lastIndexOf(47) + 1));
    }

    public FileModeCache$CacheItem safeCreateDirectory(String string, File file, boolean bl2) {
        FS fS = this.repo.getFS();
        int n2 = string.lastIndexOf(47);
        String string2 = null;
        if (n2 >= 0) {
            if (bl2 && file.isFile() || fS.isSymLink(file)) {
                FileUtils.delete(file);
            }
            string2 = string.substring(0, n2);
            this.deleteSymlinkParent(fS, string2, this.repo.getWorkTree());
        }
        FileUtils.mkdirs(file, true);
        FileModeCache$CacheItem fileModeCache$CacheItem = this.getRoot();
        if (string2 != null) {
            fileModeCache$CacheItem = this.add(string2, FileMode.TREE);
        }
        return fileModeCache$CacheItem;
    }

    private void deleteSymlinkParent(FS fS, String string, File file) {
        if (!fS.supportsSymlinks()) {
            return;
        }
        String[] stringArray = string.split("/");
        int n2 = stringArray.length;
        FileModeCache$CacheItem fileModeCache$CacheItem = this.getRoot();
        File file2 = file;
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            FileModeCache$CacheItem fileModeCache$CacheItem2;
            block11: {
                file2 = new File(file2, stringArray[i2]);
                fileModeCache$CacheItem2 = fileModeCache$CacheItem != null ? fileModeCache$CacheItem.child(stringArray[i2]) : null;
                bl2 = false;
                if (fileModeCache$CacheItem2 != null) {
                    if (FileMode.SYMLINK.equals(fileModeCache$CacheItem2.getMode())) {
                        bl2 = true;
                    }
                } else {
                    try {
                        Path path = FileUtils.toPath(file2);
                        BasicFileAttributes basicFileAttributes = path.getFileSystem().provider().getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
                        if (basicFileAttributes.isSymbolicLink()) {
                            bl2 = file2.isDirectory();
                        } else if (basicFileAttributes.isRegularFile()) {
                        }
                        break block11;
                    }
                    catch (IOException | InvalidPathException exception) {}
                    break;
                }
            }
            if (bl2) {
                FileUtils.delete(file2, 4);
                if (fileModeCache$CacheItem == null) break;
                fileModeCache$CacheItem.remove(stringArray[i2]);
                break;
            }
            fileModeCache$CacheItem = fileModeCache$CacheItem2;
        }
    }

    @NonNull
    private FileModeCache$CacheItem add(String string, FileMode fileMode) {
        FileModeCache$CacheItem fileModeCache$CacheItem;
        int n2;
        if (string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = string.split("/");
        int n3 = stringArray.length;
        FileModeCache$CacheItem fileModeCache$CacheItem2 = this.getRoot();
        for (n2 = 0; n2 < n3 && (fileModeCache$CacheItem = fileModeCache$CacheItem2.child(stringArray[n2])) != null; ++n2) {
            fileModeCache$CacheItem2 = fileModeCache$CacheItem;
        }
        if (n2 == n3) {
            fileModeCache$CacheItem2.setMode(fileMode);
        } else {
            while (n2 < n3) {
                fileModeCache$CacheItem2 = fileModeCache$CacheItem2.insert(stringArray[n2], n2 + 1 == n3 ? fileMode : FileMode.TREE);
                ++n2;
            }
        }
        return fileModeCache$CacheItem2;
    }
}

