/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.OutputStream;
import org.eclipse.jgit.lib.FileMode$1;
import org.eclipse.jgit.lib.FileMode$2;
import org.eclipse.jgit.lib.FileMode$3;
import org.eclipse.jgit.lib.FileMode$4;
import org.eclipse.jgit.lib.FileMode$5;
import org.eclipse.jgit.lib.FileMode$6;
import org.eclipse.jgit.lib.FileMode$7;

public abstract class FileMode {
    public static final int TYPE_MASK = 61440;
    public static final int TYPE_TREE = 16384;
    public static final int TYPE_SYMLINK = 40960;
    public static final int TYPE_FILE = 32768;
    public static final int TYPE_GITLINK = 57344;
    public static final int TYPE_MISSING = 0;
    public static final FileMode TREE = new FileMode$1(16384, 2);
    public static final FileMode SYMLINK = new FileMode$2(40960, 3);
    public static final FileMode REGULAR_FILE = new FileMode$3(33188, 3);
    public static final FileMode EXECUTABLE_FILE = new FileMode$4(33261, 3);
    public static final FileMode GITLINK = new FileMode$5(57344, 1);
    public static final FileMode MISSING = new FileMode$6(0, -1);
    private final byte[] octalBytes;
    private final int modeBits;
    private final int objectType;

    public static final FileMode fromBits(int n2) {
        switch (n2 & 0xF000) {
            case 0: {
                if (n2 != 0) break;
                return MISSING;
            }
            case 16384: {
                return TREE;
            }
            case 32768: {
                if ((n2 & 0x49) != 0) {
                    return EXECUTABLE_FILE;
                }
                return REGULAR_FILE;
            }
            case 40960: {
                return SYMLINK;
            }
            case 57344: {
                return GITLINK;
            }
        }
        return new FileMode$7(n2, -1, n2);
    }

    private FileMode(int n2, int n3) {
        this.modeBits = n2;
        this.objectType = n3;
        if (n2 != 0) {
            byte[] byArray = new byte[10];
            int n4 = byArray.length;
            while (n2 != 0) {
                byArray[--n4] = (byte)(48 + (n2 & 7));
                n2 >>= 3;
            }
            this.octalBytes = new byte[byArray.length - n4];
            for (int i2 = 0; i2 < this.octalBytes.length; ++i2) {
                this.octalBytes[i2] = byArray[n4 + i2];
            }
        } else {
            this.octalBytes = new byte[]{48};
        }
    }

    public abstract boolean equals(int var1);

    public void copyTo(OutputStream outputStream) {
        outputStream.write(this.octalBytes);
    }

    public void copyTo(byte[] byArray, int n2) {
        System.arraycopy(this.octalBytes, 0, byArray, n2, this.octalBytes.length);
    }

    public int copyToLength() {
        return this.octalBytes.length;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public String toString() {
        return Integer.toOctalString(this.modeBits);
    }

    public int getBits() {
        return this.modeBits;
    }

    /* synthetic */ FileMode(int n2, int n3, FileMode$1 fileMode$1) {
        this(n2, n3);
    }
}

