/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Config$ConfigEnum;
import org.eclipse.jgit.lib.ConfigIllegalValueException;
import org.eclipse.jgit.lib.TypedConfigGetter;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.StringUtils;

public class DefaultTypedConfigGetter
implements TypedConfigGetter {
    @Override
    public boolean getBoolean(Config config, String string, String string2, String string3, boolean bl2) {
        String string4 = config.getRawString(string, string2, string3);
        if (string4 == null) {
            return bl2;
        }
        if (Config.isMissing(string4)) {
            return true;
        }
        try {
            return StringUtils.toBoolean(string4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ConfigIllegalValueException(MessageFormat.format(JGitText.get().invalidBooleanValue, string, string3, string4), illegalArgumentException);
        }
    }

    @Override
    public Enum getEnum(Config config, Enum[] enumArray, String string, String string2, String string3, Enum enum_) {
        String string4 = config.getString(string, string2, string3);
        if (string4 == null) {
            return enum_;
        }
        if (enumArray[0] instanceof Config$ConfigEnum) {
            for (Enum enumArray2 : enumArray) {
                if (!((Config$ConfigEnum)((Object)enumArray2)).matchConfigValue(string4)) continue;
                return enumArray2;
            }
        }
        Object object = string4.replace(' ', '_');
        object = ((String)object).replace('-', '_');
        Enum enum_2 = null;
        Enum enum_3 = null;
        for (Enum enum_4 : enumArray) {
            if (StringUtils.equalsIgnoreCase(enum_4.name(), (String)object)) {
                return enum_4;
            }
            if (StringUtils.equalsIgnoreCase(enum_4.name(), "TRUE")) {
                enum_2 = enum_4;
                continue;
            }
            if (!StringUtils.equalsIgnoreCase(enum_4.name(), "FALSE")) continue;
            enum_3 = enum_4;
        }
        if (enum_2 != null && enum_3 != null) {
            try {
                return StringUtils.toBoolean((String)object) ? enum_2 : enum_3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (string2 != null) {
            throw new ConfigIllegalValueException(MessageFormat.format(JGitText.get().enumValueNotSupported3, string, string2, string3, string4));
        }
        throw new ConfigIllegalValueException(MessageFormat.format(JGitText.get().enumValueNotSupported2, string, string3, string4));
    }

    @Override
    public int getInt(Config config, String string, String string2, String string3, int n2) {
        long l2 = config.getLong(string, string2, string3, n2);
        if (Integer.MIN_VALUE <= l2 && l2 <= Integer.MAX_VALUE) {
            return (int)l2;
        }
        throw new ConfigIllegalValueException(MessageFormat.format(JGitText.get().integerValueOutOfRange, string, string3));
    }

    @Override
    public long getLong(Config config, String string, String string2, String string3, long l2) {
        String string4 = config.getString(string, string2, string3);
        if (string4 == null) {
            return l2;
        }
        String string5 = string4.trim();
        if (string5.length() == 0) {
            return l2;
        }
        long l3 = 1L;
        switch (StringUtils.toLowerCase(string5.charAt(string5.length() - 1))) {
            case 'g': {
                l3 = 0x40000000L;
                break;
            }
            case 'm': {
                l3 = 0x100000L;
                break;
            }
            case 'k': {
                l3 = 1024L;
            }
        }
        if (l3 > 1L) {
            string5 = string5.substring(0, string5.length() - 1).trim();
        }
        if (string5.length() == 0) {
            return l2;
        }
        try {
            return l3 * Long.parseLong(string5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigIllegalValueException(MessageFormat.format(JGitText.get().invalidIntegerValue, string, string3, string4), numberFormatException);
        }
    }

    @Override
    public long getTimeUnit(Config config, String string, String string2, String string3, long l2, TimeUnit timeUnit) {
        int n2;
        TimeUnit timeUnit2;
        String string4 = config.getString(string, string2, string3);
        if (string4 == null) {
            return l2;
        }
        String string5 = string4.trim();
        if (string5.length() == 0) {
            return l2;
        }
        if (string5.startsWith("-")) {
            throw DefaultTypedConfigGetter.notTimeUnit(string, string2, string3, string4);
        }
        Matcher matcher = Pattern.compile("^(0|[1-9][0-9]*)\\s*(.*)$").matcher(string4);
        if (!matcher.matches()) {
            return l2;
        }
        String string6 = matcher.group(1);
        String string7 = matcher.group(2).trim();
        if (string7.isEmpty()) {
            timeUnit2 = timeUnit;
            n2 = 1;
        } else if (DefaultTypedConfigGetter.match(string7, "ns", "nanoseconds")) {
            timeUnit2 = TimeUnit.NANOSECONDS;
            n2 = 1;
        } else if (DefaultTypedConfigGetter.match(string7, "us", "microseconds")) {
            timeUnit2 = TimeUnit.MICROSECONDS;
            n2 = 1;
        } else if (DefaultTypedConfigGetter.match(string7, "ms", "milliseconds")) {
            timeUnit2 = TimeUnit.MILLISECONDS;
            n2 = 1;
        } else if (DefaultTypedConfigGetter.match(string7, "s", "sec", "second", "seconds")) {
            timeUnit2 = TimeUnit.SECONDS;
            n2 = 1;
        } else if (DefaultTypedConfigGetter.match(string7, "m", "min", "minute", "minutes")) {
            timeUnit2 = TimeUnit.MINUTES;
            n2 = 1;
        } else if (DefaultTypedConfigGetter.match(string7, "h", "hr", "hour", "hours")) {
            timeUnit2 = TimeUnit.HOURS;
            n2 = 1;
        } else if (DefaultTypedConfigGetter.match(string7, "d", "day", "days")) {
            timeUnit2 = TimeUnit.DAYS;
            n2 = 1;
        } else if (DefaultTypedConfigGetter.match(string7, "w", "week", "weeks")) {
            timeUnit2 = TimeUnit.DAYS;
            n2 = 7;
        } else if (DefaultTypedConfigGetter.match(string7, "mon", "month", "months")) {
            timeUnit2 = TimeUnit.DAYS;
            n2 = 30;
        } else if (DefaultTypedConfigGetter.match(string7, "y", "year", "years")) {
            timeUnit2 = TimeUnit.DAYS;
            n2 = 365;
        } else {
            throw DefaultTypedConfigGetter.notTimeUnit(string, string2, string3, string4);
        }
        try {
            return timeUnit.convert(Long.parseLong(string6) * (long)n2, timeUnit2);
        }
        catch (NumberFormatException numberFormatException) {
            ConfigIllegalValueException configIllegalValueException = DefaultTypedConfigGetter.notTimeUnit(string, string2, string7, string4);
            configIllegalValueException.initCause(numberFormatException);
            throw configIllegalValueException;
        }
    }

    private static boolean match(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static ConfigIllegalValueException notTimeUnit(String string, String string2, String string3, String string4) {
        if (string2 != null) {
            return new ConfigIllegalValueException(MessageFormat.format(JGitText.get().invalidTimeUnitValue3, string, string2, string3, string4));
        }
        return new ConfigIllegalValueException(MessageFormat.format(JGitText.get().invalidTimeUnitValue2, string, string3, string4));
    }

    @Override
    @NonNull
    public List getRefSpecs(Config config, String string, String string2, String string3) {
        String[] stringArray = config.getStringList(string, string2, string3);
        ArrayList<RefSpec> arrayList = new ArrayList<RefSpec>(stringArray.length);
        for (String string4 : stringArray) {
            arrayList.add(new RefSpec(string4));
        }
        return arrayList;
    }
}

