/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.lib.ConfigLine;
import org.eclipse.jgit.lib.ConfigSnapshot$CaseFoldingSet;
import org.eclipse.jgit.lib.ConfigSnapshot$LineComparator;
import org.eclipse.jgit.lib.ConfigSnapshot$SectionNames;
import org.eclipse.jgit.util.StringUtils;

class ConfigSnapshot {
    final List entryList;
    final Map cache;
    final ConfigSnapshot baseState;
    volatile List sorted;
    volatile ConfigSnapshot$SectionNames names;

    ConfigSnapshot(List list, ConfigSnapshot configSnapshot) {
        this.entryList = list;
        this.cache = new ConcurrentHashMap(16, 0.75f, 1);
        this.baseState = configSnapshot;
    }

    Set getSections() {
        return this.names().sections;
    }

    Set getSubsections(String string) {
        Map map = this.names().subsections;
        Set set = (Set)map.get(string);
        if (set == null) {
            set = (Set)map.get(StringUtils.toLowerCase(string));
        }
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    Set getNames(String string, String string2) {
        return this.getNames(string, string2, false);
    }

    Set getNames(String string, String string2, boolean bl2) {
        Map map = this.getNamesInternal(string, string2, bl2);
        return new ConfigSnapshot$CaseFoldingSet(map);
    }

    private Map getNamesInternal(String string, String string2, boolean bl2) {
        ConfigLine configLine;
        List list = this.sorted();
        int n2 = this.find(list, string, string2, "");
        if (n2 < 0) {
            n2 = -(n2 + 1);
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (n2 < list.size() && (configLine = (ConfigLine)list.get(n2++)).match(string, string2)) {
            String string3;
            if (configLine.name == null || linkedHashMap.containsKey(string3 = StringUtils.toLowerCase(configLine.name))) continue;
            linkedHashMap.put(string3, configLine.name);
        }
        if (bl2 && this.baseState != null) {
            linkedHashMap.putAll(this.baseState.getNamesInternal(string, string2, bl2));
        }
        return linkedHashMap;
    }

    String[] get(String string, String string2, String string3) {
        List list = this.sorted();
        int n2 = this.find(list, string, string2, string3);
        if (n2 < 0) {
            return null;
        }
        int n3 = this.end(list, n2, string, string2, string3);
        String[] stringArray = new String[n3 - n2];
        int n4 = 0;
        while (n2 < n3) {
            stringArray[n4++] = ((ConfigLine)list.get((int)n2++)).value;
        }
        return stringArray;
    }

    private int find(List list, String string, String string2, String string3) {
        int n2 = 0;
        int n3 = list.size();
        while (n2 < n3) {
            int n4 = n2 + n3 >>> 1;
            ConfigLine configLine = (ConfigLine)list.get(n4);
            int n5 = ConfigSnapshot.compare2(string, string2, string3, configLine.section, configLine.subsection, configLine.name);
            if (n5 < 0) {
                n3 = n4;
                continue;
            }
            if (n5 == 0) {
                return this.first(list, n4, string, string2, string3);
            }
            n2 = n4 + 1;
        }
        return -(n2 + 1);
    }

    private int first(List list, int n2, String string, String string2, String string3) {
        while (0 < n2) {
            if (((ConfigLine)list.get(n2 - 1)).match(string, string2, string3)) {
                --n2;
                continue;
            }
            return n2;
        }
        return n2;
    }

    private int end(List list, int n2, String string, String string2, String string3) {
        while (n2 < list.size()) {
            if (((ConfigLine)list.get(n2)).match(string, string2, string3)) {
                ++n2;
                continue;
            }
            return n2;
        }
        return n2;
    }

    private List sorted() {
        List list = this.sorted;
        if (list == null) {
            this.sorted = list = ConfigSnapshot.sort(this.entryList);
        }
        return list;
    }

    private static List sort(List list) {
        ArrayList<ConfigLine> arrayList = new ArrayList<ConfigLine>(list.size());
        for (ConfigLine configLine : list) {
            if (configLine.section == null || configLine.name == null) continue;
            arrayList.add(configLine);
        }
        Collections.sort(arrayList, new ConfigSnapshot$LineComparator(null));
        return arrayList;
    }

    private static int compare2(String string, String string2, String string3, String string4, String string5, String string6) {
        int n2 = StringUtils.compareIgnoreCase(string, string4);
        if (n2 != 0) {
            return n2;
        }
        if (string2 == null && string5 != null) {
            return -1;
        }
        if (string2 != null && string5 == null) {
            return 1;
        }
        if (string2 != null && (n2 = StringUtils.compareWithCase(string2, string5)) != 0) {
            return n2;
        }
        return StringUtils.compareIgnoreCase(string3, string6);
    }

    private ConfigSnapshot$SectionNames names() {
        ConfigSnapshot$SectionNames configSnapshot$SectionNames = this.names;
        if (configSnapshot$SectionNames == null) {
            this.names = configSnapshot$SectionNames = new ConfigSnapshot$SectionNames(this);
        }
        return configSnapshot$SectionNames;
    }

    static /* synthetic */ int access$100(String string, String string2, String string3, String string4, String string5, String string6) {
        return ConfigSnapshot.compare2(string, string2, string3, string4, string5, string6);
    }
}

